/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.emf.nattable.manager.axis;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.UnexecutableCommand;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.papyrus.infra.emf.gmf.command.GMFtoEMFCommandWrapper;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.nattable.manager.axis.AbstractAxisManager;
import org.eclipse.papyrus.infra.nattable.manager.table.INattableModelManager;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisconfiguration.AxisManagerRepresentation;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisconfiguration.EStructuralFeatureValueFillingConfiguration;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisconfiguration.IAxisConfiguration;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisprovider.AbstractAxisProvider;
import org.eclipse.papyrus.infra.nattable.utils.AxisUtils;
import org.eclipse.papyrus.infra.services.edit.service.ElementEditServiceUtils;
import org.eclipse.papyrus.infra.services.edit.service.IElementEditService;

public abstract class AbstractSynchronizedOnEStructuralFeatureAxisManager
extends AbstractAxisManager {
    protected Adapter featureListener;
    protected Collection<EStructuralFeature> listenFeatures;

    public void init(INattableModelManager manager, AxisManagerRepresentation rep, AbstractAxisProvider provider) {
        super.init(manager, rep, provider);
        this.verifyValues();
    }

    public boolean canDestroyAxisElement(Integer axisPosition) {
        Object current = this.getElements().get(axisPosition);
        Object elementToDestroy = AxisUtils.getRepresentedElement(current);
        if ((this.managedObject.contains(current) || this.managedObject.contains(elementToDestroy)) && elementToDestroy instanceof EObject) {
            return !EMFHelper.isReadOnly((EObject)((EObject)elementToDestroy));
        }
        return false;
    }

    protected void addListeners() {
        super.addListeners();
        this.addContextFeatureValueListener();
    }

    protected void initializeManagedObjectList() {
        for (Object current : this.getFeaturesValue()) {
            if (!this.isAllowedContents(current)) continue;
            this.managedObject.add(current);
        }
        super.initializeManagedObjectList();
    }

    protected List<Object> getFeaturesValue() {
        ArrayList<Object> featureValue = new ArrayList<Object>();
        for (EStructuralFeature current : this.getListenFeatures()) {
            if (!current.isMany()) continue;
            Object value = this.getTableContext().eGet(current);
            if (value instanceof Collection) {
                featureValue.addAll((Collection)value);
                continue;
            }
            featureValue.add(value);
        }
        return featureValue;
    }

    protected void updateManagedList(List<Object> toAdd, List<Object> toRemove) {
        if (!toAdd.isEmpty() || !toRemove.isEmpty()) {
            List<Object> newValue = new ArrayList<Object>(this.managedObject);
            newValue.removeAll(toRemove);
            newValue.addAll(toAdd);
            if (toAdd.size() > 0) {
                newValue = this.organizeContents(newValue);
            }
            this.managedObject.clear();
            this.managedObject.addAll(newValue);
            this.getTableManager().updateAxisContents(this.getRepresentedContentProvider());
        }
    }

    protected List<Object> organizeContents(List<Object> objects) {
        return objects;
    }

    protected void addContextFeatureValueListener() {
        this.featureListener = new AdapterImpl(){

            public void notifyChanged(Notification msg) {
                if (AbstractSynchronizedOnEStructuralFeatureAxisManager.this.getListenFeatures().contains(msg.getFeature())) {
                    AbstractSynchronizedOnEStructuralFeatureAxisManager.this.featureValueHasChanged(msg);
                }
            }
        };
        this.getTableContext().eAdapters().add((Object)this.featureListener);
    }

    protected void verifyValues() {
        Assert.isTrue((!this.getListenFeatures().isEmpty() ? 1 : 0) != 0);
        this.verifyFeatureMultiplicity();
    }

    protected Collection<EStructuralFeature> getListenFeatures() {
        if (this.listenFeatures == null) {
            this.listenFeatures = new ArrayList<EStructuralFeature>();
            Collection<EStructuralFeatureValueFillingConfiguration> configs = this.getFillingConfigurations();
            EList avalaibleFeatures = this.getTableContext().eClass().getEAllStructuralFeatures();
            for (EStructuralFeatureValueFillingConfiguration eStructuralFeatureValueFillingConfiguration : configs) {
                EStructuralFeature feature = eStructuralFeatureValueFillingConfiguration.getListenFeature();
                if (feature == null || !avalaibleFeatures.contains(feature) || this.listenFeatures.contains(feature)) continue;
                this.listenFeatures.add(feature);
            }
        }
        return this.listenFeatures;
    }

    protected Collection<EStructuralFeatureValueFillingConfiguration> getFillingConfigurations() {
        ArrayList<EStructuralFeatureValueFillingConfiguration> configs = new ArrayList<EStructuralFeatureValueFillingConfiguration>();
        for (IAxisConfiguration current : this.representedAxisManager.getSpecificAxisConfigurations()) {
            if (!(current instanceof EStructuralFeatureValueFillingConfiguration)) continue;
            configs.add((EStructuralFeatureValueFillingConfiguration)current);
        }
        return configs;
    }

    protected void removeListeners() {
        this.getTableContext().eAdapters().remove((Object)this.featureListener);
        super.removeListeners();
    }

    protected void verifyFeatureMultiplicity() {
        for (EStructuralFeature feature : this.getListenFeatures()) {
            Assert.isTrue((boolean)feature.isMany());
        }
    }

    public boolean canDropAxisElement(Collection<Object> objectsToAdd) {
        return false;
    }

    public boolean canInsertAxis(Collection<Object> objectsToAdd, int index) {
        return false;
    }

    public boolean canMoveAxis() {
        return false;
    }

    public final boolean isDynamic() {
        return true;
    }

    public boolean isSlave() {
        return false;
    }

    public boolean canEditAxisHeader() {
        return false;
    }

    public boolean canBeSavedAsConfig() {
        return false;
    }

    protected void featureValueHasChanged(Notification notification) {
        if (notification.isTouch()) {
            return;
        }
        int eventType = notification.getEventType();
        ArrayList<Object> toAdd = new ArrayList<Object>();
        ArrayList<Object> toRemove = new ArrayList<Object>();
        switch (eventType) {
            case 8: {
                break;
            }
            case 3: {
                Object newValue = notification.getNewValue();
                if (!this.isAllowedContents(newValue) || this.isAlreadyManaged(newValue)) break;
                toAdd.add(newValue);
                break;
            }
            case 5: {
                Collection newValues = (Collection)notification.getNewValue();
                for (Object current : newValues) {
                    if (!this.isAllowedContents(current) || this.isAlreadyManaged(current)) continue;
                    toAdd.add(current);
                }
                break;
            }
            case 10: {
                break;
            }
            case 7: {
                Collection collection = (Collection)((EObject)notification.getNotifier()).eGet((EStructuralFeature)notification.getFeature());
                Collection<EObject> subList = this.getSubFromFirstNotEquals(collection, (Integer)notification.getOldValue(), this.getIndex(collection, (EObject)notification.getNewValue()));
                toRemove.addAll(subList);
                toAdd.addAll(subList);
                break;
            }
            case 4: {
                Object oldValue = notification.getOldValue();
                if (!this.managedObject.contains(oldValue)) break;
                toRemove.add(oldValue);
                break;
            }
            case 6: {
                Collection oldValues = (Collection)notification.getOldValue();
                for (Object current : oldValues) {
                    if (!this.managedObject.contains(oldValues)) continue;
                    toRemove.add(current);
                }
                break;
            }
        }
        if (toAdd.size() > 0 || toRemove.size() > 0) {
            this.updateManagedList(toAdd, toRemove);
        }
    }

    protected Collection<EObject> getSubFromFirstNotEquals(Collection<EObject> modifiedObjects, int initialIndex, int modifiedIndex) {
        ArrayList<EObject> subList = new ArrayList<EObject>(modifiedObjects.size());
        if (initialIndex != modifiedIndex && -1 != modifiedIndex) {
            int minimalindex = initialIndex < modifiedIndex ? initialIndex : modifiedIndex;
            Iterator<EObject> modifiedObjectsIterator = modifiedObjects.iterator();
            int currentIndex = 0;
            while (modifiedObjectsIterator.hasNext()) {
                EObject modifiedObject = modifiedObjectsIterator.next();
                if (currentIndex >= minimalindex) {
                    subList.add(modifiedObject);
                }
                ++currentIndex;
            }
        }
        return subList;
    }

    protected int getIndex(Collection<EObject> modifiedObjects, EObject searchedObject) {
        int index = 0;
        boolean found = false;
        Iterator<EObject> iterator = modifiedObjects.iterator();
        while (iterator.hasNext() && !found) {
            if (iterator.next().equals(searchedObject)) {
                found = true;
                continue;
            }
            ++index;
        }
        return !found ? -1 : index;
    }

    public List<Object> getAllManagedAxis() {
        return new ArrayList<Object>(this.managedObject);
    }

    public Command getDestroyAxisElementCommand(TransactionalEditingDomain domain, Integer axisPosition) {
        Object current;
        Object elementToDestroy;
        if (this.canDestroyAxisElement(axisPosition) && (elementToDestroy = AxisUtils.getRepresentedElement(current = this.getElements().get(axisPosition))) != null && elementToDestroy instanceof EObject) {
            DestroyElementRequest request = new DestroyElementRequest(this.getContextEditingDomain(), (EObject)elementToDestroy, false);
            IElementEditService provider = ElementEditServiceUtils.getCommandProvider((Object)elementToDestroy);
            return new AbstractAxisManager.RemoveCommandWrapper((AbstractAxisManager)this, (Command)new GMFtoEMFCommandWrapper(provider.getEditCommand((IEditCommandRequest)request)), Collections.singleton(elementToDestroy));
        }
        return UnexecutableCommand.INSTANCE;
    }
}

