/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.opencert.vocabulary.generatefrommodel.importer;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.opencert.vocabulary.generatefrommodel.importer.ProjectContentProvider;
import org.eclipse.opencert.vocabulary.generatefrommodel.importer.ProjectLabelProvider;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class ImportWizardPage
extends WizardPage {
    private static final String vocabSuffix = ".vocabulary";
    private TreeViewer sourceProjectTreeViewer;
    private Text targetVocabText;
    private boolean targetVocabOkay = false;
    private IProject initalSelection;

    public ImportWizardPage(String pageName, IProject selectedProject) {
        super(pageName);
        this.initalSelection = selectedProject;
        this.setTitle(pageName);
        this.setDescription("Import vocabulary data from the CCL models of a local project");
    }

    public void createControl(Composite parent) {
        Composite dialogArea = new Composite(parent, 0);
        GridData dialogData = new GridData(768);
        dialogArea.setLayoutData((Object)dialogData);
        GridLayout dialogAreaLayout = new GridLayout();
        dialogAreaLayout.numColumns = 1;
        dialogAreaLayout.makeColumnsEqualWidth = false;
        dialogAreaLayout.marginWidth = 0;
        dialogAreaLayout.marginHeight = 0;
        dialogArea.setLayout((Layout)dialogAreaLayout);
        this.createProjectSelectionArea(dialogArea);
        this.setControl((Control)dialogArea);
        this.setPageComplete(false);
    }

    private void createProjectSelectionArea(Composite dialogArea) {
        Composite resourcesArea = new Composite(dialogArea, 0);
        GridData resourcesData = new GridData(1808);
        resourcesArea.setLayoutData((Object)resourcesData);
        GridLayout resourcesLayout = new GridLayout();
        resourcesLayout.numColumns = 2;
        resourcesLayout.marginWidth = 0;
        resourcesLayout.marginHeight = 0;
        resourcesArea.setLayout((Layout)resourcesLayout);
        this.sourceProjectTreeViewer = new TreeViewer(resourcesArea, 4);
        GridData treeData = new GridData(1808);
        treeData.horizontalSpan = 2;
        this.sourceProjectTreeViewer.getControl().setLayoutData((Object)treeData);
        this.sourceProjectTreeViewer.setAutoExpandLevel(2);
        ProjectContentProvider cp = new ProjectContentProvider();
        this.sourceProjectTreeViewer.setContentProvider((IContentProvider)cp);
        this.sourceProjectTreeViewer.setLabelProvider((IBaseLabelProvider)new ProjectLabelProvider());
        this.sourceProjectTreeViewer.setComparator(new ViewerComparator());
        this.sourceProjectTreeViewer.setUseHashlookup(true);
        this.sourceProjectTreeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ISelection selection = event.getSelection();
                this.expand(selection);
            }

            private void expand(ISelection selection) {
                if (selection instanceof IStructuredSelection) {
                    Object item = ((IStructuredSelection)selection).getFirstElement();
                    if (item == null) {
                        return;
                    }
                    if (ImportWizardPage.this.sourceProjectTreeViewer.getExpandedState(item)) {
                        ImportWizardPage.this.sourceProjectTreeViewer.collapseToLevel(item, 1);
                    } else {
                        ImportWizardPage.this.sourceProjectTreeViewer.expandToLevel(item, 1);
                    }
                }
            }
        });
        this.sourceProjectTreeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IResource resource;
                ISelection selection = event.getSelection();
                if (!selection.isEmpty() && (resource = (IResource)((IStructuredSelection)selection).getFirstElement()) instanceof IContainer) {
                    String path = resource.getFullPath().toString();
                    ImportWizardPage.this.targetVocabText.setText(String.valueOf(path) + "/CCL.vocabulary");
                    ImportWizardPage.this.validateTargetVocab(ImportWizardPage.this.targetVocabText.getText());
                }
            }
        });
        this.sourceProjectTreeViewer.setInput((Object)ResourcesPlugin.getWorkspace().getRoot().getProjects());
        if (this.initalSelection != null) {
            this.sourceProjectTreeViewer.setSelection((ISelection)new StructuredSelection(new Object[]{this.initalSelection}));
        }
        Label resourceNameLabel = new Label(resourcesArea, 0);
        resourceNameLabel.setText("Path for the new Resource:  ");
        this.targetVocabText = new Text(resourcesArea, 2052);
        GridData resourceNameData = new GridData(768);
        this.targetVocabText.setLayoutData((Object)resourceNameData);
        this.targetVocabText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String text = ((Text)e.getSource()).getText();
                ImportWizardPage.this.validateTargetVocab(text);
            }
        });
    }

    private void validateTargetVocab(String text) {
        if (text.length() < vocabSuffix.length() + 1 || !text.toLowerCase().endsWith(vocabSuffix) || !text.contains("/")) {
            this.setErrorMessage("Specify a valid vocabulary path with the '.vocabulary' extension.");
            this.targetVocabOkay = false;
            this.updatePageComplete();
            return;
        }
        String containerPath = text.substring(0, text.lastIndexOf("/"));
        IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember(containerPath);
        if (resource == null || !(resource instanceof IContainer)) {
            this.setErrorMessage("The vocabulary must be contained in a project or folder.");
            this.targetVocabOkay = false;
            this.updatePageComplete();
            return;
        }
        this.targetVocabOkay = true;
        this.setErrorMessage(null);
        this.updatePageComplete();
    }

    private void updatePageComplete() {
        this.setPageComplete(this.targetVocabOkay);
    }

    public IProject getProject() {
        String text = this.targetVocabText.getText();
        String containerPath = text.substring(0, text.lastIndexOf("/"));
        IProject project = ResourcesPlugin.getWorkspace().getRoot().findMember(containerPath).getProject();
        return project;
    }

    public IContainer getVocabContainer() {
        String text = this.targetVocabText.getText();
        String containerPath = text.substring(0, text.lastIndexOf("/"));
        IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember(containerPath);
        return (IContainer)resource;
    }

    public String getVocabFilename() {
        String text = this.targetVocabText.getText();
        return text;
    }
}

