/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.emf.facet.custom.metamodel.v0_2_0.custom.presentation;

import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.command.BasicCommandStack;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.command.CommandStackListener;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.ui.MarkerHelper;
import org.eclipse.emf.common.ui.URIEditorInput;
import org.eclipse.emf.common.ui.ViewerPane;
import org.eclipse.emf.common.ui.editor.ProblemEditorPart;
import org.eclipse.emf.common.ui.viewer.IViewerProvider;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.command.MoveCommand;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.edit.provider.AdapterFactoryItemDelegator;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.edit.provider.resource.ResourceItemProviderAdapterFactory;
import org.eclipse.emf.edit.ui.action.EditingDomainActionBarContributor;
import org.eclipse.emf.edit.ui.celleditor.AdapterFactoryTreeEditor;
import org.eclipse.emf.edit.ui.dnd.EditingDomainViewerDropAdapter;
import org.eclipse.emf.edit.ui.dnd.LocalTransfer;
import org.eclipse.emf.edit.ui.dnd.ViewerDragAdapter;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.emf.edit.ui.provider.UnwrappingSelectionProvider;
import org.eclipse.emf.edit.ui.util.EditUIMarkerHelper;
import org.eclipse.emf.edit.ui.view.ExtendedPropertySheetPage;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.papyrus.emf.facet.custom.metamodel.v0_2_0.custom.Customization;
import org.eclipse.papyrus.emf.facet.custom.metamodel.v0_2_0.custom.EClassCustomization;
import org.eclipse.papyrus.emf.facet.custom.metamodel.v0_2_0.custom.FacetCustomization;
import org.eclipse.papyrus.emf.facet.custom.metamodel.v0_2_0.custom.presentation.CustomEditorPlugin;
import org.eclipse.papyrus.emf.facet.custom.metamodel.v0_2_0.custom.presentation.CustomViewer;
import org.eclipse.papyrus.emf.facet.custom.metamodel.v0_2_0.custom.presentation.FormStyleSashForm;
import org.eclipse.papyrus.emf.facet.custom.metamodel.v0_2_0.custom.provider.CustomItemProviderAdapterFactory;
import org.eclipse.papyrus.emf.facet.custom.sdk.ui.dialog.ICustomizationDialogFactory;
import org.eclipse.papyrus.emf.facet.efacet.metamodel.v0_2_0.efacet.DerivedTypedElement;
import org.eclipse.papyrus.emf.facet.efacet.metamodel.v0_2_0.efacet.EFacetPackage;
import org.eclipse.papyrus.emf.facet.efacet.metamodel.v0_2_0.efacet.Facet;
import org.eclipse.papyrus.emf.facet.efacet.metamodel.v0_2_0.efacet.FacetAttribute;
import org.eclipse.papyrus.emf.facet.efacet.metamodel.v0_2_0.efacet.FacetElement;
import org.eclipse.papyrus.emf.facet.efacet.metamodel.v0_2_0.efacet.FacetOperation;
import org.eclipse.papyrus.emf.facet.efacet.metamodel.v0_2_0.efacet.FacetReference;
import org.eclipse.papyrus.emf.facet.efacet.metamodel.v0_2_0.efacet.extensible.provider.ExtensibleItemProviderAdapterFactory;
import org.eclipse.papyrus.emf.facet.efacet.metamodel.v0_2_0.efacet.provider.EFacetItemProviderAdapterFactory;
import org.eclipse.papyrus.emf.facet.efacet.metamodel.v0_2_0.efacet.query.provider.QueryItemProviderAdapterFactory;
import org.eclipse.papyrus.emf.facet.efacet.metamodel.v0_2_0.efacet.runtime.provider.RuntimeItemProviderAdapterFactory;
import org.eclipse.papyrus.emf.facet.efacet.metamodel.v0_2_0.efacet.serialization.provider.SerializationItemProviderAdapterFactory;
import org.eclipse.papyrus.emf.facet.efacet.sdk.ui.dialog.IFacetDialogFactory;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.SaveAsDialog;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.ide.IGotoMarker;
import org.eclipse.ui.part.EditorPart;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.IPage;
import org.eclipse.ui.views.contentoutline.ContentOutline;
import org.eclipse.ui.views.contentoutline.ContentOutlinePage;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.IPropertySourceProvider;
import org.eclipse.ui.views.properties.PropertySheet;
import org.eclipse.ui.views.properties.PropertySheetPage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CustomEditor
extends EditorPart
implements IGotoMarker,
ISelectionProvider,
IMenuListener,
IEditingDomainProvider,
IViewerProvider {
    protected Customization mainCustomization;
    protected ComposedAdapterFactory adapterFactory;
    protected CustomViewer customizationViewer;
    protected Collection<Resource> changedResources = new ArrayList<Resource>();
    protected Collection<Resource> savedResources = new ArrayList<Resource>();
    protected Collection<Resource> removedResources = new ArrayList<Resource>();
    protected ISelection editorSelection = StructuredSelection.EMPTY;
    protected ISelectionChangedListener selectionChangedListener;
    protected Collection<ISelectionChangedListener> selectionChangedListeners = new ArrayList<ISelectionChangedListener>();
    protected boolean updateProblemIndication = true;
    protected TreeViewer contentOutlineViewer;
    protected IStatusLineManager contentOutlineStatusLineManager;
    protected Map<Resource, Diagnostic> resourceToDiagnosticMap = new LinkedHashMap<Resource, Diagnostic>();
    protected MarkerHelper markerHelper = new EditUIMarkerHelper();
    protected PropertySheetPage propertySheetPage;
    protected IContentOutlinePage contentOutlinePage;
    protected Composite buttonsPaneComposite;
    private static final int VERTICAL_SPACE_BETWEEN_BUTTON_GROUPS = 30;
    private static final int VERTICAL_SPACE_BEFORE_FIRST_BUTTON = 10;
    public static final String ID = "org.eclipse.papyrus.emf.facet.infra.browser.custom.editor";
    private static final int MAIN_FORM_MARGIN_WIDTH = 4;
    private static final int MAIN_FORM_MARGIN_HEIGHT = 6;
    private static final int LEFT_PANE_SASH_WEIGHT = 400;
    private static final int RIGHT_PANE_SASH_WEIGHT = 600;
    private TreeViewer selectionViewer;
    private Button btnEdit;
    private Button btnRemove;
    private Button btnUp;
    private Button btnDown;
    private Button cbAppliesToSubinstances;
    private FormToolkit toolkit;
    private boolean readOnly;
    protected int listenerCounter = 0;
    private Form fForm;
    private AdapterFactoryEditingDomain editingDomain;
    protected IResourceChangeListener resourceChangeListener = new IResourceChangeListener(){

        public void resourceChanged(IResourceChangeEvent event) {
            IResourceDelta delta = event.getDelta();
            try {
                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                class ResourceDeltaVisitor
                implements IResourceDeltaVisitor {
                    protected ResourceSet resourceSet;
                    protected Collection<Resource> changedResources;
                    protected Collection<Resource> removedResources;

                    ResourceDeltaVisitor() {
                        this.resourceSet = CustomEditor.this.editingDomain.getResourceSet();
                        this.changedResources = new ArrayList<Resource>();
                        this.removedResources = new ArrayList<Resource>();
                    }

                    public boolean visit(IResourceDelta delta) {
                        Resource resource;
                        if (delta.getResource().getType() == 1 && (delta.getKind() == 2 || delta.getKind() == 4 && delta.getFlags() != 131072) && (resource = this.resourceSet.getResource(URI.createPlatformResourceURI((String)delta.getFullPath().toString(), (boolean)true), false)) != null) {
                            if (delta.getKind() == 2) {
                                this.removedResources.add(resource);
                            } else if (!(this).CustomEditor.this.savedResources.remove(resource)) {
                                this.changedResources.add(resource);
                            }
                        }
                        return true;
                    }

                    public Collection<Resource> getChangedResources() {
                        return this.changedResources;
                    }

                    public Collection<Resource> getRemovedResources() {
                        return this.removedResources;
                    }
                }
                final ResourceDeltaVisitor visitor = new ResourceDeltaVisitor();
                delta.accept((IResourceDeltaVisitor)visitor);
                if (!visitor.getRemovedResources().isEmpty()) {
                    CustomEditor.this.getSite().getShell().getDisplay().asyncExec(new Runnable(){
                        {
                        }

                        public void run() {
                            (this).CustomEditor.this.removedResources.addAll(visitor.getRemovedResources());
                            if (!CustomEditor.this.isDirty()) {
                                CustomEditor.this.getSite().getPage().closeEditor((IEditorPart)CustomEditor.this, false);
                            }
                        }
                    });
                }
                if (!visitor.getChangedResources().isEmpty()) {
                    CustomEditor.this.getSite().getShell().getDisplay().asyncExec(new Runnable(){
                        {
                        }

                        public void run() {
                            (this).CustomEditor.this.changedResources.addAll(visitor.getChangedResources());
                            if (CustomEditor.this.getSite().getPage().getActiveEditor() == CustomEditor.this) {
                                CustomEditor.this.handleActivate();
                            }
                        }
                    });
                }
            }
            catch (CoreException exception) {
                CustomEditorPlugin.INSTANCE.log((Object)exception);
            }
        }
    };
    private Composite rightPaneComposite;
    private final IPartListener partListener = new IPartListener(){

        public void partActivated(IWorkbenchPart p) {
            if (p instanceof ContentOutline) {
                if (((ContentOutline)p).getCurrentPage() == CustomEditor.this.contentOutlinePage) {
                    CustomEditor.this.getActionBarContributor().setActiveEditor((IEditorPart)CustomEditor.this);
                    if (CustomEditor.this.selectionChangedListener == null) {
                        CustomEditor.this.selectionChangedListener = new ISelectionChangedListener(){

                            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                                CustomEditor.this.setSelection(selectionChangedEvent.getSelection());
                            }
                        };
                    }
                    CustomEditor.this.setSelection((ISelection)(CustomEditor.this.selectionViewer == null ? StructuredSelection.EMPTY : CustomEditor.this.selectionViewer.getSelection()));
                }
            } else if (p instanceof PropertySheet) {
                if (((PropertySheet)p).getCurrentPage() == CustomEditor.this.propertySheetPage) {
                    CustomEditor.this.getActionBarContributor().setActiveEditor((IEditorPart)CustomEditor.this);
                    CustomEditor.this.handleActivate();
                }
            } else if (p == CustomEditor.this) {
                CustomEditor.this.handleActivate();
                if (CustomEditor.this.selectionChangedListener == null) {
                    CustomEditor.this.selectionChangedListener = new ISelectionChangedListener(){

                        public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                            CustomEditor.this.setSelection(selectionChangedEvent.getSelection());
                        }
                    };
                }
                CustomEditor.this.selectionViewer.addSelectionChangedListener(CustomEditor.this.selectionChangedListener);
                CustomEditor.this.setSelection(CustomEditor.this.selectionViewer.getSelection());
            }
        }

        public void partBroughtToTop(IWorkbenchPart p) {
        }

        public void partClosed(IWorkbenchPart p) {
        }

        public void partDeactivated(IWorkbenchPart p) {
        }

        public void partOpened(IWorkbenchPart p) {
        }
    };
    private Button btnAddFacetSet;
    private Button btnAddFacet;
    private Button btnAddEClassCustom;
    private Button btnAddFacetCustom;
    private Button btnAddFacetAttr;
    private Button btnAddFacetRef;
    private Button btnAddFacetOp;
    private Button btnAddFacetParam;

    public CustomEditor() {
        this.initializeEditingDomain();
    }

    protected void initializeEditingDomain() {
        this.adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
        this.adapterFactory.addAdapterFactory((AdapterFactory)new ResourceItemProviderAdapterFactory());
        this.adapterFactory.addAdapterFactory((AdapterFactory)new CustomItemProviderAdapterFactory());
        this.adapterFactory.addAdapterFactory((AdapterFactory)new EFacetItemProviderAdapterFactory());
        this.adapterFactory.addAdapterFactory((AdapterFactory)new SerializationItemProviderAdapterFactory());
        this.adapterFactory.addAdapterFactory((AdapterFactory)new ExtensibleItemProviderAdapterFactory());
        this.adapterFactory.addAdapterFactory((AdapterFactory)new QueryItemProviderAdapterFactory());
        this.adapterFactory.addAdapterFactory((AdapterFactory)new RuntimeItemProviderAdapterFactory());
        this.adapterFactory.addAdapterFactory((AdapterFactory)new ReflectiveItemProviderAdapterFactory());
        BasicCommandStack commandStack = new BasicCommandStack();
        commandStack.addCommandStackListener(new CommandStackListener(){

            public void commandStackChanged(final EventObject event) {
                CustomEditor.this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        CustomEditor.this.firePropertyChange(257);
                        Command mostRecentCommand = ((CommandStack)event.getSource()).getMostRecentCommand();
                        if (mostRecentCommand != null) {
                            CustomEditor.this.setSelectionToViewer(mostRecentCommand.getAffectedObjects());
                        }
                        if ((this).CustomEditor.this.propertySheetPage != null && !(this).CustomEditor.this.propertySheetPage.getControl().isDisposed()) {
                            (this).CustomEditor.this.propertySheetPage.refresh();
                        }
                    }
                });
            }
        });
        this.editingDomain = new AdapterFactoryEditingDomain((AdapterFactory)this.adapterFactory, (CommandStack)commandStack, new HashMap());
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.setSite((IWorkbenchPartSite)site);
        this.setInputWithNotify(input);
        this.setPartName(input.getName());
        site.setSelectionProvider((ISelectionProvider)this);
        site.getPage().addPartListener(this.partListener);
        ResourcesPlugin.getWorkspace().addResourceChangeListener(this.resourceChangeListener, 1);
    }

    public void setSelectionToViewer(Collection<?> collection) {
        final Collection<?> theSelection = collection;
        if (theSelection != null && !theSelection.isEmpty()) {
            Runnable runnable = new Runnable(){

                public void run() {
                    if (CustomEditor.this.selectionViewer != null) {
                        CustomEditor.this.selectionViewer.setSelection((ISelection)new StructuredSelection(theSelection.toArray()), true);
                    }
                }
            };
            this.getSite().getShell().getDisplay().asyncExec(runnable);
        }
    }

    public void createPartControl(Composite parent) {
        java.net.URI locationURI;
        String fileName = "";
        IEditorInput editorInput = this.getEditorInput();
        if (editorInput instanceof IFileEditorInput) {
            IFileEditorInput fileEditorInput = (IFileEditorInput)editorInput;
            try {
                locationURI = fileEditorInput.getFile().exists() ? new java.net.URI(URI.createPlatformResourceURI((String)fileEditorInput.getFile().getFullPath().toString(), (boolean)true).toString()) : fileEditorInput.getFile().getLocationURI();
            }
            catch (URISyntaxException e) {
                locationURI = fileEditorInput.getFile().getLocationURI();
            }
            fileName = fileEditorInput.getFile().getName();
        } else if (editorInput instanceof URIEditorInput) {
            URIEditorInput uriEditorInput = (URIEditorInput)editorInput;
            try {
                locationURI = new java.net.URI(uriEditorInput.getURI().toString());
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException(e);
            }
            fileName = new Path(locationURI.getPath()).lastSegment();
        } else {
            throw new IllegalStateException("wrong kind of input: " + editorInput.getClass().getName());
        }
        this.loadResource(URI.createURI((String)locationURI.toString()));
        this.setPartName(fileName);
        this.createContents(parent);
        this.selectionViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (CustomEditor.this.listenerCounter == 0) {
                    ISelection eventSelection = event.getSelection();
                    CustomEditor.this.setSelection(eventSelection);
                    ITreeSelection selection = (ITreeSelection)CustomEditor.this.selectionViewer.getSelection();
                    ++CustomEditor.this.listenerCounter;
                    CustomEditor.this.handleSelectionViewerSelectionChanged(selection.getFirstElement());
                    CustomEditor.this.listenerCounter = 0;
                    CustomEditor.this.customizationViewer.getViewer().getControl().setRedraw(false);
                    CustomEditor.this.customizationViewer.getViewer().expandAll();
                    CustomEditor.this.customizationViewer.getViewer().getControl().setRedraw(true);
                } else {
                    CustomEditor.this.listenerCounter = 0;
                }
            }
        });
        this.setSelection((ISelection)(this.selectionViewer == null ? StructuredSelection.EMPTY : this.selectionViewer.getSelection()));
    }

    public void loadResource(URI resourceURI) {
        Exception exception = null;
        Resource resource = null;
        try {
            resource = this.editingDomain.getResourceSet().getResource(resourceURI, true);
        }
        catch (Exception e) {
            exception = e;
            resource = this.editingDomain.getResourceSet().getResource(resourceURI, false);
        }
        this.mainCustomization = (Customization)resource.getContents().get(0);
    }

    private void createContents(Composite parent) {
        this.toolkit = new FormToolkit(parent.getDisplay());
        this.fForm = this.toolkit.createForm(parent);
        this.toolkit.decorateFormHeading(this.fForm);
        FillLayout fillLayout = new FillLayout();
        fillLayout.marginWidth = 4;
        fillLayout.marginHeight = 6;
        this.fForm.getBody().setLayout((Layout)fillLayout);
        this.createBottomPane(this.fForm.getBody());
    }

    private Composite createBottomPane(Composite parent) {
        FormStyleSashForm sashForm = new FormStyleSashForm(parent, 256, this.toolkit){

            protected void createContents() {
                CustomEditor.this.createLeftPane((Composite)this);
                CustomEditor.this.createRightPane((Composite)this);
            }
        };
        sashForm.setWeights(new int[]{400, 600});
        sashForm.setSashWidth(5);
        return sashForm;
    }

    private void createLeftPane(Composite parent) {
        ViewerPane viewerPane = new ViewerPane(this.getSite().getPage(), (IWorkbenchPart)this){

            public Viewer createViewer(Composite composite) {
                Tree tree = new Tree(composite, 2);
                TreeViewer newTreeViewer = new TreeViewer(tree);
                return newTreeViewer;
            }
        };
        viewerPane.createControl(parent);
        this.selectionViewer = (TreeViewer)viewerPane.getViewer();
        this.selectionViewer.setContentProvider((IContentProvider)new AdapterFactoryContentProvider((AdapterFactory)this.adapterFactory));
        this.selectionViewer.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider((AdapterFactory)this.adapterFactory));
        this.selectionViewer.setInput((Object)this.editingDomain.getResourceSet());
        this.selectionViewer.setSelection((ISelection)new StructuredSelection(this.editingDomain.getResourceSet().getResources().get(0)), true);
        viewerPane.setTitle((Object)this.editingDomain.getResourceSet());
        new AdapterFactoryTreeEditor(this.selectionViewer.getTree(), (AdapterFactory)this.adapterFactory);
        this.createContextMenuFor((StructuredViewer)this.selectionViewer);
    }

    private Composite createRightPane(Composite parent) {
        Section section = this.toolkit.createSection(parent, 320);
        this.rightPaneComposite = this.toolkit.createComposite((Composite)section, 0);
        section.setClient((Control)this.rightPaneComposite);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        this.rightPaneComposite.setLayout((Layout)gridLayout);
        Composite middle = new Composite(this.rightPaneComposite, 0);
        GridLayout middleLayout = new GridLayout();
        middleLayout.marginHeight = 0;
        middleLayout.marginWidth = 0;
        middle.setLayout((Layout)middleLayout);
        middle.setLayoutData((Object)new GridData(4, 4, true, true));
        this.customizationViewer = new CustomViewer(middle);
        this.customizationViewer.getViewer().getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        Composite optionsPane = this.toolkit.createComposite(middle);
        optionsPane.setLayout((Layout)new GridLayout());
        optionsPane.setLayoutData((Object)new GridData(4, 4, true, false));
        this.customizationViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (CustomEditor.this.listenerCounter == 0) {
                    ISelection eventSelection = event.getSelection();
                    CustomEditor.this.setSelection(eventSelection);
                    ITreeSelection selection = (ITreeSelection)CustomEditor.this.customizationViewer.getSelection();
                    CustomEditor.this.handleCustomzizationViewerSelectionChanged(selection.getFirstElement());
                    ++CustomEditor.this.listenerCounter;
                } else {
                    CustomEditor.this.listenerCounter = 0;
                }
            }
        });
        if (this.readOnly) {
            this.cbAppliesToSubinstances.setEnabled(false);
        }
        GridData customizationViewerGridData = new GridData();
        customizationViewerGridData.grabExcessHorizontalSpace = true;
        customizationViewerGridData.grabExcessVerticalSpace = true;
        customizationViewerGridData.horizontalAlignment = 4;
        customizationViewerGridData.verticalAlignment = 4;
        this.customizationViewer.getViewer().getControl().setLayoutData((Object)customizationViewerGridData);
        if (!this.readOnly) {
            this.createButtonsPane(this.rightPaneComposite);
        }
        return this.rightPaneComposite;
    }

    private void setInputInCustomizationTreeviewer(Facet facet) {
        ArrayList<DerivedTypedElement> inputs = new ArrayList<DerivedTypedElement>();
        inputs.addAll((Collection<DerivedTypedElement>)facet.getFacetOperations());
        EList facetElements = facet.getFacetElements();
        for (EStructuralFeature eStructuralFeature : facetElements) {
            if (!(eStructuralFeature instanceof DerivedTypedElement)) continue;
            inputs.add((DerivedTypedElement)eStructuralFeature);
        }
        this.customizationViewer.setInput(inputs);
    }

    private void handleSelectionViewerSelectionChanged(Object selectedElement) {
        if (selectedElement instanceof EClassCustomization || selectedElement instanceof FacetCustomization) {
            Facet facet = (Facet)selectedElement;
            this.setInputInCustomizationTreeviewer(facet);
            this.buttonsPaneComposite.dispose();
            this.createButtonsPaneWhenFacetIsSelected(this.rightPaneComposite);
            this.rightPaneComposite.layout();
        } else if (selectedElement instanceof Customization) {
            this.buttonsPaneComposite.dispose();
            this.createButtonsPaneWhenCustomizationIsSelected(this.rightPaneComposite);
            this.rightPaneComposite.layout();
        } else if (selectedElement instanceof DerivedTypedElement) {
            this.buttonsPaneComposite.dispose();
            this.createButtonsPaneWhenDerivedIsSelected(this.rightPaneComposite);
            this.rightPaneComposite.layout();
            DerivedTypedElement derivedTypeElement = (DerivedTypedElement)selectedElement;
            Facet facet = (Facet)derivedTypeElement.eContainer();
            ArrayList<DerivedTypedElement> inputs = new ArrayList<DerivedTypedElement>();
            inputs.addAll((Collection<DerivedTypedElement>)facet.getFacetOperations());
            EList facetElements = facet.getFacetElements();
            for (EStructuralFeature eStructuralFeature : facetElements) {
                if (!(eStructuralFeature instanceof DerivedTypedElement)) continue;
                inputs.add((DerivedTypedElement)eStructuralFeature);
            }
            this.customizationViewer.setInput(inputs);
            this.customizationViewer.getViewer().setSelection(this.getSelection(), true);
        }
    }

    private void handleCustomzizationViewerSelectionChanged(Object selectedElement) {
        this.setSelection(this.customizationViewer.getViewer().getSelection());
        if (selectedElement instanceof FacetOperation || selectedElement instanceof FacetElement) {
            this.buttonsPaneComposite.dispose();
            this.createButtonsPaneWhenDerivedIsSelected(this.rightPaneComposite);
            this.rightPaneComposite.layout();
        }
    }

    private void btnEditClicked() {
        Object selectedObject;
        if (this.readOnly) {
            return;
        }
        ISelection selectedElement = this.getSelection();
        if (selectedElement instanceof TreeSelection && (selectedObject = ((TreeSelection)selectedElement).getFirstElement()) != null) {
            if (selectedObject instanceof Facet) {
                IFacetDialogFactory.INSTANCE.openEditFacetDialog();
            } else if (selectedObject instanceof FacetAttribute) {
                IFacetDialogFactory.INSTANCE.openEditFacetAttributeDialog();
            } else if (selectedObject instanceof FacetOperation) {
                IFacetDialogFactory.INSTANCE.openEditFacetOperationDialog();
            } else if (selectedObject instanceof FacetReference) {
                IFacetDialogFactory.INSTANCE.openEditFacetReferenceDialog();
            } else if (selectedObject instanceof DerivedTypedElement) {
                IFacetDialogFactory.INSTANCE.openEditFacetOperationParameterDialog();
            } else if (selectedObject instanceof Customization) {
                ICustomizationDialogFactory.DEFAULT.openAddCustomizationPropertyDialog(this.getSite().getShell().getDisplay(), (EditingDomain)this.editingDomain);
            }
        }
    }

    public void doSave(IProgressMonitor monitor) {
        final HashMap<String, String> saveOptions = new HashMap<String, String>();
        saveOptions.put("SAVE_ONLY_IF_CHANGED", "MEMORY_BUFFER");
        WorkspaceModifyOperation operation = new WorkspaceModifyOperation(){

            public void execute(IProgressMonitor monitor) {
                boolean first = true;
                for (Resource resource : CustomEditor.this.editingDomain.getResourceSet().getResources()) {
                    if (!first && resource.getContents().isEmpty() && !CustomEditor.this.isPersisted(resource) || CustomEditor.this.editingDomain.isReadOnly(resource)) continue;
                    try {
                        long timeStamp = resource.getTimeStamp();
                        resource.save(saveOptions);
                        if (resource.getTimeStamp() != timeStamp) {
                            CustomEditor.this.savedResources.add(resource);
                        }
                    }
                    catch (Exception exception) {
                        CustomEditor.this.resourceToDiagnosticMap.put(resource, CustomEditor.this.analyzeResourceProblems(resource, exception));
                    }
                    first = false;
                }
            }
        };
        this.updateProblemIndication = false;
        try {
            new ProgressMonitorDialog(this.getSite().getShell()).run(true, false, (IRunnableWithProgress)operation);
            ((BasicCommandStack)this.editingDomain.getCommandStack()).saveIsDone();
            this.firePropertyChange(257);
        }
        catch (Exception exception) {
            CustomEditorPlugin.INSTANCE.log(exception);
        }
        this.updateProblemIndication = true;
        this.updateProblemIndication();
    }

    protected boolean isPersisted(Resource resource) {
        boolean result = false;
        try {
            InputStream stream = this.editingDomain.getResourceSet().getURIConverter().createInputStream(resource.getURI());
            if (stream != null) {
                result = true;
                stream.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result;
    }

    public IContentOutlinePage getContentOutlinePage() {
        if (this.contentOutlinePage == null) {
            class MyContentOutlinePage
            extends ContentOutlinePage {
                MyContentOutlinePage() {
                }

                public void createControl(Composite parent) {
                    super.createControl(parent);
                    CustomEditor.this.contentOutlineViewer = this.getTreeViewer();
                    CustomEditor.this.contentOutlineViewer.addSelectionChangedListener((ISelectionChangedListener)this);
                    CustomEditor.this.contentOutlineViewer.setContentProvider((IContentProvider)new AdapterFactoryContentProvider((AdapterFactory)CustomEditor.this.adapterFactory));
                    CustomEditor.this.contentOutlineViewer.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider((AdapterFactory)CustomEditor.this.adapterFactory));
                    CustomEditor.this.contentOutlineViewer.setInput((Object)CustomEditor.this.editingDomain.getResourceSet());
                    CustomEditor.this.createContextMenuFor((StructuredViewer)CustomEditor.this.contentOutlineViewer);
                    if (!CustomEditor.this.editingDomain.getResourceSet().getResources().isEmpty()) {
                        CustomEditor.this.contentOutlineViewer.setSelection((ISelection)new StructuredSelection(CustomEditor.this.editingDomain.getResourceSet().getResources().get(0)), true);
                    }
                }

                public void makeContributions(IMenuManager menuManager, IToolBarManager toolBarManager, IStatusLineManager statusLineManager) {
                    super.makeContributions(menuManager, toolBarManager, statusLineManager);
                    CustomEditor.this.contentOutlineStatusLineManager = statusLineManager;
                }

                public void setActionBars(IActionBars actionBars) {
                    super.setActionBars(actionBars);
                    CustomEditor.this.getActionBarContributor().shareGlobalActions((IPage)this, actionBars);
                }
            }
            this.contentOutlinePage = new MyContentOutlinePage();
            this.contentOutlinePage.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    CustomEditor.this.handleContentOutlineSelection(event.getSelection());
                }
            });
        }
        return this.contentOutlinePage;
    }

    public IPropertySheetPage getPropertySheetPage() {
        if (this.propertySheetPage == null) {
            this.propertySheetPage = new ExtendedPropertySheetPage(this.editingDomain){

                public void setSelectionToViewer(List<?> selection) {
                    CustomEditor.this.setSelectionToViewer(selection);
                    CustomEditor.this.setFocus();
                }

                public void setActionBars(IActionBars actionBars) {
                    super.setActionBars(actionBars);
                    CustomEditor.this.getActionBarContributor().shareGlobalActions((IPage)this, actionBars);
                }
            };
            this.propertySheetPage.setPropertySourceProvider((IPropertySourceProvider)new AdapterFactoryContentProvider((AdapterFactory)this.adapterFactory));
        }
        return this.propertySheetPage;
    }

    public Object getAdapter(Class key) {
        if (key.equals(IContentOutlinePage.class)) {
            return this.showOutlineView() ? this.getContentOutlinePage() : null;
        }
        if (key.equals(IPropertySheetPage.class)) {
            return this.getPropertySheetPage();
        }
        if (key.equals(IGotoMarker.class)) {
            return this;
        }
        return super.getAdapter(key);
    }

    protected boolean showOutlineView() {
        return true;
    }

    public void handleContentOutlineSelection(ISelection selection) {
        Iterator selectedElements;
        if (!selection.isEmpty() && selection instanceof IStructuredSelection && (selectedElements = ((IStructuredSelection)selection).iterator()).hasNext()) {
            Object selectedElement = selectedElements.next();
            ArrayList selectionList = new ArrayList();
            selectionList.add(selectedElement);
            while (selectedElements.hasNext()) {
                selectionList.add(selectedElements.next());
            }
            this.selectionViewer.setSelection((ISelection)new StructuredSelection(selectionList));
        }
    }

    protected void doSaveAs(URI uri, IEditorInput editorInput) {
        ((Resource)this.editingDomain.getResourceSet().getResources().get(0)).setURI(uri);
        this.setInputWithNotify(editorInput);
        this.setPartName(editorInput.getName());
        NullProgressMonitor progressMonitor = this.getActionBars().getStatusLineManager() != null ? this.getActionBars().getStatusLineManager().getProgressMonitor() : new NullProgressMonitor();
        this.doSave((IProgressMonitor)progressMonitor);
    }

    public boolean isDirty() {
        return ((BasicCommandStack)this.editingDomain.getCommandStack()).isSaveNeeded();
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void setFocus() {
    }

    public void dispose() {
        this.updateProblemIndication = false;
        ResourcesPlugin.getWorkspace().removeResourceChangeListener(this.resourceChangeListener);
        this.getSite().getPage().removePartListener(this.partListener);
        this.adapterFactory.dispose();
        if (this.getActionBarContributor().getActiveEditor() == this) {
            this.getActionBarContributor().setActiveEditor(null);
        }
        if (this.propertySheetPage != null) {
            this.propertySheetPage.dispose();
        }
        if (this.contentOutlinePage != null) {
            this.contentOutlinePage.dispose();
        }
        super.dispose();
    }

    public void gotoMarker(IMarker marker) {
        try {
            String uriAttribute;
            if (marker.getType().equals("org.eclipse.emf.ecore.diagnostic") && (uriAttribute = marker.getAttribute("uri", null)) != null) {
                URI uri = URI.createURI((String)uriAttribute);
                EObject eObject = this.editingDomain.getResourceSet().getEObject(uri, true);
                if (eObject != null) {
                    this.setSelectionToViewer(Collections.singleton(this.editingDomain.getWrapper((Object)eObject)));
                }
            }
        }
        catch (CoreException exception) {
            CustomEditorPlugin.INSTANCE.log((Object)exception);
        }
    }

    public ISelection getSelection() {
        return this.editorSelection;
    }

    public EditingDomainActionBarContributor getActionBarContributor() {
        return (EditingDomainActionBarContributor)this.getEditorSite().getActionBarContributor();
    }

    public IActionBars getActionBars() {
        return this.getActionBarContributor().getActionBars();
    }

    public void setStatusLineManager(ISelection selection) {
        IStatusLineManager statusLineManager;
        IStatusLineManager iStatusLineManager = statusLineManager = this.selectionViewer != null && this.selectionViewer == this.contentOutlineViewer ? this.contentOutlineStatusLineManager : this.getActionBars().getStatusLineManager();
        if (statusLineManager != null) {
            if (selection instanceof IStructuredSelection) {
                List collection = ((IStructuredSelection)selection).toList();
                switch (collection.size()) {
                    case 0: {
                        statusLineManager.setMessage(CustomEditor.getString("_UI_NoObjectSelected"));
                        break;
                    }
                    case 1: {
                        String text = new AdapterFactoryItemDelegator((AdapterFactory)this.adapterFactory).getText(collection.iterator().next());
                        statusLineManager.setMessage(CustomEditor.getString("_UI_SingleObjectSelected", text));
                        break;
                    }
                    default: {
                        statusLineManager.setMessage(CustomEditor.getString("_UI_MultiObjectSelected", Integer.toString(collection.size())));
                        break;
                    }
                }
            } else {
                statusLineManager.setMessage("");
            }
        }
    }

    public void setSelection(ISelection selection) {
        this.editorSelection = selection;
        for (ISelectionChangedListener listener : this.selectionChangedListeners) {
            listener.selectionChanged(new SelectionChangedEvent((ISelectionProvider)this, selection));
        }
        this.setStatusLineManager(selection);
    }

    public Diagnostic analyzeResourceProblems(Resource resource, Exception exception) {
        if (!resource.getErrors().isEmpty() || !resource.getWarnings().isEmpty()) {
            BasicDiagnostic basicDiagnostic = new BasicDiagnostic(4, "org.eclipse.papyrus.emf.facet.custom.metamodel.editor", 0, CustomEditor.getString("_UI_CreateModelError_message", resource.getURI()), new Object[]{exception == null ? resource : exception});
            basicDiagnostic.merge(EcoreUtil.computeDiagnostic((Resource)resource, (boolean)true));
            return basicDiagnostic;
        }
        if (exception != null) {
            return new BasicDiagnostic(4, "org.eclipse.papyrus.emf.facet.custom.metamodel.editor", 0, CustomEditor.getString("_UI_CreateModelError_message", resource.getURI()), new Object[]{exception});
        }
        return Diagnostic.OK_INSTANCE;
    }

    protected void handleActivate() {
        if (this.editingDomain.getResourceToReadOnlyMap() != null) {
            this.editingDomain.getResourceToReadOnlyMap().clear();
            this.setSelection(this.getSelection());
        }
        if (!this.removedResources.isEmpty()) {
            if (this.handleDirtyConflict()) {
                this.getSite().getPage().closeEditor((IEditorPart)this, false);
            } else {
                this.removedResources.clear();
                this.changedResources.clear();
                this.savedResources.clear();
            }
        } else if (!this.changedResources.isEmpty()) {
            this.changedResources.removeAll(this.savedResources);
            this.handleChangedResources();
            this.changedResources.clear();
            this.savedResources.clear();
        }
    }

    protected boolean handleDirtyConflict() {
        return MessageDialog.openQuestion((Shell)this.getSite().getShell(), (String)"CustomEditor_fileConflict", (String)"CustomEditor_conflictingUnsavedChanges");
    }

    protected void updateProblemIndication() {
        if (this.updateProblemIndication) {
            BasicDiagnostic diagnostic = new BasicDiagnostic(0, "org.eclipse.papyrus.emf.facet.custom.metamodel.editor", 0, null, new Object[]{this.editingDomain.getResourceSet()});
            for (Diagnostic childDiagnostic : this.resourceToDiagnosticMap.values()) {
                if (childDiagnostic.getSeverity() == 0) continue;
                diagnostic.add(childDiagnostic);
            }
            if (diagnostic.getSeverity() != 0) {
                ProblemEditorPart problemEditorPart = new ProblemEditorPart();
                problemEditorPart.setDiagnostic((Diagnostic)diagnostic);
                problemEditorPart.setMarkerHelper(this.markerHelper);
            }
            if (this.markerHelper.hasMarkers((Object)this.editingDomain.getResourceSet())) {
                this.markerHelper.deleteMarkers((Object)this.editingDomain.getResourceSet());
                if (diagnostic.getSeverity() != 0) {
                    try {
                        this.markerHelper.createMarkers((Diagnostic)diagnostic);
                    }
                    catch (CoreException exception) {
                        CustomEditorPlugin.INSTANCE.log((Object)exception);
                    }
                }
            }
        }
    }

    protected void handleChangedResources() {
        if (!(this.changedResources.isEmpty() || this.isDirty() && !this.handleDirtyConflict())) {
            if (this.isDirty()) {
                this.changedResources.addAll((Collection<Resource>)this.editingDomain.getResourceSet().getResources());
            }
            this.editingDomain.getCommandStack().flush();
            this.updateProblemIndication = false;
            for (Resource resource : this.changedResources) {
                if (!resource.isLoaded()) continue;
                resource.unload();
                try {
                    resource.load(Collections.EMPTY_MAP);
                }
                catch (IOException exception) {
                    if (this.resourceToDiagnosticMap.containsKey(resource)) continue;
                    this.resourceToDiagnosticMap.put(resource, this.analyzeResourceProblems(resource, exception));
                }
            }
            if (AdapterFactoryEditingDomain.isStale((Object)this.editorSelection)) {
                this.setSelection((ISelection)StructuredSelection.EMPTY);
            }
            this.updateProblemIndication = true;
            this.updateProblemIndication();
        }
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangedListeners.add(listener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangedListeners.remove(listener);
    }

    private static String getString(String key) {
        return CustomEditorPlugin.INSTANCE.getString(key);
    }

    private static String getString(String key, Object s1) {
        return CustomEditorPlugin.INSTANCE.getString(key, new Object[]{s1});
    }

    protected void createContextMenuFor(StructuredViewer viewer) {
        MenuManager contextMenu = new MenuManager("#PopUp");
        contextMenu.add((IContributionItem)new Separator("additions"));
        contextMenu.setRemoveAllWhenShown(true);
        contextMenu.addMenuListener((IMenuListener)this);
        Menu menu = contextMenu.createContextMenu(viewer.getControl());
        viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(contextMenu, (ISelectionProvider)new UnwrappingSelectionProvider((ISelectionProvider)viewer));
        int dndOperations = 7;
        Transfer[] transfers = new Transfer[]{LocalTransfer.getInstance()};
        viewer.addDragSupport(dndOperations, transfers, (DragSourceListener)new ViewerDragAdapter((Viewer)viewer));
        viewer.addDropSupport(dndOperations, transfers, (DropTargetListener)new EditingDomainViewerDropAdapter((EditingDomain)this.editingDomain, (Viewer)viewer));
    }

    public void menuAboutToShow(IMenuManager menuManager) {
        ((IMenuListener)this.getEditorSite().getActionBarContributor()).menuAboutToShow(menuManager);
    }

    private Object buttonsGridData() {
        GridData buttonsGridData = new GridData();
        buttonsGridData.grabExcessHorizontalSpace = true;
        buttonsGridData.grabExcessVerticalSpace = false;
        buttonsGridData.horizontalAlignment = 4;
        buttonsGridData.verticalAlignment = 4;
        return buttonsGridData;
    }

    private Composite createButtonsPane(Composite parent) {
        return this.createButtonsPaneWhenCustomizationIsSelected(parent);
    }

    private Composite createButtonsPaneWhenCustomizationIsSelected(Composite parent) {
        this.buttonsPaneComposite = new Composite(parent, 0);
        GridData buttonsPaneGridData = new GridData();
        buttonsPaneGridData.grabExcessHorizontalSpace = false;
        buttonsPaneGridData.grabExcessVerticalSpace = true;
        buttonsPaneGridData.horizontalAlignment = 4;
        buttonsPaneGridData.verticalAlignment = 4;
        this.buttonsPaneComposite.setLayoutData((Object)buttonsPaneGridData);
        this.buttonsPaneComposite.setLayout((Layout)new GridLayout());
        Composite spacer1 = new Composite(this.buttonsPaneComposite, 0);
        GridData spacer1GridData = new GridData();
        spacer1GridData.heightHint = 10;
        spacer1.setLayoutData((Object)spacer1GridData);
        Composite spacer2 = new Composite(this.buttonsPaneComposite, 0);
        GridData spacer2GridData = new GridData();
        spacer2GridData.heightHint = 30;
        spacer2.setLayoutData((Object)spacer2GridData);
        Label lblConditions = new Label(this.buttonsPaneComposite, 0);
        lblConditions.setText("add");
        this.btnAddFacetSet = new Button(this.buttonsPaneComposite, 8);
        this.btnAddFacetSet.setText("FacetSet");
        this.btnAddFacetSet.setLayoutData(this.buttonsGridData());
        this.btnAddFacetSet.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CustomEditor.this.btnAddFacetSetClicked();
            }
        });
        this.btnAddFacet = new Button(this.buttonsPaneComposite, 8);
        this.btnAddFacet.setText("Facet");
        this.btnAddFacet.setLayoutData(this.buttonsGridData());
        this.btnAddFacet.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CustomEditor.this.btnAddFacetClicked();
            }
        });
        this.btnAddEClassCustom = new Button(this.buttonsPaneComposite, 8);
        this.btnAddEClassCustom.setText("EClassCustom");
        this.btnAddEClassCustom.setLayoutData(this.buttonsGridData());
        this.btnAddEClassCustom.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CustomEditor.this.btnAddECLassCustomClicked();
            }
        });
        this.btnAddFacetCustom = new Button(this.buttonsPaneComposite, 8);
        this.btnAddFacetCustom.setText("FacetCustom");
        this.btnAddFacetCustom.setLayoutData(this.buttonsGridData());
        this.btnAddFacetCustom.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CustomEditor.this.btnAddFacetCustomClicked();
            }
        });
        return this.buttonsPaneComposite;
    }

    protected void btnRemoveClicked() {
        if (this.readOnly) {
            return;
        }
        TreeSelection selectedElement = (TreeSelection)this.getSelection();
        Object selectedObject = selectedElement.getFirstElement();
        if (selectedObject instanceof EObject) {
            EObject eObject = (EObject)selectedObject;
            EObject eContainer = eObject.eContainer();
            if (eContainer instanceof Customization) {
                Command command = RemoveCommand.create((EditingDomain)this.editingDomain, (Object)eContainer, (Object)EcorePackage.eINSTANCE.getEPackage_EClassifiers(), (Object)eObject);
                this.editingDomain.getCommandStack().execute(command);
            } else if (eContainer instanceof Facet) {
                if (selectedObject instanceof FacetOperation) {
                    Command command = RemoveCommand.create((EditingDomain)this.editingDomain, (Object)eContainer, (Object)EFacetPackage.eINSTANCE.getFacet_FacetOperations(), (Object)eObject);
                    this.editingDomain.getCommandStack().execute(command);
                    this.setInputInCustomizationTreeviewer((Facet)eContainer);
                    this.customizationViewer.getViewer().refresh();
                } else if (selectedObject instanceof FacetAttribute || selectedObject instanceof FacetReference) {
                    Command command = RemoveCommand.create((EditingDomain)this.editingDomain, (Object)eContainer, (Object)EFacetPackage.eINSTANCE.getFacet_FacetElements(), (Object)eObject);
                    this.editingDomain.getCommandStack().execute(command);
                    this.setInputInCustomizationTreeviewer((Facet)eContainer);
                    this.customizationViewer.getViewer().refresh();
                }
            } else if (eContainer instanceof FacetOperation) {
                Command command = RemoveCommand.create((EditingDomain)this.editingDomain, (Object)eContainer, (Object)EcorePackage.eINSTANCE.getEOperation_EParameters(), (Object)eObject);
                this.editingDomain.getCommandStack().execute(command);
                this.setInputInCustomizationTreeviewer((Facet)eContainer);
                this.customizationViewer.getViewer().refresh();
            }
        }
    }

    protected void btnDownClicked() {
        if (this.readOnly) {
            return;
        }
        TreeSelection selectedElement = (TreeSelection)this.getSelection();
        Object selectedObject = selectedElement.getFirstElement();
        if (selectedObject instanceof EObject) {
            EList list;
            int index;
            EObject eObject = (EObject)selectedObject;
            EObject eContainer = eObject.eContainer();
            if (eContainer instanceof Customization) {
                EList list2 = ((Customization)eContainer).getEClassifiers();
                int index2 = list2.indexOf((Object)eObject);
                if (index2 + 1 < list2.size()) {
                    Command command = MoveCommand.create((EditingDomain)this.editingDomain, (Object)eContainer, (Object)EcorePackage.eINSTANCE.getEPackage_EClassifiers(), (Object)list2.get(index2), (int)(index2 + 1));
                    this.editingDomain.getCommandStack().execute(command);
                }
            } else if (eContainer instanceof Facet) {
                EList list3;
                int index3;
                if (selectedObject instanceof FacetOperation) {
                    EList list4 = ((Facet)eContainer).getFacetOperations();
                    int index4 = list4.indexOf((Object)eObject);
                    if (index4 + 1 < list4.size()) {
                        Command command = MoveCommand.create((EditingDomain)this.editingDomain, (Object)eContainer, (Object)EFacetPackage.eINSTANCE.getFacet_FacetOperations(), (Object)list4.get(index4), (int)(index4 + 1));
                        this.editingDomain.getCommandStack().execute(command);
                        this.setInputInCustomizationTreeviewer((Facet)eContainer);
                        this.customizationViewer.getViewer().refresh();
                    }
                } else if ((selectedObject instanceof FacetAttribute || selectedObject instanceof FacetReference) && (index3 = (list3 = ((Facet)eContainer).getFacetElements()).indexOf((Object)eObject)) + 1 < list3.size()) {
                    Command command = MoveCommand.create((EditingDomain)this.editingDomain, (Object)eContainer, (Object)EFacetPackage.eINSTANCE.getFacet_FacetElements(), (Object)list3.get(index3), (int)(index3 + 1));
                    this.editingDomain.getCommandStack().execute(command);
                    this.setInputInCustomizationTreeviewer((Facet)eContainer);
                    this.customizationViewer.getViewer().refresh();
                }
            } else if (eContainer instanceof FacetOperation && (index = (list = ((FacetOperation)eContainer).getEParameters()).indexOf((Object)eObject)) + 1 < list.size()) {
                Command command = MoveCommand.create((EditingDomain)this.editingDomain, (Object)eContainer, (Object)EcorePackage.eINSTANCE.getEOperation_EParameters(), (Object)list.get(index), (int)(index + 1));
                this.editingDomain.getCommandStack().execute(command);
                this.setInputInCustomizationTreeviewer((Facet)eContainer);
                this.customizationViewer.getViewer().refresh();
            }
        }
    }

    protected void btnUpClicked() {
        if (this.readOnly) {
            return;
        }
        TreeSelection selectedElement = (TreeSelection)this.getSelection();
        Object selectedObject = selectedElement.getFirstElement();
        if (selectedObject instanceof EObject) {
            EList list;
            int index;
            EObject eObject = (EObject)selectedObject;
            EObject eContainer = eObject.eContainer();
            if (eContainer instanceof Customization) {
                EList list2 = ((Customization)eContainer).getEClassifiers();
                int index2 = list2.indexOf((Object)eObject);
                if (index2 - 1 >= 0) {
                    Command command = MoveCommand.create((EditingDomain)this.editingDomain, (Object)eContainer, (Object)EcorePackage.eINSTANCE.getEPackage_EClassifiers(), (Object)list2.get(index2), (int)(index2 - 1));
                    this.editingDomain.getCommandStack().execute(command);
                }
            } else if (eContainer instanceof Facet) {
                EList list3;
                int index3;
                if (selectedObject instanceof FacetOperation) {
                    EList list4 = ((Facet)eContainer).getFacetOperations();
                    int index4 = list4.indexOf((Object)eObject);
                    if (index4 - 1 >= 0) {
                        Command command = MoveCommand.create((EditingDomain)this.editingDomain, (Object)eContainer, (Object)EFacetPackage.eINSTANCE.getFacet_FacetOperations(), (Object)list4.get(index4), (int)(index4 - 1));
                        this.editingDomain.getCommandStack().execute(command);
                        this.setInputInCustomizationTreeviewer((Facet)eContainer);
                        this.customizationViewer.getViewer().refresh();
                    }
                } else if ((selectedObject instanceof FacetAttribute || selectedObject instanceof FacetReference) && (index3 = (list3 = ((Facet)eContainer).getFacetElements()).indexOf((Object)eObject)) - 1 >= 0) {
                    Command command = MoveCommand.create((EditingDomain)this.editingDomain, (Object)eContainer, (Object)EFacetPackage.eINSTANCE.getFacet_FacetElements(), (Object)list3.get(index3), (int)(index3 - 1));
                    this.editingDomain.getCommandStack().execute(command);
                    this.setInputInCustomizationTreeviewer((Facet)eContainer);
                    this.customizationViewer.getViewer().refresh();
                }
            } else if (eContainer instanceof FacetOperation && (index = (list = ((FacetOperation)eContainer).getEParameters()).indexOf((Object)eObject)) - 1 >= 0) {
                Command command = MoveCommand.create((EditingDomain)this.editingDomain, (Object)eContainer, (Object)EcorePackage.eINSTANCE.getEOperation_EParameters(), (Object)list.get(index), (int)(index - 1));
                this.editingDomain.getCommandStack().execute(command);
                this.setInputInCustomizationTreeviewer((Facet)eContainer);
                this.customizationViewer.getViewer().refresh();
            }
        }
    }

    protected void btnAddFacetCustomClicked() {
        if (this.readOnly) {
            return;
        }
        ISelection selectedElement = this.getSelection();
        if (((TreeSelection)selectedElement).getFirstElement() instanceof Customization) {
            ICustomizationDialogFactory.DEFAULT.openCreateFacetCustomizationDialog(this.getSite().getShell().getDisplay(), (EditingDomain)this.editingDomain);
        }
    }

    protected void btnAddECLassCustomClicked() {
        if (this.readOnly) {
            return;
        }
        ISelection selectedElement = this.getSelection();
        if (((TreeSelection)selectedElement).getFirstElement() instanceof Customization) {
            ICustomizationDialogFactory.DEFAULT.openCreateEClassCustomizationDialog(this.getSite().getShell().getDisplay(), (EditingDomain)this.editingDomain);
        }
    }

    protected void btnAddFacetClicked() {
        if (this.readOnly) {
            return;
        }
        ISelection selectedElement = this.getSelection();
        if (((TreeSelection)selectedElement).getFirstElement() instanceof Customization) {
            IFacetDialogFactory.INSTANCE.openCreateFacetInFacetSetDialog();
        }
    }

    protected void btnAddFacetSetClicked() {
        if (this.readOnly) {
            return;
        }
        ISelection selectedElement = this.getSelection();
        if (((TreeSelection)selectedElement).getFirstElement() instanceof Customization) {
            IFacetDialogFactory.INSTANCE.openCreateFacetSetInFacetSetDialog();
        }
    }

    private Composite createButtonsPaneWhenFacetIsSelected(Composite parent) {
        this.buttonsPaneComposite = new Composite(parent, 0);
        GridData buttonsPaneGridData = new GridData();
        buttonsPaneGridData.grabExcessHorizontalSpace = false;
        buttonsPaneGridData.grabExcessVerticalSpace = true;
        buttonsPaneGridData.horizontalAlignment = 4;
        buttonsPaneGridData.verticalAlignment = 4;
        this.buttonsPaneComposite.setLayoutData((Object)buttonsPaneGridData);
        this.buttonsPaneComposite.setLayout((Layout)new GridLayout());
        Composite spacer1 = new Composite(this.buttonsPaneComposite, 0);
        GridData spacer1GridData = new GridData();
        spacer1GridData.heightHint = 10;
        spacer1.setLayoutData((Object)spacer1GridData);
        Composite spacer2 = new Composite(this.buttonsPaneComposite, 0);
        GridData spacer2GridData = new GridData();
        spacer2GridData.heightHint = 30;
        spacer2.setLayoutData((Object)spacer2GridData);
        Label lblConditions = new Label(this.buttonsPaneComposite, 0);
        lblConditions.setText("add");
        this.btnAddFacetAttr = new Button(this.buttonsPaneComposite, 8);
        this.btnAddFacetAttr.setText("Facet Attribute");
        this.btnAddFacetAttr.setLayoutData(this.buttonsGridData());
        this.btnAddFacetAttr.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CustomEditor.this.btnAddFacetAttributeClicked();
            }
        });
        this.btnAddFacetRef = new Button(this.buttonsPaneComposite, 8);
        this.btnAddFacetRef.setText("Facet Reference");
        this.btnAddFacetRef.setLayoutData(this.buttonsGridData());
        this.btnAddFacetRef.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CustomEditor.this.btnAddFacetReferenceClicked();
            }
        });
        this.btnAddFacetOp = new Button(this.buttonsPaneComposite, 8);
        this.btnAddFacetOp.setText("Facet Operation");
        this.btnAddFacetOp.setLayoutData(this.buttonsGridData());
        this.btnAddFacetOp.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CustomEditor.this.btnAddFacetOperationClicked();
            }
        });
        Composite spacer3 = new Composite(this.buttonsPaneComposite, 0);
        GridData spacer3GridData = new GridData();
        spacer3GridData.heightHint = 30;
        spacer3.setLayoutData((Object)spacer2GridData);
        Label lblEditions = new Label(this.buttonsPaneComposite, 0);
        lblEditions.setText("edit");
        this.btnEdit = new Button(this.buttonsPaneComposite, 8);
        this.btnEdit.setText(CustomEditorPlugin.INSTANCE.getString("CustomizationEditor_edit"));
        this.btnEdit.setLayoutData(this.buttonsGridData());
        this.btnEdit.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CustomEditor.this.btnEditClicked();
            }
        });
        this.btnRemove = new Button(this.buttonsPaneComposite, 8);
        this.btnRemove.setText(CustomEditorPlugin.INSTANCE.getString("CustomizationEditor_remove"));
        this.btnRemove.setLayoutData(this.buttonsGridData());
        this.btnRemove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CustomEditor.this.btnRemoveClicked();
            }
        });
        this.btnUp = new Button(this.buttonsPaneComposite, 8);
        this.btnUp.setText(CustomEditorPlugin.INSTANCE.getString("CustomizationEditor_up"));
        this.btnUp.setLayoutData(this.buttonsGridData());
        this.btnUp.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CustomEditor.this.btnUpClicked();
            }
        });
        this.btnDown = new Button(this.buttonsPaneComposite, 8);
        this.btnDown.setText(CustomEditorPlugin.INSTANCE.getString("CustomizationEditor_down"));
        this.btnDown.setLayoutData(this.buttonsGridData());
        this.btnDown.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CustomEditor.this.btnDownClicked();
            }
        });
        return this.buttonsPaneComposite;
    }

    protected void btnAddFacetOperationClicked() {
        if (this.readOnly) {
            return;
        }
        ISelection selectedElement = this.getSelection();
        if (((TreeSelection)selectedElement).getFirstElement() instanceof Facet) {
            IFacetDialogFactory.INSTANCE.openAddOperationInFacetDialog();
        }
    }

    protected void btnAddFacetReferenceClicked() {
        if (this.readOnly) {
            return;
        }
        ISelection selectedElement = this.getSelection();
        if (((TreeSelection)selectedElement).getFirstElement() instanceof Facet) {
            IFacetDialogFactory.INSTANCE.openAddReferenceInFacetDialog();
        }
    }

    protected void btnAddFacetAttributeClicked() {
        if (this.readOnly) {
            return;
        }
        ISelection selectedElement = this.getSelection();
        if (((TreeSelection)selectedElement).getFirstElement() instanceof Facet) {
            IFacetDialogFactory.INSTANCE.openAddAttributeInFacetDialog();
        }
    }

    private Composite createButtonsPaneWhenDerivedIsSelected(Composite parent) {
        this.buttonsPaneComposite = new Composite(parent, 0);
        GridData buttonsPaneGridData = new GridData();
        buttonsPaneGridData.grabExcessHorizontalSpace = false;
        buttonsPaneGridData.grabExcessVerticalSpace = true;
        buttonsPaneGridData.horizontalAlignment = 4;
        buttonsPaneGridData.verticalAlignment = 4;
        this.buttonsPaneComposite.setLayoutData((Object)buttonsPaneGridData);
        this.buttonsPaneComposite.setLayout((Layout)new GridLayout());
        Composite spacer1 = new Composite(this.buttonsPaneComposite, 0);
        GridData spacer1GridData = new GridData();
        spacer1GridData.heightHint = 10;
        spacer1.setLayoutData((Object)spacer1GridData);
        Composite spacer2 = new Composite(this.buttonsPaneComposite, 0);
        GridData spacer2GridData = new GridData();
        spacer2GridData.heightHint = 30;
        spacer2.setLayoutData((Object)spacer2GridData);
        Label lblConditions = new Label(this.buttonsPaneComposite, 0);
        lblConditions.setText("add");
        this.btnAddFacetParam = new Button(this.buttonsPaneComposite, 8);
        this.btnAddFacetParam.setText("Parameter");
        this.btnAddFacetParam.setLayoutData(this.buttonsGridData());
        this.btnAddFacetParam.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CustomEditor.this.btnAddParameterClicked();
            }
        });
        if (!(((TreeSelection)this.getSelection()).getFirstElement() instanceof FacetOperation)) {
            this.btnAddFacetParam.setEnabled(false);
        } else {
            this.btnAddFacetParam.setEnabled(true);
        }
        Composite spacer3 = new Composite(this.buttonsPaneComposite, 0);
        GridData spacer3GridData = new GridData();
        spacer3GridData.heightHint = 30;
        spacer3.setLayoutData((Object)spacer2GridData);
        Label lblEditions = new Label(this.buttonsPaneComposite, 0);
        lblEditions.setText("edit");
        this.btnEdit = new Button(this.buttonsPaneComposite, 8);
        this.btnEdit.setText(CustomEditorPlugin.INSTANCE.getString("CustomizationEditor_edit"));
        this.btnEdit.setLayoutData(this.buttonsGridData());
        this.btnEdit.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CustomEditor.this.btnEditClicked();
            }
        });
        this.btnRemove = new Button(this.buttonsPaneComposite, 8);
        this.btnRemove.setText(CustomEditorPlugin.INSTANCE.getString("CustomizationEditor_remove"));
        this.btnRemove.setLayoutData(this.buttonsGridData());
        this.btnRemove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CustomEditor.this.btnRemoveClicked();
            }
        });
        this.btnUp = new Button(this.buttonsPaneComposite, 8);
        this.btnUp.setText(CustomEditorPlugin.INSTANCE.getString("CustomizationEditor_up"));
        this.btnUp.setLayoutData(this.buttonsGridData());
        this.btnUp.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CustomEditor.this.btnUpClicked();
            }
        });
        this.btnDown = new Button(this.buttonsPaneComposite, 8);
        this.btnDown.setText(CustomEditorPlugin.INSTANCE.getString("CustomizationEditor_down"));
        this.btnDown.setLayoutData(this.buttonsGridData());
        this.btnDown.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CustomEditor.this.btnDownClicked();
            }
        });
        return this.buttonsPaneComposite;
    }

    protected void btnAddParameterClicked() {
        Object selectedObject;
        if (this.readOnly) {
            return;
        }
        ISelection selectedElement = this.getSelection();
        if (selectedElement instanceof TreeSelection && (selectedObject = ((TreeSelection)selectedElement).getFirstElement()) instanceof FacetOperation) {
            IFacetDialogFactory.INSTANCE.openAddParameterInOperationDialog();
        }
    }

    public EditingDomain getEditingDomain() {
        return this.editingDomain;
    }

    public Viewer getViewer() {
        return this.selectionViewer;
    }

    public void doSaveAs() {
        IFile file;
        SaveAsDialog saveAsDialog = new SaveAsDialog(this.getSite().getShell());
        saveAsDialog.open();
        IPath path = saveAsDialog.getResult();
        if (path != null && (file = ResourcesPlugin.getWorkspace().getRoot().getFile(path)) != null) {
            this.doSaveAs(URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)true), (IEditorInput)new FileEditorInput(file));
        }
    }
}

