/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.xtext.essentialocl.utilities;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.EnumerationLiteral;
import org.eclipse.ocl.pivot.Feature;
import org.eclipse.ocl.pivot.LetExp;
import org.eclipse.ocl.pivot.LoopExp;
import org.eclipse.ocl.pivot.NamedElement;
import org.eclipse.ocl.pivot.Namespace;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.Variable;
import org.eclipse.ocl.pivot.internal.complete.StandardLibraryInternal;
import org.eclipse.ocl.pivot.internal.manager.PivotMetamodelManager;
import org.eclipse.ocl.pivot.internal.resource.ASResourceFactory;
import org.eclipse.ocl.pivot.internal.resource.ASResourceImpl;
import org.eclipse.ocl.pivot.internal.resource.AbstractASResourceFactory;
import org.eclipse.ocl.pivot.internal.utilities.EnvironmentFactoryInternal;
import org.eclipse.ocl.pivot.internal.utilities.IllegalLibraryException;
import org.eclipse.ocl.pivot.internal.utilities.PivotUtilInternal;
import org.eclipse.ocl.pivot.resource.ASResource;
import org.eclipse.ocl.pivot.resource.ProjectManager;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.EnvironmentFactory;
import org.eclipse.ocl.pivot.utilities.ParserContext;
import org.eclipse.ocl.xtext.base.as2cs.AS2CS;
import org.eclipse.ocl.xtext.base.cs2as.CS2AS;
import org.eclipse.ocl.xtext.base.cs2as.ImportDiagnostic;
import org.eclipse.ocl.xtext.base.cs2as.LibraryDiagnostic;
import org.eclipse.ocl.xtext.base.utilities.BaseCSResource;
import org.eclipse.ocl.xtext.base.utilities.CSI2ASMapping;
import org.eclipse.ocl.xtext.base.utilities.ElementUtil;
import org.eclipse.ocl.xtext.basecs.ElementCS;
import org.eclipse.ocl.xtext.basecs.PathElementCS;
import org.eclipse.ocl.xtext.basecs.PathElementWithURICS;
import org.eclipse.ocl.xtext.basecs.PathNameCS;
import org.eclipse.ocl.xtext.essentialocl.as2cs.EssentialOCLAS2CS;
import org.eclipse.ocl.xtext.essentialocl.attributes.NavigationUtil;
import org.eclipse.ocl.xtext.essentialocl.cs2as.EssentialOCLCS2AS;
import org.eclipse.ocl.xtext.essentialocl.utilities.EssentialOCLASResourceFactory;
import org.eclipse.ocl.xtext.essentialoclcs.ExpCS;
import org.eclipse.ocl.xtext.essentialoclcs.NameExpCS;
import org.eclipse.xtext.diagnostics.AbstractDiagnostic;
import org.eclipse.xtext.diagnostics.DiagnosticMessage;
import org.eclipse.xtext.diagnostics.IDiagnosticConsumer;
import org.eclipse.xtext.linking.impl.XtextLinkingDiagnostic;
import org.eclipse.xtext.linking.lazy.LazyLinkingResource;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.SyntaxErrorMessage;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.parser.IParseResult;
import org.eclipse.xtext.resource.XtextSyntaxDiagnostic;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.util.Triple;

public class EssentialOCLCSResource
extends LazyLinkingResource
implements BaseCSResource {
    private static final String NO_VIABLE_ALTERNATIVE_AT_INPUT_EOF = "no viable alternative at input '<EOF>'";
    private static final String NO_VIABLE_ALTERNATIVE_FOLLOWING = "no viable alternative following input ";
    private static final String NO_VIABLE_ALTERNATIVE_AT = "no viable alternative at ";
    private static final String MISSING_EOF_AT = "missing EOF at ";
    private static final Logger logger = Logger.getLogger(EssentialOCLCSResource.class);
    private @Nullable ParserContext parserContext = null;
    private @Nullable ProjectManager projectMap = null;

    protected void addLibraryError(List<Resource.Diagnostic> errors, IllegalLibraryException e) {
        String message = e.getMessage();
        for (Resource.Diagnostic diagnostic : errors) {
            Exception exception;
            if (!(diagnostic instanceof LibraryDiagnostic) || !((exception = ((LibraryDiagnostic)diagnostic).getException()) instanceof IllegalLibraryException) || !message.equals(exception.getMessage())) continue;
            return;
        }
        errors.add((Resource.Diagnostic)new LibraryDiagnostic((Exception)e));
    }

    protected void addSyntaxErrors() {
        if (this.isValidationDisabled()) {
            return;
        }
        IParseResult parseResult = this.getParseResult();
        if (parseResult == null) {
            return;
        }
        EList errors2 = this.getErrors();
        for (INode error : parseResult.getSyntaxErrors()) {
            Object diagnostic = null;
            SyntaxErrorMessage syntaxErrorMessage = error.getSyntaxErrorMessage();
            if (syntaxErrorMessage != null) {
                String newMessage;
                String tokenText;
                int index;
                String message = syntaxErrorMessage.getMessage();
                if (message != null && message.contains(NO_VIABLE_ALTERNATIVE_AT_INPUT_EOF)) {
                    index = message.indexOf(NO_VIABLE_ALTERNATIVE_AT_INPUT_EOF);
                    if (index >= 0 && (tokenText = NodeModelUtils.getTokenText((INode)error)) != null) {
                        newMessage = String.valueOf(message.substring(0, index)) + NO_VIABLE_ALTERNATIVE_FOLLOWING + "'" + tokenText + "'" + message.substring(index + NO_VIABLE_ALTERNATIVE_AT_INPUT_EOF.length());
                        diagnostic = new RenamedDiagnostic(syntaxErrorMessage, error, newMessage);
                    }
                } else if (message != null && message.contains(MISSING_EOF_AT) && (index = message.indexOf(MISSING_EOF_AT)) >= 0 && (tokenText = NodeModelUtils.getTokenText((INode)error)) != null) {
                    newMessage = String.valueOf(message.substring(0, index)) + NO_VIABLE_ALTERNATIVE_AT + message.substring(index + MISSING_EOF_AT.length());
                    diagnostic = new RenamedDiagnostic(syntaxErrorMessage, error, newMessage);
                }
            }
            if (diagnostic == null) {
                diagnostic = new XtextSyntaxDiagnostic(error);
            }
            errors2.add(diagnostic);
        }
    }

    public NotificationChain basicSetResourceSet(ResourceSet resourceSet, NotificationChain notifications) {
        return super.basicSetResourceSet(resourceSet, notifications);
    }

    protected @NonNull ASResource createASResource(@NonNull ResourceSet asResourceSet) {
        URI uri = (URI)ClassUtil.nonNullState((Object)this.getURI());
        URI asURI = this.getASURI(uri);
        if (uri.fileExtension().equals("essentialocl")) {
            return new TransientASResource(asResourceSet, asURI);
        }
        ASResource asResource = (ASResource)asResourceSet.getResource(asURI, false);
        if (asResource != null) {
            return asResource;
        }
        @NonNull Resource asResource2 = asResourceSet.createResource(asURI, this.getASContentType());
        return (ASResource)asResource2;
    }

    public void createAndAddDiagnostic(Triple<EObject, EReference, INode> triple) {
        if (this.isValidationDisabled()) {
            return;
        }
        EObject context = (EObject)triple.getFirst();
        if (context instanceof ElementCS) {
            if (!this.hasError((ElementCS)context)) {
                super.createAndAddDiagnostic(triple);
                this.setHasError((ElementCS)context);
            }
        } else {
            super.createAndAddDiagnostic(triple);
        }
    }

    public @NonNull CS2AS createCS2AS(@NonNull EnvironmentFactoryInternal environmentFactory, @NonNull ASResource asResource) {
        return new EssentialOCLCS2AS(environmentFactory, this, asResource);
    }

    protected Resource.Diagnostic createDiagnostic(Triple<EObject, EReference, INode> triple, DiagnosticMessage message) {
        EObject first = (EObject)triple.getFirst();
        if (first instanceof PathElementWithURICS) {
            return new ImportDiagnostic((INode)triple.getThird(), message.getMessage(), message.getIssueCode(), message.getIssueData());
        }
        return new XtextLinkingDiagnostic((INode)triple.getThird(), message.getMessage(), message.getIssueCode(), message.getIssueData()){

            public int getColumn() {
                return -1;
            }
        };
    }

    public @NonNull AS2CS createAS2CS(@NonNull Map<? extends BaseCSResource, ? extends ASResource> cs2asResourceMap, @NonNull EnvironmentFactoryInternal environmentFactory) {
        return new EssentialOCLAS2CS(cs2asResourceMap, environmentFactory);
    }

    public void dispose() {
        CS2AS cs2as;
        try {
            Method method = ((Object)((Object)this)).getClass().getMethod("clearLazyProxyInformation", new Class[0]);
            if (method != null) {
                method.invoke((Object)this, new Object[0]);
            }
        }
        catch (Exception method) {
            // empty catch block
        }
        if ((cs2as = this.findCS2AS()) != null) {
            cs2as.dispose();
        }
    }

    protected void doLinking() {
        EList errors = this.getErrors();
        if (errors.size() > 0) {
            int i = errors.size();
            while (--i >= 0) {
                Resource.Diagnostic error = (Resource.Diagnostic)errors.get(i);
                if (!(error instanceof LibraryDiagnostic)) continue;
                errors.remove(i);
            }
        }
        super.doLinking();
    }

    protected void doLoad(InputStream inputStream, Map<?, ?> options) throws IOException {
        super.doLoad(inputStream, options);
    }

    public void doSave(OutputStream outputStream, Map<?, ?> options) throws IOException {
        if (options != null && "\n".equals(options.get("LINE_DELIMITER")) && outputStream != null) {
            super.doSave((OutputStream)new UnixOutputStream(outputStream), options);
        } else {
            super.doSave(outputStream, options);
        }
    }

    public final @Nullable CS2AS findCS2AS() {
        EnvironmentFactoryInternal environmentFactory = PivotUtilInternal.findEnvironmentFactory((Resource)this);
        if (environmentFactory == null) {
            return null;
        }
        CSI2ASMapping csi2asMapping = CSI2ASMapping.basicGetCSI2ASMapping((EnvironmentFactoryInternal)environmentFactory);
        if (csi2asMapping == null) {
            return null;
        }
        return csi2asMapping.getCS2AS((BaseCSResource)this);
    }

    public @NonNull String getASContentType() {
        return "org.eclipse.ocl.oclas.essentialocl";
    }

    public final @NonNull ASResource getASResource() {
        CS2AS cs2as = this.getCS2AS();
        ASResource asResource = cs2as.getASResource();
        return asResource;
    }

    public @NonNull ASResourceFactory getASResourceFactory() {
        return EssentialOCLASResourceFactory.getInstance();
    }

    public @NonNull URI getASURI(@NonNull URI csURI) {
        return csURI.appendFileExtension("oclas");
    }

    public @NonNull CS2AS getCS2AS() {
        CS2AS cs2as;
        EnvironmentFactoryInternal environmentFactory = PivotUtilInternal.getEnvironmentFactory((Resource)this);
        CSI2ASMapping csi2asMapping = CSI2ASMapping.basicGetCSI2ASMapping((EnvironmentFactoryInternal)environmentFactory);
        if (csi2asMapping != null && (cs2as = csi2asMapping.getCS2AS((BaseCSResource)this)) != null) {
            return cs2as;
        }
        PivotMetamodelManager metamodelManager = environmentFactory.getMetamodelManager();
        ClassLoader classLoader = ((Object)((Object)this)).getClass().getClassLoader();
        if (classLoader != null) {
            metamodelManager.addClassLoader(classLoader);
        }
        ResourceSet asResourceSet = metamodelManager.getASResourceSet();
        // Could not load outer class - annotation placement on inner may be incorrect
        @NonNull Resource.Factory.Registry resourceFactoryRegistry = asResourceSet.getResourceFactoryRegistry();
        this.initializeResourceFactory(resourceFactoryRegistry);
        ASResource asResource = this.createASResource(asResourceSet);
        CS2AS cs2as2 = this.createCS2AS(environmentFactory, asResource);
        return cs2as2;
    }

    public final @NonNull CS2AS getCS2AS(@NonNull EnvironmentFactoryInternal environmentFactory, @NonNull ASResource asResource) {
        // Could not load outer class - annotation placement on inner may be incorrect
        @NonNull Resource.Factory.Registry resourceFactoryRegistry = environmentFactory.getMetamodelManager().getASResourceSet().getResourceFactoryRegistry();
        this.initializeResourceFactory(resourceFactoryRegistry);
        CS2AS cs2as = this.findCS2AS();
        assert (cs2as == null);
        cs2as = this.createCS2AS(environmentFactory, asResource);
        return cs2as;
    }

    public @NonNull String getEditorName() {
        return "Essential OCL";
    }

    public final @Nullable ParserContext getParserContext() {
        return this.parserContext;
    }

    public @NonNull EnvironmentFactory getEnvironmentFactory() {
        CS2AS csAdapter = this.getCS2AS();
        return csAdapter.getEnvironmentFactory();
    }

    public @Nullable ProjectManager getProjectManager() {
        return this.projectMap;
    }

    protected boolean hasError(ElementCS csElement) {
        while (csElement instanceof PathElementCS || csElement instanceof PathNameCS) {
            csElement = csElement.getParent();
        }
        while (csElement instanceof ExpCS) {
            if (((ExpCS)csElement).isHasError()) {
                return true;
            }
            if (!NavigationUtil.isNavigationInfixExp((EObject)(csElement = csElement.getParent())) && !(csElement instanceof NameExpCS)) break;
        }
        return false;
    }

    protected void initializeResourceFactory(// Could not load outer class - annotation placement on inner may be incorrect
    @NonNull Resource.Factory.Registry resourceFactoryRegistry) {
    }

    public @Nullable NamedElement isPathable(@NonNull EObject element) {
        if (element instanceof Feature) {
            return (Feature)element;
        }
        if (element instanceof Type) {
            return (Type)element;
        }
        if (element instanceof Namespace) {
            return (Namespace)element;
        }
        if (element instanceof EnumerationLiteral) {
            return (EnumerationLiteral)element;
        }
        if (element instanceof Variable && element.eContainer() instanceof LoopExp) {
            return (Variable)element;
        }
        if (element instanceof Variable && element.eContainer() instanceof LetExp) {
            return (Variable)element;
        }
        return null;
    }

    public void reparse(String newContent) throws IOException {
        try {
            super.reparse(newContent);
        }
        catch (IllegalArgumentException e) {
            logger.error((Object)"Failed to reparse", (Throwable)e);
        }
    }

    public final @NonNull URI resolve(@NonNull URI uri) {
        URI csURI = this.getURI();
        if (csURI.isRelative()) {
            File csRelative = new File(csURI.toFileString());
            File csAbsolute = csRelative.getAbsoluteFile();
            csURI = URI.createFileURI((String)csAbsolute.toString());
        }
        URI resolvedURI = uri.resolve(csURI);
        assert (resolvedURI != null);
        return resolvedURI;
    }

    public void resolveLazyCrossReferences(CancelIndicator mon) {
        EList errors = this.getErrors();
        assert (errors != null);
        if (ElementUtil.hasSyntaxError((List)errors)) {
            return;
        }
        EnvironmentFactoryInternal environmentFactory = PivotUtilInternal.findEnvironmentFactory((Resource)this);
        if (environmentFactory != null) {
            StandardLibraryInternal standardLibrary = environmentFactory.getStandardLibrary();
            try {
                standardLibrary.getOclAnyType();
            }
            catch (IllegalLibraryException e) {
                this.addLibraryError((List<Resource.Diagnostic>)errors, e);
            }
            try {
                standardLibrary.getOclElementType();
            }
            catch (IllegalLibraryException e) {
                this.addLibraryError((List<Resource.Diagnostic>)errors, e);
            }
            try {
                standardLibrary.getOclVoidType();
            }
            catch (IllegalLibraryException e) {
                this.addLibraryError((List<Resource.Diagnostic>)errors, e);
            }
            try {
                standardLibrary.getOclInvalidType();
            }
            catch (IllegalLibraryException e) {
                this.addLibraryError((List<Resource.Diagnostic>)errors, e);
            }
            try {
                standardLibrary.getClassType();
            }
            catch (IllegalLibraryException e) {
                this.addLibraryError((List<Resource.Diagnostic>)errors, e);
            }
            try {
                standardLibrary.getBooleanType();
            }
            catch (IllegalLibraryException e) {
                this.addLibraryError((List<Resource.Diagnostic>)errors, e);
            }
            try {
                standardLibrary.getRealType();
            }
            catch (IllegalLibraryException e) {
                this.addLibraryError((List<Resource.Diagnostic>)errors, e);
            }
            try {
                standardLibrary.getIntegerType();
            }
            catch (IllegalLibraryException e) {
                this.addLibraryError((List<Resource.Diagnostic>)errors, e);
            }
            try {
                standardLibrary.getUnlimitedNaturalType();
            }
            catch (IllegalLibraryException e) {
                this.addLibraryError((List<Resource.Diagnostic>)errors, e);
            }
            try {
                standardLibrary.getStringType();
            }
            catch (IllegalLibraryException e) {
                this.addLibraryError((List<Resource.Diagnostic>)errors, e);
            }
            try {
                standardLibrary.getCollectionType();
            }
            catch (IllegalLibraryException e) {
                this.addLibraryError((List<Resource.Diagnostic>)errors, e);
            }
            try {
                standardLibrary.getBagType();
            }
            catch (IllegalLibraryException e) {
                this.addLibraryError((List<Resource.Diagnostic>)errors, e);
            }
            try {
                standardLibrary.getSequenceType();
            }
            catch (IllegalLibraryException e) {
                this.addLibraryError((List<Resource.Diagnostic>)errors, e);
            }
            try {
                standardLibrary.getSetType();
            }
            catch (IllegalLibraryException e) {
                this.addLibraryError((List<Resource.Diagnostic>)errors, e);
            }
            try {
                standardLibrary.getOrderedSetType();
            }
            catch (IllegalLibraryException e) {
                this.addLibraryError((List<Resource.Diagnostic>)errors, e);
            }
            try {
                standardLibrary.getOclEnumerationType();
            }
            catch (IllegalLibraryException e) {
                this.addLibraryError((List<Resource.Diagnostic>)errors, e);
            }
            try {
                standardLibrary.getOclTupleType();
            }
            catch (IllegalLibraryException e) {
                this.addLibraryError((List<Resource.Diagnostic>)errors, e);
            }
            try {
                standardLibrary.getOclLambdaType();
            }
            catch (IllegalLibraryException e) {
                this.addLibraryError((List<Resource.Diagnostic>)errors, e);
            }
        }
        super.resolveLazyCrossReferences(mon);
    }

    protected void setHasError(ElementCS csElement) {
        while (csElement instanceof PathElementCS || csElement instanceof PathNameCS) {
            csElement = csElement.getParent();
        }
        while (csElement instanceof ExpCS) {
            ((ExpCS)csElement).setHasError(true);
            csElement = csElement.getParent();
            if (!NavigationUtil.isNavigationInfixExp((EObject)csElement)) break;
        }
    }

    public final void setParserContext(@Nullable ParserContext parserContext) {
        this.parserContext = parserContext;
    }

    public void setProjectManager(@Nullable ProjectManager projectMap) {
        this.projectMap = projectMap;
    }

    public void update(@NonNull IDiagnosticConsumer diagnosticsConsumer) {
        CS2AS cs2as = this.getCS2AS();
        cs2as.update(diagnosticsConsumer);
    }

    public void updateFrom(@NonNull ASResource asResource, @NonNull EnvironmentFactory environmentFactory) {
        HashMap<EssentialOCLCSResource, ASResource> cs2asResourceMap = new HashMap<EssentialOCLCSResource, ASResource>();
        cs2asResourceMap.put(this, asResource);
        AS2CS as2cs = this.createAS2CS(cs2asResourceMap, (EnvironmentFactoryInternal)environmentFactory);
        as2cs.update();
    }

    protected static class RenamedDiagnostic
    extends AbstractDiagnostic {
        private final SyntaxErrorMessage syntaxErrorMessage;
        private final INode error;
        private final String newMessage;

        protected RenamedDiagnostic(SyntaxErrorMessage syntaxErrorMessage, INode error, String newMessage) {
            this.syntaxErrorMessage = syntaxErrorMessage;
            this.error = error;
            this.newMessage = newMessage;
        }

        public String getCode() {
            return this.syntaxErrorMessage.getIssueCode();
        }

        public int getColumn() {
            return -1;
        }

        public String[] getData() {
            return this.syntaxErrorMessage.getIssueData();
        }

        public String getMessage() {
            return this.newMessage;
        }

        protected INode getNode() {
            return this.error;
        }
    }

    public static class TransientASResource
    extends ASResourceImpl {
        protected final @NonNull ResourceSet asResourceSet;

        public TransientASResource(@NonNull ResourceSet asResourceSet, @NonNull URI asURI) {
            super(asURI, (ASResourceFactory)TransientASResourceFactory.INSTANCE);
            this.asResourceSet = asResourceSet;
        }

        public @NonNull ResourceSet getResourceSet() {
            return this.asResourceSet;
        }
    }

    public static class TransientASResourceFactory
    extends AbstractASResourceFactory {
        public static @NonNull TransientASResourceFactory INSTANCE = new TransientASResourceFactory();

        public TransientASResourceFactory() {
            super("transient");
        }

        public @NonNull ASResourceFactory getASResourceFactory() {
            return INSTANCE;
        }
    }

    protected static final class UnixOutputStream
    extends OutputStream {
        protected final @NonNull OutputStream outputStream;

        protected UnixOutputStream(@NonNull OutputStream outputStream) {
            this.outputStream = outputStream;
        }

        @Override
        public void write(int b) throws IOException {
            if (b != 13) {
                this.outputStream.write(b);
            }
        }
    }
}

