/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.opencert.sam.arg.arg.diagram.part;

import java.io.IOException;
import java.util.Collections;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.commands.operations.OperationHistoryFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.emf.cdo.dawn.commands.CreateSemanticResourceRecordingCommand;
import org.eclipse.emf.cdo.dawn.preferences.PreferenceConstants;
import org.eclipse.emf.cdo.dawn.transaction.DawnGMFEditingDomainFactory;
import org.eclipse.emf.cdo.dawn.ui.DawnEditorInput;
import org.eclipse.emf.cdo.dawn.util.connection.CDOConnectionUtil;
import org.eclipse.emf.cdo.transaction.CDOTransaction;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.workspace.util.WorkspaceSynchronizer;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.core.services.ViewService;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.opencert.sam.arg.arg.ArgFactory;
import org.eclipse.opencert.sam.arg.arg.diagram.part.ArgDiagramEditorPlugin;
import org.eclipse.opencert.sam.arg.arg.diagram.part.ArgDiagramEditorUtil;
import org.eclipse.opencert.sam.arg.arg.diagram.part.DawnArgDiagramEditor;
import org.eclipse.opencert.sam.arg.arg.diagram.part.Messages;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class DawnArgDiagramEditorUtil
extends ArgDiagramEditorUtil {
    public static boolean openDiagram(Resource diagram) throws PartInitException {
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        return page.openEditor((IEditorInput)new DawnEditorInput(diagram.getURI()), DawnArgDiagramEditor.ID) != null;
    }

    public static void runWizard(Shell shell, Wizard wizard, String settingsKey) {
        IDialogSettings pluginDialogSettings = ArgDiagramEditorPlugin.getInstance().getDialogSettings();
        IDialogSettings wizardDialogSettings = pluginDialogSettings.getSection(settingsKey);
        if (wizardDialogSettings == null) {
            wizardDialogSettings = pluginDialogSettings.addNewSection(settingsKey);
        }
        wizard.setDialogSettings(wizardDialogSettings);
        WizardDialog dialog = new WizardDialog(shell, (IWizard)wizard);
        dialog.create();
        dialog.getShell().setSize(Math.max(500, dialog.getShell().getSize().x), 500);
        dialog.open();
    }

    public static Resource createDiagram(URI diagramURI, URI modelURI, IProgressMonitor progressMonitor) {
        TransactionalEditingDomain editingDomain = DawnGMFEditingDomainFactory.getInstance().createEditingDomain();
        progressMonitor.beginTask(Messages.ArgDiagramEditorUtil_CreateDiagramProgressTask, 3);
        CDOConnectionUtil.instance.init(PreferenceConstants.getRepositoryName(), PreferenceConstants.getProtocol(), PreferenceConstants.getServerName());
        CDOConnectionUtil.instance.openSession();
        ResourceSet resourceSet = editingDomain.getResourceSet();
        CDOTransaction transaction = CDOConnectionUtil.instance.openCurrentTransaction(resourceSet, diagramURI.toString());
        final Resource diagramResource = resourceSet.createResource(diagramURI);
        CreateSemanticResourceRecordingCommand createSemanticResourceCommand = new CreateSemanticResourceRecordingCommand(editingDomain, transaction, modelURI.path());
        editingDomain.getCommandStack().execute((Command)createSemanticResourceCommand);
        final Resource modelResource = createSemanticResourceCommand.getResource();
        final String diagramName = diagramURI.lastSegment();
        AbstractTransactionalCommand command = new AbstractTransactionalCommand(editingDomain, Messages.ArgDiagramEditorUtil_CreateDiagramCommandLabel, Collections.EMPTY_LIST){

            protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                EObject model = null;
                if (modelResource.getContents().size() > 0) {
                    model = (EObject)modelResource.getContents().get(0);
                } else {
                    model = DawnArgDiagramEditorUtil.createInitialModel();
                    DawnArgDiagramEditorUtil.attachModelToResource(model, modelResource);
                }
                Diagram diagram = ViewService.createDiagram((EObject)model, (String)"Arg", (PreferencesHint)ArgDiagramEditorPlugin.DIAGRAM_PREFERENCES_HINT);
                if (diagram != null) {
                    diagramResource.getContents().add((Object)diagram);
                    diagram.setName(diagramName);
                    diagram.setElement(model);
                }
                try {
                    modelResource.save(Collections.EMPTY_MAP);
                    diagramResource.save(Collections.EMPTY_MAP);
                }
                catch (IOException e) {
                    ArgDiagramEditorPlugin.getInstance().logError("Unable to store model and diagram resources", (Throwable)e);
                }
                return CommandResult.newOKCommandResult();
            }
        };
        try {
            OperationHistoryFactory.getOperationHistory().execute((IUndoableOperation)command, (IProgressMonitor)new SubProgressMonitor(progressMonitor, 1), null);
        }
        catch (ExecutionException e) {
            ArgDiagramEditorPlugin.getInstance().logError("Unable to create model and diagram", (Throwable)e);
        }
        DawnArgDiagramEditorUtil.setCharset((IFile)WorkspaceSynchronizer.getFile((Resource)modelResource));
        DawnArgDiagramEditorUtil.setCharset((IFile)WorkspaceSynchronizer.getFile((Resource)diagramResource));
        return diagramResource;
    }

    private static EObject createInitialModel() {
        return ArgFactory.eINSTANCE.createCase();
    }

    private static void attachModelToResource(EObject model, Resource resource) {
        resource.getContents().add((Object)model);
    }
}

