/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.MARTE_Library.BasicNFP_Types;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum StatisticalQualifierKind implements Enumerator
{
    MAX(0, "max", "max"),
    MIN(1, "min", "min"),
    MEAN(2, "mean", "mean"),
    RANGE(3, "range", "range"),
    PERCENT(4, "percent", "percent"),
    DISTRIB(5, "distrib", "distrib"),
    DETERM(6, "determ", "determ"),
    OTHER(7, "other", "other"),
    VARIANCE(8, "variance", "variance");

    public static final int MAX_VALUE = 0;
    public static final int MIN_VALUE = 1;
    public static final int MEAN_VALUE = 2;
    public static final int RANGE_VALUE = 3;
    public static final int PERCENT_VALUE = 4;
    public static final int DISTRIB_VALUE = 5;
    public static final int DETERM_VALUE = 6;
    public static final int OTHER_VALUE = 7;
    public static final int VARIANCE_VALUE = 8;
    private static final StatisticalQualifierKind[] VALUES_ARRAY;
    public static final List<StatisticalQualifierKind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new StatisticalQualifierKind[]{MAX, MIN, MEAN, RANGE, PERCENT, DISTRIB, DETERM, OTHER, VARIANCE};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static StatisticalQualifierKind get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            StatisticalQualifierKind result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static StatisticalQualifierKind getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            StatisticalQualifierKind result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static StatisticalQualifierKind get(int value) {
        switch (value) {
            case 0: {
                return MAX;
            }
            case 1: {
                return MIN;
            }
            case 2: {
                return MEAN;
            }
            case 3: {
                return RANGE;
            }
            case 4: {
                return PERCENT;
            }
            case 5: {
                return DISTRIB;
            }
            case 6: {
                return DETERM;
            }
            case 7: {
                return OTHER;
            }
            case 8: {
                return VARIANCE;
            }
        }
        return null;
    }

    private StatisticalQualifierKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

