/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.textedit.port.xtext.ui.contribution;

import com.google.inject.Injector;
import java.util.LinkedList;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest;
import org.eclipse.papyrus.extensionpoints.editors.configuration.ICustomDirectEditorConfiguration;
import org.eclipse.papyrus.infra.services.edit.service.ElementEditServiceUtils;
import org.eclipse.papyrus.infra.services.edit.service.IElementEditService;
import org.eclipse.papyrus.uml.alf.naming.ALFIDConverter;
import org.eclipse.papyrus.uml.textedit.port.xtext.ui.contribution.UMLPortEditorPropertyUtil;
import org.eclipse.papyrus.uml.textedit.port.xtext.ui.internal.UmlPortActivator;
import org.eclipse.papyrus.uml.textedit.port.xtext.umlPort.BooleanLiterals;
import org.eclipse.papyrus.uml.textedit.port.xtext.umlPort.BooleanValue;
import org.eclipse.papyrus.uml.textedit.port.xtext.umlPort.BoundSpecification;
import org.eclipse.papyrus.uml.textedit.port.xtext.umlPort.IntValue;
import org.eclipse.papyrus.uml.textedit.port.xtext.umlPort.ModifierSpecification;
import org.eclipse.papyrus.uml.textedit.port.xtext.umlPort.NoValue;
import org.eclipse.papyrus.uml.textedit.port.xtext.umlPort.NullValue;
import org.eclipse.papyrus.uml.textedit.port.xtext.umlPort.PortRule;
import org.eclipse.papyrus.uml.textedit.port.xtext.umlPort.RealValue;
import org.eclipse.papyrus.uml.textedit.port.xtext.umlPort.StringValue;
import org.eclipse.papyrus.uml.textedit.port.xtext.umlPort.TypeRule;
import org.eclipse.papyrus.uml.textedit.port.xtext.umlPort.Value;
import org.eclipse.papyrus.uml.textedit.port.xtext.umlPort.util.UmlPortSwitch;
import org.eclipse.papyrus.uml.xtext.integration.DefaultXtextDirectEditorConfiguration;
import org.eclipse.papyrus.uml.xtext.integration.MultiplicityXTextParserUtils;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.LiteralBoolean;
import org.eclipse.uml2.uml.LiteralInteger;
import org.eclipse.uml2.uml.LiteralNull;
import org.eclipse.uml2.uml.LiteralReal;
import org.eclipse.uml2.uml.LiteralString;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.UMLFactory;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.ValueSpecification;
import org.eclipse.uml2.uml.VisibilityKind;
import org.eclipse.xtext.EcoreUtil2;

public class PortXtextDirectEditorConfiguration
extends DefaultXtextDirectEditorConfiguration
implements ICustomDirectEditorConfiguration {
    public Injector getInjector() {
        return UmlPortActivator.getInstance().getInjector("org.eclipse.papyrus.uml.textedit.port.xtext.UmlPort");
    }

    public ICommand getParseCommand(EObject modelObject, EObject xtextObject) {
        Value newDefault;
        ValueSpecification currentDefault;
        IEditCommandRequest request;
        Property property = (Property)modelObject;
        xtextObject = EcoreUtil2.getContainerOfType((EObject)xtextObject, PortRule.class);
        PortRule portRuleObject = (PortRule)xtextObject;
        CompositeCommand updateCommand = new CompositeCommand("Property update");
        IElementEditService provider = ElementEditServiceUtils.getCommandProvider((Object)property);
        boolean newIsDerived = portRuleObject.isDerived();
        boolean newIsConjugated = portRuleObject.isConjugated();
        if (portRuleObject.getModifiers() != null) {
            boolean newIsOrdered = false;
            boolean newIsReadOnly = false;
            boolean newIsUnion = false;
            boolean newIsUnique = false;
            LinkedList<Port> newRedefines = new LinkedList<Port>();
            LinkedList<Port> newSubsets = new LinkedList<Port>();
            for (ModifierSpecification modifier : portRuleObject.getModifiers().getValues()) {
                if (modifier.getRedefines() != null || modifier.getSubsets() != null) continue;
                switch (modifier.getValue()) {
                    case ORDERED: {
                        newIsOrdered = true;
                        break;
                    }
                    case READ_ONLY: {
                        newIsReadOnly = true;
                        break;
                    }
                    case UNION: {
                        newIsUnion = true;
                        break;
                    }
                    case UNIQUE: {
                        newIsUnique = true;
                        break;
                    }
                }
            }
            for (ModifierSpecification modifier : portRuleObject.getModifiers().getValues()) {
                if (modifier.getRedefines() != null) {
                    newRedefines.add(modifier.getRedefines().getPort());
                    continue;
                }
                if (modifier.getSubsets() == null) continue;
                newSubsets.add(modifier.getSubsets().getPort());
            }
            SetRequest setIsReadOnlyRequest = new SetRequest((EObject)property, (EStructuralFeature)UMLPackage.eINSTANCE.getStructuralFeature_IsReadOnly(), (Object)newIsReadOnly);
            ICommand setIsReadOnlyCommand = provider.getEditCommand((IEditCommandRequest)setIsReadOnlyRequest);
            updateCommand.add((IUndoableOperation)setIsReadOnlyCommand);
            SetRequest setIsUniqueRequest = new SetRequest((EObject)property, (EStructuralFeature)UMLPackage.eINSTANCE.getMultiplicityElement_IsUnique(), (Object)newIsUnique);
            ICommand setIsUniqueCommand = provider.getEditCommand((IEditCommandRequest)setIsUniqueRequest);
            updateCommand.add((IUndoableOperation)setIsUniqueCommand);
            SetRequest setIsDerivedUnionRequest = new SetRequest((EObject)property, (EStructuralFeature)UMLPackage.eINSTANCE.getProperty_IsDerivedUnion(), (Object)newIsUnion);
            ICommand setIsDerivedUnionCommand = provider.getEditCommand((IEditCommandRequest)setIsDerivedUnionRequest);
            updateCommand.add((IUndoableOperation)setIsDerivedUnionCommand);
            SetRequest setIsOrderedRequest = new SetRequest((EObject)property, (EStructuralFeature)UMLPackage.eINSTANCE.getMultiplicityElement_IsOrdered(), (Object)newIsOrdered);
            ICommand setIsOrderedCommand = provider.getEditCommand((IEditCommandRequest)setIsOrderedRequest);
            updateCommand.add((IUndoableOperation)setIsOrderedCommand);
            SetRequest setRedefinedPropertiesRequest = new SetRequest((EObject)property, (EStructuralFeature)UMLPackage.eINSTANCE.getProperty_RedefinedProperty(), newRedefines);
            ICommand setRedefinedPropertiesCommand = provider.getEditCommand((IEditCommandRequest)setRedefinedPropertiesRequest);
            updateCommand.add((IUndoableOperation)setRedefinedPropertiesCommand);
            SetRequest setSubsettedPropertiesRequest = new SetRequest((EObject)property, (EStructuralFeature)UMLPackage.eINSTANCE.getProperty_SubsettedProperty(), newSubsets);
            ICommand setSubsettedPropertiesCommand = provider.getEditCommand((IEditCommandRequest)setSubsettedPropertiesRequest);
            updateCommand.add((IUndoableOperation)setSubsettedPropertiesCommand);
        }
        if (portRuleObject.getMultiplicity() != null) {
            updateCommand.add((IUndoableOperation)this.updateMultiplicityCommand(provider, (EObject)property, portRuleObject));
        }
        if (portRuleObject.getDefault() != null && (request = (IEditCommandRequest)new UmlPortSwitch<IEditCommandRequest>(currentDefault = property.getDefaultValue(), property){
            private final /* synthetic */ ValueSpecification val$currentDefault;
            private final /* synthetic */ Property val$property;
            {
                this.val$currentDefault = valueSpecification;
                this.val$property = property;
            }

            public SetRequest caseBooleanValue(BooleanValue object) {
                boolean booleanValue;
                boolean bl = booleanValue = object.getLiteralBoolean() == BooleanLiterals.TRUE;
                if (this.val$currentDefault instanceof LiteralBoolean) {
                    return new SetRequest((EObject)this.val$currentDefault, (EStructuralFeature)UMLPackage.eINSTANCE.getLiteralBoolean_Value(), (Object)booleanValue);
                }
                LiteralBoolean literalBoolean = UMLFactory.eINSTANCE.createLiteralBoolean();
                literalBoolean.setValue(booleanValue);
                return new SetRequest((EObject)this.val$property, (EStructuralFeature)UMLPackage.eINSTANCE.getProperty_DefaultValue(), (Object)literalBoolean);
            }

            public SetRequest caseStringValue(StringValue object) {
                String stringValue = object.getLiteralString();
                if (this.val$currentDefault instanceof LiteralString) {
                    return new SetRequest((EObject)this.val$currentDefault, (EStructuralFeature)UMLPackage.eINSTANCE.getLiteralString_Value(), (Object)stringValue);
                }
                LiteralString literalString = UMLFactory.eINSTANCE.createLiteralString();
                literalString.setValue(stringValue);
                return new SetRequest((EObject)this.val$property, (EStructuralFeature)UMLPackage.eINSTANCE.getProperty_DefaultValue(), (Object)literalString);
            }

            public SetRequest caseIntValue(IntValue object) {
                Integer integerValue;
                try {
                    integerValue = object.getLiteralInteger();
                }
                catch (NumberFormatException ex) {
                    integerValue = 0;
                }
                if (this.val$currentDefault instanceof LiteralInteger) {
                    return new SetRequest((EObject)this.val$currentDefault, (EStructuralFeature)UMLPackage.eINSTANCE.getLiteralInteger_Value(), (Object)integerValue);
                }
                LiteralInteger literalInteger = UMLFactory.eINSTANCE.createLiteralInteger();
                literalInteger.setValue(integerValue.intValue());
                return new SetRequest((EObject)this.val$property, (EStructuralFeature)UMLPackage.eINSTANCE.getProperty_DefaultValue(), (Object)literalInteger);
            }

            public SetRequest caseRealValue(RealValue object) {
                Double realValue;
                String literalDouble = "" + object.getInteger() + '.' + object.getFraction();
                try {
                    realValue = Double.parseDouble(literalDouble);
                }
                catch (NumberFormatException ex) {
                    realValue = 0.0;
                }
                if (this.val$currentDefault instanceof LiteralReal) {
                    return new SetRequest((EObject)this.val$currentDefault, (EStructuralFeature)UMLPackage.eINSTANCE.getLiteralReal_Value(), (Object)realValue);
                }
                LiteralReal literalReal = UMLFactory.eINSTANCE.createLiteralReal();
                literalReal.setValue(realValue.doubleValue());
                return new SetRequest((EObject)this.val$property, (EStructuralFeature)UMLPackage.eINSTANCE.getProperty_DefaultValue(), (Object)literalReal);
            }

            public IEditCommandRequest caseNullValue(NullValue object) {
                if (this.val$property.getDefaultValue() instanceof LiteralNull) {
                    return null;
                }
                LiteralNull literalNull = UMLFactory.eINSTANCE.createLiteralNull();
                return new SetRequest((EObject)this.val$property, (EStructuralFeature)UMLPackage.eINSTANCE.getProperty_DefaultValue(), (Object)literalNull);
            }

            public IEditCommandRequest caseNoValue(NoValue object) {
                if (this.val$property.getDefaultValue() == null) {
                    return null;
                }
                return new DestroyElementRequest((EObject)this.val$property.getDefaultValue(), false);
            }
        }.doSwitch((EObject)(newDefault = portRuleObject.getDefault().getDefault()))) != null) {
            ICommand setDefaultValueCommand = provider.getEditCommand(request);
            updateCommand.add((IUndoableOperation)setDefaultValueCommand);
        }
        String newName = ALFIDConverter.IDtoName((String)portRuleObject.getName());
        Classifier newType = null;
        boolean setType = false;
        TypeRule typeRule = portRuleObject.getType();
        if (portRuleObject.isTypeUndefined()) {
            setType = true;
        } else if (typeRule != null) {
            setType = true;
            newType = typeRule.getType();
        }
        if (newType == property.getType()) {
            setType = false;
        }
        if (setType) {
            SetRequest setTypeRequest = new SetRequest((EObject)property, (EStructuralFeature)UMLPackage.eINSTANCE.getTypedElement_Type(), (Object)newType);
            ICommand setTypeCommand = provider.getEditCommand((IEditCommandRequest)setTypeRequest);
            updateCommand.add((IUndoableOperation)setTypeCommand);
        }
        if (portRuleObject.getVisibility() != null) {
            VisibilityKind newVisibility = VisibilityKind.PUBLIC_LITERAL;
            switch (portRuleObject.getVisibility().getVisibility()) {
                case PUBLIC: {
                    newVisibility = VisibilityKind.PUBLIC_LITERAL;
                    break;
                }
                case PACKAGE: {
                    newVisibility = VisibilityKind.PACKAGE_LITERAL;
                    break;
                }
                case PRIVATE: {
                    newVisibility = VisibilityKind.PRIVATE_LITERAL;
                    break;
                }
                case PROTECTED: {
                    newVisibility = VisibilityKind.PROTECTED_LITERAL;
                    break;
                }
            }
            SetRequest setVisibilityRequest = new SetRequest((EObject)property, (EStructuralFeature)UMLPackage.eINSTANCE.getNamedElement_Visibility(), (Object)newVisibility);
            ICommand setVisibilityCommand = provider.getEditCommand((IEditCommandRequest)setVisibilityRequest);
            updateCommand.add((IUndoableOperation)setVisibilityCommand);
        }
        SetRequest setIsDerivedRequest = new SetRequest((EObject)property, (EStructuralFeature)UMLPackage.eINSTANCE.getProperty_IsDerived(), (Object)newIsDerived);
        ICommand setIsDerivedCommand = provider.getEditCommand((IEditCommandRequest)setIsDerivedRequest);
        updateCommand.add((IUndoableOperation)setIsDerivedCommand);
        SetRequest setIsConjugatedRequest = new SetRequest((EObject)property, (EStructuralFeature)UMLPackage.eINSTANCE.getPort_IsConjugated(), (Object)newIsConjugated);
        ICommand setIsConjugatedCommand = provider.getEditCommand((IEditCommandRequest)setIsConjugatedRequest);
        updateCommand.add((IUndoableOperation)setIsConjugatedCommand);
        SetRequest setNameRequest = new SetRequest((EObject)property, (EStructuralFeature)UMLPackage.eINSTANCE.getNamedElement_Name(), (Object)newName);
        ICommand setNameCommand = provider.getEditCommand((IEditCommandRequest)setNameRequest);
        updateCommand.add((IUndoableOperation)setNameCommand);
        return updateCommand;
    }

    public String getTextToEdit(Object editedObject) {
        if (editedObject instanceof Property) {
            return UMLPortEditorPropertyUtil.getLabel((Port)editedObject).trim();
        }
        return "not a Property";
    }

    private ICommand updateMultiplicityCommand(IElementEditService provider, EObject eObject, PortRule portRuleObject) {
        ICommand result = null;
        result = portRuleObject.getMultiplicity().getBounds().size() == 1 ? MultiplicityXTextParserUtils.updateOneMultiplicityCommand((IElementEditService)provider, (EObject)eObject, (String)((BoundSpecification)portRuleObject.getMultiplicity().getBounds().get(0)).getValue()) : MultiplicityXTextParserUtils.updateTwoMultiplicityCommand((IElementEditService)provider, (EObject)eObject, (String)((BoundSpecification)portRuleObject.getMultiplicity().getBounds().get(0)).getValue(), (String)((BoundSpecification)portRuleObject.getMultiplicity().getBounds().get(1)).getValue());
        return result;
    }
}

