/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.ui.history;

import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.common.branch.CDOBranchVersion;
import org.eclipse.emf.cdo.common.commit.CDOCommitInfo;
import org.eclipse.emf.cdo.common.commit.CDOCommitInfoManager;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.common.revision.CDORevisionManager;
import org.eclipse.emf.cdo.internal.ui.history.Net;
import org.eclipse.emf.cdo.internal.ui.history.Segment;
import org.eclipse.emf.cdo.internal.ui.history.SegmentList;
import org.eclipse.emf.cdo.session.CDOSession;
import org.eclipse.swt.graphics.Color;

public class Branch
extends SegmentList {
    private final CDOBranch cdoBranch;
    private final Color color;
    private Branch baseCommitBranch;
    private long baseCommitTime;
    private long firstCommitTime;
    private long lastCommitTime;

    public Branch(Net net, CDOBranch cdoBranch) {
        super(net);
        this.cdoBranch = cdoBranch;
        this.color = net.getColor(cdoBranch.getID());
        CDOSession session = net.getSession();
        CDOID objectID = net.getObjectID();
        if (objectID != null) {
            CDOBranchPoint lastPoint;
            CDORevisionManager revisionManager = session.getRevisionManager();
            CDORevision lastRevision = revisionManager.getRevision(objectID, lastPoint = cdoBranch.getHead(), -1, 0, true);
            if (lastRevision != null && lastRevision.getBranch() == cdoBranch) {
                CDOBranchVersion firstVersion = cdoBranch.getVersion(1);
                CDORevision firstRevision = revisionManager.getRevisionByVersion(objectID, firstVersion, -1, true);
                this.firstCommitTime = firstRevision.getTimeStamp();
                this.lastCommitTime = lastRevision.getTimeStamp();
            }
        } else {
            CDOCommitInfo lastCommit;
            CDOCommitInfoManager commitInfoManager = session.getCommitInfoManager();
            CDOCommitInfo firstCommit = commitInfoManager.getFirstOfBranch(cdoBranch);
            if (firstCommit != null) {
                this.firstCommitTime = firstCommit.getTimeStamp();
            }
            if ((lastCommit = commitInfoManager.getLastOfBranch(cdoBranch)) != null) {
                this.lastCommitTime = lastCommit.getTimeStamp();
            }
        }
    }

    public final CDOBranch getCDOBranch() {
        return this.cdoBranch;
    }

    public final Color getColor() {
        return this.color;
    }

    @Deprecated
    public final Branch getBaseBranch() {
        CDOBranchPoint cdoBase = this.cdoBranch.getBase();
        CDOBranch cdoBaseBranch = cdoBase.getBranch();
        if (cdoBaseBranch == null) {
            return null;
        }
        Net net = this.getNet();
        return net.getBranch(cdoBaseBranch);
    }

    @Deprecated
    public final long getBaseTime() {
        return this.cdoBranch.getBase().getTimeStamp();
    }

    public final Branch getBaseCommitBranch() {
        this.determineBaseCommitIfNeeded();
        return this.baseCommitBranch;
    }

    public final long getBaseCommitTime() {
        this.determineBaseCommitIfNeeded();
        return this.baseCommitTime;
    }

    public final long getFirstCommitTime() {
        return this.firstCommitTime;
    }

    public final long getLastCommitTime() {
        return this.lastCommitTime;
    }

    public final Segment getSegmentFrom(Segment[] segments) {
        int i = 0;
        while (i < segments.length) {
            Segment segment = segments[i];
            if (segment != null && segment.getBranch() == this) {
                return segment;
            }
            ++i;
        }
        return null;
    }

    public String toString() {
        return "Branch[" + this.cdoBranch.getPathName() + "]";
    }

    void adjustCommitTimes(long time) {
        if (this.firstCommitTime == 0L) {
            this.firstCommitTime = time;
            this.lastCommitTime = time;
        } else {
            if (time < this.firstCommitTime) {
                throw new RuntimeException("Must not happen because the constructor initializes firstCommitTime");
            }
            if (time > this.lastCommitTime) {
                this.lastCommitTime = time;
            }
        }
    }

    private void determineBaseCommitIfNeeded() {
        if (this.baseCommitTime != 0L || this.cdoBranch.isMainBranch()) {
            return;
        }
        CDOCommitInfoManager commitInfoManager = this.getNet().getSession().getCommitInfoManager();
        CDOCommitInfo commitInfo = commitInfoManager.getBaseOfBranch(this.cdoBranch);
        this.baseCommitTime = commitInfo.getTimeStamp();
    }

    protected Segment getNextSegment(Segment segment) {
        return segment.getNextInBranch();
    }

    protected void setNextSegment(Segment segment, Segment nextSegment) {
        segment.setNextInBranch(nextSegment);
    }

    protected Segment getPreviousSegment(Segment segment) {
        return segment.getPreviousInBranch();
    }

    protected void setPreviousSegment(Segment segment, Segment previousSegment) {
        segment.setPreviousInBranch(previousSegment);
    }
}

