/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.ui.history;

import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.commit.CDOCommitInfo;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.internal.ui.history.Branch;
import org.eclipse.emf.cdo.internal.ui.history.Commit;
import org.eclipse.emf.cdo.internal.ui.history.Segment;
import org.eclipse.emf.cdo.internal.ui.history.Track;
import org.eclipse.emf.cdo.session.CDOSession;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;

public class Net {
    private static final RGB[] RGBS = new RGB[]{new RGB(133, 166, 214), new RGB(221, 205, 93), new RGB(199, 134, 57), new RGB(131, 150, 98), new RGB(197, 123, 127), new RGB(139, 136, 140), new RGB(48, 135, 144), new RGB(190, 93, 66), new RGB(143, 163, 54), new RGB(180, 148, 74), new RGB(101, 101, 217), new RGB(72, 153, 119), new RGB(23, 101, 160), new RGB(132, 164, 118), new RGB(255, 230, 59), new RGB(136, 176, 70), new RGB(255, 138, 1), new RGB(123, 187, 95), new RGB(233, 88, 98), new RGB(93, 158, 254), new RGB(175, 215, 0), new RGB(140, 134, 142), new RGB(232, 168, 21), new RGB(0, 172, 191), new RGB(251, 58, 4), new RGB(63, 64, 255), new RGB(27, 194, 130), new RGB(0, 104, 183)};
    private static final Segment[] NO_SEGMENTS = new Segment[0];
    private final CDOSession session;
    private final CDOID objectID;
    private final ResourceManager resourceManager;
    private Color[] colors;
    private Track[] tracks = new Track[0];
    private Map<CDOBranch, Branch> branches = new HashMap<CDOBranch, Branch>();
    private Map<CDOCommitInfo, Commit> commits = new WeakHashMap<CDOCommitInfo, Commit>();
    private int commitCounter;
    private Commit firstCommit;
    private Commit lastCommit;

    public Net(CDOSession session, CDOID objectID, ResourceManager resourceManager) {
        this.session = session;
        this.objectID = objectID;
        this.resourceManager = resourceManager;
    }

    public final CDOSession getSession() {
        return this.session;
    }

    public final CDOID getObjectID() {
        return this.objectID;
    }

    public final Track[] getTracks() {
        return this.tracks;
    }

    public final Commit getFirstCommit() {
        return this.firstCommit;
    }

    public final Commit getLastCommit() {
        return this.lastCommit;
    }

    public Color getColor(int number) {
        int index;
        if (this.colors == null) {
            this.colors = new Color[RGBS.length];
        }
        if (this.colors[index = number % RGBS.length] == null) {
            RGB rgb = RGBS[index];
            this.colors[index] = this.resourceManager.createColor(rgb);
        }
        return this.colors[index];
    }

    public String toString() {
        return "Net[" + this.session + ", " + this.objectID + "]";
    }

    public final Branch getBranch(CDOBranch cdoBranch) {
        Branch branch = this.branches.get(cdoBranch);
        if (branch == null) {
            branch = new Branch(this, cdoBranch);
            this.branches.put(cdoBranch, branch);
        }
        return branch;
    }

    public final Commit getCommit(CDOCommitInfo commitInfo) {
        Commit commit = this.commits.get(commitInfo);
        if (commit == null) {
            commit = this.addCommit(commitInfo);
        }
        return commit;
    }

    private final Segment getSegment(CDOCommitInfo commitInfo) {
        CDOBranch cdoBranch = commitInfo.getBranch();
        long time = commitInfo.getTimeStamp();
        Branch branch = this.getBranch(cdoBranch);
        Segment segment = branch.getSegment(time);
        if (segment == null) {
            boolean afterLast = this.isAfterLast(time);
            segment = this.getOrCreateSegment(branch, time, afterLast);
        }
        branch.adjustCommitTimes(time);
        segment.adjustCommitTimes(time);
        return segment;
    }

    private Segment getOrCreateSegment(Branch branch, long time, boolean afterLast) {
        if (!afterLast && this.firstCommit != null) {
            Segment[] rowSegments = this.firstCommit.getRowSegments();
            int i = 0;
            while (i < rowSegments.length) {
                Segment rowSegment = rowSegments[i];
                if (rowSegment != null && !rowSegment.isComplete()) {
                    Branch rowBranch = rowSegment.getBranch();
                    boolean complete = rowBranch.getBaseCommitTime() == time;
                    rowSegment.adjustVisualTime(time, complete);
                }
                ++i;
            }
        }
        Segment bestSegment = null;
        long visualTime = 0L;
        int i = 0;
        while (i < this.tracks.length) {
            Track track = this.tracks[i];
            if (afterLast) {
                Segment lastSegment = track.getLastSegment();
                if (lastSegment != null) {
                    if (lastSegment.getBranch() == branch) {
                        return lastSegment;
                    }
                    if (branch.getBaseCommitBranch() != lastSegment.getBranch() && (this.lastCommit == null || this.lastCommit.getTime() != lastSegment.getLastCommitTime())) {
                        if (visualTime == 0L) {
                            Segment lastBranchSegment = branch.getLastSegment();
                            visualTime = lastBranchSegment != null ? lastBranchSegment.getLastCommitTime() : branch.getBaseCommitTime();
                        }
                        if (bestSegment == null && lastSegment.getLastCommitTime() < visualTime) {
                            bestSegment = lastSegment;
                        }
                    }
                }
            } else {
                Segment firstSegment = track.getFirstSegment();
                if (firstSegment != null) {
                    Branch firstBranch = firstSegment.getBranch();
                    if (firstBranch == branch) {
                        return firstSegment;
                    }
                    if (bestSegment == null && firstSegment.isComplete() && firstBranch.getBaseCommitBranch() != branch && firstSegment.getFirstVisualTime() > branch.getFirstCommitTime()) {
                        bestSegment = firstSegment;
                    }
                }
            }
            ++i;
        }
        Track track = bestSegment != null ? bestSegment.getTrack() : this.createTrack();
        Segment segment = new Segment(track, branch);
        track.addSegment(segment, afterLast);
        branch.addSegment(segment, afterLast);
        if (visualTime != 0L) {
            segment.adjustVisualTime(visualTime, true);
        }
        return segment;
    }

    private Track createTrack() {
        Track track;
        int length = this.tracks.length;
        Track[] newArray = new Track[length + 1];
        if (length != 0) {
            System.arraycopy(this.tracks, 0, newArray, 0, length);
        }
        newArray[length] = track = new Track(this, length);
        this.tracks = newArray;
        return track;
    }

    private boolean isAfterLast(long time) {
        if (this.lastCommit == null) {
            return true;
        }
        if (time > this.lastCommit.getTime()) {
            return true;
        }
        if (time < this.firstCommit.getTime()) {
            return false;
        }
        throw new IllegalArgumentException("New commits must not be added between the first and last commits");
    }

    Segment[] createRowSegments(long time) {
        Segment[] segments = NO_SEGMENTS;
        int i = this.tracks.length - 1;
        while (i >= 0) {
            block4: {
                Segment segment;
                block3: {
                    Track track = this.tracks[i];
                    segment = track.getSegment(time);
                    if (segments != NO_SEGMENTS) break block3;
                    if (segment == null) break block4;
                    segments = new Segment[i + 1];
                }
                segments[i] = segment;
            }
            --i;
        }
        return segments;
    }

    Commit addCommit(CDOCommitInfo commitInfo) {
        Segment segment = this.getSegment(commitInfo);
        if (segment == null) {
            throw new IllegalStateException("No segment");
        }
        ++this.commitCounter;
        Commit commit = new Commit(commitInfo, segment);
        if (this.firstCommit == null) {
            this.firstCommit = commit;
            this.lastCommit = commit;
        } else {
            long time = commit.getTime();
            if (time < this.firstCommit.getTime()) {
                this.firstCommit = commit;
            } else if (time > this.lastCommit.getTime()) {
                this.lastCommit = commit;
            }
        }
        this.commits.put(commitInfo, commit);
        return commit;
    }

    int getCommitCounter() {
        return this.commitCounter;
    }
}

