/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.net4j.protocol;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.Collection;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.lock.CDOLockState;
import org.eclipse.emf.cdo.common.protocol.CDODataInput;
import org.eclipse.emf.cdo.common.protocol.CDODataOutput;
import org.eclipse.emf.cdo.internal.net4j.protocol.CDOClientProtocol;
import org.eclipse.emf.cdo.internal.net4j.protocol.CDOClientRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LockStateRequest
extends CDOClientRequest<CDOLockState[]> {
    private int viewID;
    private Collection<CDOID> ids;
    private int prefetchDepth;

    public LockStateRequest(CDOClientProtocol protocol, int viewID, Collection<CDOID> ids, int prefetchDepth) {
        super(protocol, (short)52);
        this.viewID = viewID;
        this.ids = ids;
        this.prefetchDepth = prefetchDepth;
    }

    @Override
    protected void requesting(CDODataOutput out) throws IOException {
        out.writeInt(this.viewID);
        if (this.prefetchDepth == 0) {
            out.writeInt(this.ids.size());
        } else {
            out.writeInt(-this.ids.size());
            out.writeInt(this.prefetchDepth);
        }
        for (CDOID id : this.ids) {
            out.writeCDOID(id);
        }
    }

    @Override
    protected CDOLockState[] confirming(CDODataInput in) throws IOException {
        int n = in.readInt();
        CDOLockState[] lockStates = new CDOLockState[n];
        int i = 0;
        while (i < n) {
            lockStates[i] = in.readCDOLockState();
            ++i;
        }
        return lockStates;
    }

    public String toString() {
        return MessageFormat.format("LockStateRequest(viewID={0}, ids={1}, prefetchDepth={2})", this.viewID, this.ids, this.prefetchDepth);
    }
}

