/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.widgets.providers;

import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.papyrus.infra.widgets.providers.AbstractTreeFilter;
import org.eclipse.ui.internal.misc.StringMatcher;

public class PatternViewerFilter
extends AbstractTreeFilter {
    private StringMatcher[] validPatterns = new StringMatcher[]{new StringMatcher("*", true, false)};
    private String currentPattern;
    private boolean strict = false;

    public void setStrict(boolean strict) {
        this.strict = strict;
    }

    public void setPattern(String value) {
        if (value.equals(this.currentPattern)) {
            return;
        }
        this.currentPattern = value;
        String[] patterns = value.split(";");
        this.validPatterns = new StringMatcher[patterns.length];
        int i = 0;
        String[] stringArray = patterns;
        int n = patterns.length;
        int n2 = 0;
        while (n2 < n) {
            String pattern = stringArray[n2];
            if (!this.strict) {
                pattern = "*" + pattern.trim() + "*";
            }
            this.validPatterns[i++] = new StringMatcher(pattern, true, false);
            ++n2;
        }
        this.clearCache();
    }

    @Override
    public boolean isVisible(Viewer viewer, Object parentElement, Object element) {
        IBaseLabelProvider labelProvider = ((StructuredViewer)viewer).getLabelProvider();
        if (labelProvider instanceof ILabelProvider) {
            StringMatcher[] stringMatcherArray = this.validPatterns;
            int n = this.validPatterns.length;
            int n2 = 0;
            while (n2 < n) {
                StringMatcher pattern = stringMatcherArray[n2];
                if (pattern.match(((ILabelProvider)labelProvider).getText(element))) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }
}

