/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.opencert.apm.assurproj.wizards.ui.wizards;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.cdo.CDOObject;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.dawn.preferences.PreferenceConstants;
import org.eclipse.emf.cdo.dawn.ui.DawnEditorInput;
import org.eclipse.emf.cdo.dawn.util.connection.CDOConnectionUtil;
import org.eclipse.emf.cdo.eresource.CDOResource;
import org.eclipse.emf.cdo.eresource.CDOResourceFolder;
import org.eclipse.emf.cdo.eresource.CDOResourceNode;
import org.eclipse.emf.cdo.session.CDOSession;
import org.eclipse.emf.cdo.transaction.CDOTransaction;
import org.eclipse.emf.cdo.util.CDOUtil;
import org.eclipse.emf.cdo.util.CommitException;
import org.eclipse.emf.cdo.util.ConcurrentAccessException;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.ui.URIEditorInput;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.impl.DiagramImpl;
import org.eclipse.gmf.runtime.notation.impl.NodeImpl;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.opencert.apm.assurproj.assuranceproject.AssetsPackage;
import org.eclipse.opencert.apm.assurproj.assuranceproject.AssuranceProject;
import org.eclipse.opencert.apm.assurproj.assuranceproject.AssuranceprojectFactory;
import org.eclipse.opencert.apm.assurproj.assuranceproject.AssuranceprojectPackage;
import org.eclipse.opencert.apm.assurproj.assuranceproject.BaselineConfig;
import org.eclipse.opencert.apm.assurproj.assuranceproject.PermissionConfig;
import org.eclipse.opencert.apm.assurproj.assuranceproject.presentation.AssuranceprojectEditorPlugin;
import org.eclipse.opencert.apm.assurproj.wizards.ui.wizards.DawnArgDiagramUtil;
import org.eclipse.opencert.apm.assurproj.wizards.ui.wizards.DawnBaselineDiagramUtil;
import org.eclipse.opencert.apm.assurproj.wizards.ui.wizards.Etl.CDOTransformHandler;
import org.eclipse.opencert.apm.assurproj.wizards.ui.wizards.Etl.RedirectSystemErr;
import org.eclipse.opencert.apm.baseline.baseline.BaseAssurableElement;
import org.eclipse.opencert.apm.baseline.baseline.BaseFramework;
import org.eclipse.opencert.apm.baseline.baseline.BaselineFactory;
import org.eclipse.opencert.apm.baseline.baseline.BaselinePackage;
import org.eclipse.opencert.infra.mappings.mapping.MapGroup;
import org.eclipse.opencert.infra.mappings.mapping.MapModel;
import org.eclipse.opencert.infra.mappings.mapping.MappingFactory;
import org.eclipse.opencert.infra.mappings.mapping.MappingPackage;
import org.eclipse.opencert.pkm.refframework.refframework.RefFramework;
import org.eclipse.opencert.sam.arg.arg.Case;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class AssurProjInitializationHelper {
    private static final String COMPLIANCE = "Compliance";
    private static final String GROUP = "Group";
    private static final String MAPMODEL_CLASS = "MapModel";
    private static final String MAPGROUP_CLASS = "MapGroup";
    private static final String REFFRAMEWORK_CLASS = "RefFramework";
    private static final String PERMISSIONCONFIG_CLASS = "PermissionConfig";
    private static final String ASSETSPACKAGE_CLASS = "AssetsPackage";
    private static final String BASELINECONFIG_CLASS = "BaselineConfig";
    private static final String ASSURANCEPROJECT_CLASS = "AssuranceProject";
    private static final String MAPPING = ".mapping";
    private static final String BASELINE_DIAGRAM = ".baseline_diagram";
    private static final String BASELINE = ".baseline";
    private static final String ASSURANCEPROJECT = ".assuranceproject";
    private static final String PROCESSES = "Processes";
    private static final String ARGUMENTATION = "Argumentation";
    private static final String ARGUMENTATION_NsPrefix = ".arg";
    private static final String REFFRAMEWORK_DIAGRAM = ".refframework_diagram";
    private static final String EVIDENCE = "Evidence";
    private static final String ASSURANCE_PROJECT = "Assurance Project";
    private static final String ASSURANCE_PROJECT2 = "Assurance%20Project";
    private static final String INITIALIZE_MODELS = "Initialize Models";
    private static final String DIAGRAM = "_diagram";
    private static final String UTF_8 = "UTF-8";
    private static final String CREATE_MODELS = "Create models";
    private static Map<EObject, EObject> map = new HashMap<EObject, EObject>();
    private static final Log logger = LogFactory.getLog(AssurProjInitializationHelper.class);
    private String projectName;
    protected AssuranceprojectPackage dprojectPackage = AssuranceprojectPackage.eINSTANCE;
    protected AssuranceprojectFactory dprojectFactory = this.dprojectPackage.getAssuranceprojectFactory();
    protected BaselinePackage baselinePackage = BaselinePackage.eINSTANCE;
    protected BaselineFactory baselineFactory = this.baselinePackage.getBaselineFactory();
    protected MappingPackage mappingPackage = MappingPackage.eINSTANCE;
    protected MappingFactory mappingFactory = this.mappingPackage.getMappingFactory();
    protected IWorkbench workbench;
    protected Object[] selectedReqs;
    protected String qrefDirectoryStandard;
    static int lastj = 0;
    static int nitems = 0;
    protected String baselineName = "";
    CDOResourceFolder projectFolder;
    CDOResourceFolder assuranceprojectFolder;
    CDOResourceFolder evidenceFolder;
    CDOResourceFolder argFolder;
    CDOResourceFolder procFolder;
    private boolean generateArgumentation;

    public AssurProjInitializationHelper(String projectName, boolean generateArgumentation) {
        RedirectSystemErr.out("prueba0");
        this.projectName = projectName;
        this.generateArgumentation = generateArgumentation;
    }

    private List<CDOResource> getDiagramsFromModel(CDOTransaction transaction, CDOResource modelCDO) {
        ArrayList<CDOResource> res = new ArrayList<CDOResource>();
        String temp = modelCDO.getPath();
        String sourceFolderPath = temp.substring(0, temp.lastIndexOf("/"));
        CDOResourceFolder frmFolder = transaction.getResourceFolder(sourceFolderPath);
        EList listN = frmFolder.getNodes();
        for (CDOResourceNode node : listN) {
            EObject model;
            CDOResource elem;
            if (node instanceof CDOResourceFolder) {
                System.out.println("getDiagramsFromModel: found subfolder =." + node.toString());
                List<CDOResource> res2 = this.getDiagramsFromModel(transaction, (CDOResource)node);
                res.addAll(res2);
                continue;
            }
            if (!(node instanceof CDOResource) || !(elem = (CDOResource)node).getPath().contains(REFFRAMEWORK_DIAGRAM) || (model = ((DiagramImpl)elem.getContents().get(0)).basicGetElement()).eResource().getURI() != modelCDO.getURI()) continue;
            res.add((CDOResource)((EObject)elem.getContents().get(0)).eResource());
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createCreateCommands(IProgressMonitor monitor, IWizardContainer container, Object[] reqs, String qrefStandard, String baselineName, URI projectModel) throws ExecutionException {
        CDOResource sourceResource;
        CompoundCommand compoundCommand = new CompoundCommand(CREATE_MODELS);
        CDOConnectionUtil.instance.getCurrentSession();
        CDOConnectionUtil.instance.init(PreferenceConstants.getRepositoryName(), PreferenceConstants.getProtocol(), PreferenceConstants.getServerName());
        CDOSession sessionCDO = CDOConnectionUtil.instance.openSession();
        CDOTransaction transaction = sessionCDO.openTransaction();
        CDOResource assuranceprojectResource = null;
        if (projectModel == null) {
            this.projectFolder = transaction.getOrCreateResourceFolder(this.projectName);
            this.assuranceprojectFolder = this.projectFolder.addResourceFolder("ASSURANCE_PROJECT");
            this.evidenceFolder = this.projectFolder.addResourceFolder("EVIDENCE");
            this.argFolder = this.projectFolder.addResourceFolder("ARGUMENTATION");
            this.procFolder = this.projectFolder.addResourceFolder("PROCESSES");
            try {
                transaction.commit();
            }
            catch (ConcurrentAccessException e) {
                e.printStackTrace();
            }
            catch (CommitException e) {
                e.printStackTrace();
            }
        } else {
            String path = projectModel.path();
            path = path.substring(0, path.lastIndexOf("/"));
            this.assuranceprojectFolder = transaction.getResourceFolder(path);
            String argFolderPath = this.assuranceprojectFolder.getPath().substring(0, this.assuranceprojectFolder.getPath().lastIndexOf("/"));
            argFolderPath = String.valueOf(argFolderPath) + "/" + "ARGUMENTATION";
            this.argFolder = transaction.getResourceFolder(argFolderPath);
        }
        this.selectedReqs = reqs;
        this.qrefDirectoryStandard = qrefStandard;
        this.baselineName = baselineName;
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("ENCODING", UTF_8);
        CDOResource targetResource = transaction.getOrCreateResource(String.valueOf(this.assuranceprojectFolder.getPath()) + "/" + baselineName + BASELINE);
        boolean sameBaselineName = false;
        try {
            if (targetResource.isExisting()) {
                IEditorReference[] edi;
                sameBaselineName = true;
                options = new HashMap();
                options.put("ENCODING", UTF_8);
                IEditorReference[] iEditorReferenceArray = edi = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getEditorReferences();
                int n = edi.length;
                int n2 = 0;
                while (n2 < n) {
                    IEditorReference editor = iEditorReferenceArray[n2];
                    IEditorInput input = null;
                    try {
                        input = editor.getEditorInput();
                    }
                    catch (PartInitException e) {
                        e.printStackTrace();
                        monitor.done();
                    }
                    if (input != null) {
                        String editorPath = "";
                        if ((input instanceof DawnEditorInput || input instanceof URIEditorInput) && ((editorPath = input instanceof DawnEditorInput ? ((DawnEditorInput)input).getURI().toString() : ((URIEditorInput)input).getURI().toString()).equals(this.assuranceprojectFolder.getURI() + "/" + baselineName + BASELINE) || editorPath.equals(this.assuranceprojectFolder.getURI() + "/" + baselineName + BASELINE_DIAGRAM) || editorPath.equals(this.assuranceprojectFolder.getURI() + "/" + baselineName + "_2.baseline_diagram") || editorPath.equals(this.assuranceprojectFolder.getURI() + "/" + baselineName + "_3.baseline_diagram") || editorPath.equals(this.assuranceprojectFolder.getURI() + "/" + baselineName + "_4.baseline_diagram"))) {
                            IEditorReference[] editorReferencesClose = new IEditorReference[]{editor};
                            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().closeEditors(editorReferencesClose, false);
                        }
                    }
                    ++n2;
                }
                CDOResource diagramResourceDelete = transaction.getOrCreateResource(String.valueOf(this.assuranceprojectFolder.getPath()) + "/" + baselineName + BASELINE_DIAGRAM);
                diagramResourceDelete.delete(options);
                Iterator diagramResource2Delete = transaction.getOrCreateResource(String.valueOf(this.assuranceprojectFolder.getPath()) + "/" + baselineName + "_2.baseline_diagram");
                diagramResource2Delete.delete(options);
                CDOResource diagramResource3Delete = transaction.getOrCreateResource(String.valueOf(this.assuranceprojectFolder.getPath()) + "/" + baselineName + "_3.baseline_diagram");
                diagramResource3Delete.delete(options);
                CDOResource diagramResource4Delete = transaction.getOrCreateResource(String.valueOf(this.assuranceprojectFolder.getPath()) + "/" + baselineName + "_4.baseline_diagram");
                diagramResource4Delete.delete(options);
                targetResource.delete(options);
                if (this.generateArgumentation) {
                    IEditorReference[] iEditorReferenceArray2 = edi = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getEditorReferences();
                    int editorReferencesClose = edi.length;
                    int editorPath = 0;
                    while (editorPath < editorReferencesClose) {
                        IEditorReference editor = iEditorReferenceArray2[editorPath];
                        IEditorInput input = null;
                        try {
                            input = editor.getEditorInput();
                        }
                        catch (PartInitException e) {
                            e.printStackTrace();
                            monitor.done();
                        }
                        if (input != null) {
                            String pathArgFolder;
                            String editorPath2 = "";
                            if ((input instanceof DawnEditorInput || input instanceof URIEditorInput) && ((editorPath2 = input instanceof DawnEditorInput ? ((DawnEditorInput)input).getURI().toString() : ((URIEditorInput)input).getURI().toString()).equals(String.valueOf(pathArgFolder = this.assuranceprojectFolder.getURI().toString().replace("ASSURANCE_PROJECT", "ARGUMENTATION")) + "/" + baselineName + ARGUMENTATION_NsPrefix) || editorPath2.equals(String.valueOf(pathArgFolder) + "/" + baselineName + ".arg_diagram"))) {
                                IEditorReference[] editorReferencesClose2 = new IEditorReference[]{editor};
                                PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().closeEditors(editorReferencesClose2, false);
                            }
                        }
                        ++editorPath;
                    }
                    CDOResource argResourceDiagramDelete = transaction.getOrCreateResource(String.valueOf(this.argFolder.getPath()) + "/" + baselineName + ARGUMENTATION_NsPrefix + DIAGRAM);
                    argResourceDiagramDelete.delete(options);
                    Iterator argResourceDelete = transaction.getOrCreateResource(String.valueOf(this.argFolder.getPath()) + "/" + baselineName + ARGUMENTATION_NsPrefix);
                    EList argContents = argResourceDelete.getContents();
                    EObject argRootObject = (EObject)argContents.get(0);
                    CDOResource project = transaction.getOrCreateResource(projectModel.path());
                    EList contents = project.getContents();
                    EObject rootObject = (EObject)contents.get(0);
                    AssuranceProject asurproj = (AssuranceProject)rootObject;
                    AssetsPackage assPackageconfig = (AssetsPackage)asurproj.getAssetsPackage().get(0);
                    if (sameBaselineName) {
                        assPackageconfig.getArgumentationModel().remove((Object)argRootObject);
                    }
                    argResourceDelete.delete(options);
                }
                transaction.commit();
                targetResource = transaction.getOrCreateResource(String.valueOf(this.assuranceprojectFolder.getPath()) + "/" + baselineName + BASELINE);
            }
            CDOResource sourceResource2 = transaction.getResource(qrefStandard);
            for (EObject aEObject : sourceResource2.getContents()) {
                targetResource.getContents().add((Object)AssurProjInitializationHelper.getCorrespondingEObject(aEObject));
            }
            Object[] copia = ArrayUtils.clone((Object[])reqs);
            TreeIterator iterator = sourceResource2.getAllContents();
            while (iterator.hasNext()) {
                EObject aEObject = (EObject)iterator.next();
                EObject bEObject = AssurProjInitializationHelper.getCorrespondingEObject(aEObject);
                if (!aEObject.eClass().getName().startsWith("Ref") && !aEObject.eClass().getName().equals("MapJustification") && !aEObject.eClass().getName().equals(MAPGROUP_CLASS)) continue;
                AssurProjInitializationHelper.copyAEObjectToBEObject(aEObject, bEObject, copia);
            }
            try {
                targetResource.save(options);
            }
            catch (IOException e) {
                e.printStackTrace();
                transaction.rollback();
            }
            if (projectModel == null) {
                String refFrameworkName = ((RefFramework)sourceResource2.getContents().get(0)).getName();
                if (refFrameworkName != null) {
                    refFrameworkName = this.projectName;
                }
                CDOResource complianceResource = this.assuranceprojectFolder.addResource(String.valueOf(this.projectName) + MAPPING);
                EObject rootObjectCompliance = this.createInitialCompliance(refFrameworkName);
                complianceResource.getContents().add((Object)rootObjectCompliance);
                complianceResource.save(options);
                assuranceprojectResource = this.assuranceprojectFolder.addResource(String.valueOf(this.projectName) + ASSURANCEPROJECT);
                EObject rootObjectAssurProject = this.createInitialAssurProject((BaseFramework)targetResource.getContents().get(0), (MapGroup)((MapModel)rootObjectCompliance).getMapGroupModel().get(0));
                assuranceprojectResource.getContents().add((Object)rootObjectAssurProject);
                assuranceprojectResource.save(options);
            } else {
                assuranceprojectResource = transaction.getResource(projectModel.path());
                EList contents = assuranceprojectResource.getContents();
                EObject rootObject = (EObject)contents.get(0);
                if (rootObject != null && rootObject instanceof AssuranceProject) {
                    AssuranceProject asurproj = (AssuranceProject)rootObject;
                    if (sameBaselineName) {
                        for (BaselineConfig bc : asurproj.getBaselineConfig()) {
                            if (!bc.getName().equals(String.valueOf(baselineName) + BASELINECONFIG_CLASS)) continue;
                            asurproj.getBaselineConfig().remove((Object)bc);
                            break;
                        }
                    }
                    BaselineConfig baseconfig = this.dprojectFactory.createBaselineConfig();
                    baseconfig.setId("BC" + (asurproj.getBaselineConfig().size() + 1));
                    baseconfig.setName(String.valueOf(baselineName) + BASELINECONFIG_CLASS);
                    baseconfig.setIsActive(false);
                    baseconfig.getRefFramework().add((Object)((BaseFramework)targetResource.getContents().get(0)));
                    asurproj.getBaselineConfig().add((Object)baseconfig);
                }
                options = new HashMap();
                options.put("ENCODING", UTF_8);
                assuranceprojectResource.save(options);
            }
        }
        catch (Exception exception) {
            AssuranceprojectEditorPlugin.INSTANCE.log((Object)exception);
            transaction.rollback();
            monitor.done();
        }
        try {
            CDOTransaction exception = transaction;
            synchronized (exception) {
                sourceResource = transaction.getResource(qrefStandard);
                List<CDOResource> listDiagrams = this.getDiagramsFromModel(transaction, sourceResource);
                boolean cont = true;
                int contDiag = 0;
                for (CDOResource sourceDiagramResource : listDiagrams) {
                    ++contDiag;
                    EList listRootObjectsSource = ((Diagram)sourceDiagramResource.getContents().get(0)).getPersistedChildren();
                    ArrayList<EObject> listRootObjects = new ArrayList<EObject>();
                    for (EObject element : listRootObjectsSource) {
                        EObject objsource = ((NodeImpl)element).getElement();
                        CDOID cdoID = CDOUtil.getCDOObject((EObject)objsource).cdoID();
                        Long cdoIdLong = new Long(cdoID.toURIFragment());
                        EObject obj = AssurProjInitializationHelper.getCorrespondingEObject(objsource);
                        listRootObjects.add(obj);
                    }
                    String targetPath = String.valueOf(this.assuranceprojectFolder.getPath()) + "/";
                    String targetDiagram = String.valueOf(targetPath) + baselineName + BASELINE_DIAGRAM;
                    CDOResource targetDiagramResource = transaction.getOrCreateResource(targetDiagram);
                    if (contDiag > 1) {
                        targetDiagram = String.valueOf(targetPath) + baselineName + "_" + contDiag + BASELINE_DIAGRAM;
                        targetDiagramResource = transaction.getOrCreateResource(targetDiagram);
                    }
                    DawnBaselineDiagramUtil myDiagram = new DawnBaselineDiagramUtil(sourceDiagramResource, listRootObjects, targetResource.getURI(), targetDiagramResource.getURI(), this.argFolder, transaction);
                    myDiagram.generateDiagram(monitor);
                }
                transaction.commit();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            transaction.rollback();
            monitor.done();
        }
        if (this.generateArgumentation) {
            URI targetModelURI = null;
            try {
                sourceResource = transaction;
                synchronized (sourceResource) {
                    URI sourceModelURI = targetResource.getURI();
                    CDOResource targetModelResource = transaction.getOrCreateResource(String.valueOf(this.argFolder.getPath()) + "/" + baselineName + ARGUMENTATION_NsPrefix);
                    targetModelURI = targetModelResource.getURI();
                    RedirectSystemErr.out("prueba1");
                    CDOTransformHandler transfo = new CDOTransformHandler(this.assuranceprojectFolder, targetResource, targetModelResource, transaction);
                    RedirectSystemErr.out("prueba2");
                    transfo.execute();
                    RedirectSystemErr.out("prueba3");
                    transaction.commit();
                    RedirectSystemErr.out("prueba4");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                transaction.rollback();
                monitor.done();
            }
            try {
                CDOTransaction e = transaction;
                synchronized (e) {
                    CDOResource targetModelDiagramResource = transaction.getOrCreateResource(String.valueOf(this.argFolder.getPath()) + "/" + baselineName + ARGUMENTATION_NsPrefix + DIAGRAM);
                    RedirectSystemErr.out("prueba5");
                    DawnArgDiagramUtil myDiagram = new DawnArgDiagramUtil(targetModelURI, targetModelDiagramResource.getURI(), this.argFolder, transaction);
                    myDiagram.generateDiagram(monitor);
                    RedirectSystemErr.out("prueba6");
                    Set conf = transaction.getConflicts();
                    for (CDOObject nextObject : conf) {
                        System.out.println("createCreateCommands: confict " + nextObject.toString());
                    }
                    RedirectSystemErr.out("prueba7");
                    transaction.commit();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                transaction.rollback();
                monitor.done();
            }
            RedirectSystemErr.out("prueba8");
            try {
                EList contents = assuranceprojectResource.getContents();
                EObject rootObject = (EObject)contents.get(0);
                AssuranceProject asurproj = (AssuranceProject)rootObject;
                AssetsPackage assPackageconfig = (AssetsPackage)asurproj.getAssetsPackage().get(0);
                RedirectSystemErr.out("prueba9");
                CDOResource argResource = transaction.getResource(targetModelURI.path());
                EList argContents = argResource.getContents();
                EObject argRootObject = (EObject)argContents.get(0);
                Case argCase = (Case)argRootObject;
                if (sameBaselineName) {
                    assPackageconfig.getArgumentationModel().add((Object)argCase);
                } else {
                    assPackageconfig.getArgumentationModel().add((Object)argCase);
                }
                RedirectSystemErr.out("prueba10");
                options = new HashMap();
                options.put("ENCODING", UTF_8);
                assuranceprojectResource.save(options);
                transaction.close();
                RedirectSystemErr.out("prueba11");
            }
            catch (Exception e) {
                e.printStackTrace();
                monitor.done();
            }
        }
        monitor.done();
    }

    protected EObject createInitialAssurProject(BaseFramework baseline, MapGroup mapp) {
        EClass eClass = (EClass)this.dprojectPackage.getEClassifier(ASSURANCEPROJECT_CLASS);
        EObject rootObject = this.dprojectFactory.create(eClass);
        ((AssuranceProject)rootObject).setName(this.projectName);
        BaselineConfig baseconfig = this.dprojectFactory.createBaselineConfig();
        baseconfig.setId("BC01");
        baseconfig.setName(String.valueOf(this.baselineName) + BASELINECONFIG_CLASS);
        baseconfig.setIsActive(true);
        baseconfig.getRefFramework().add((Object)baseline);
        baseconfig.setComplianceMapGroup(mapp);
        AssetsPackage assetsPackage = this.dprojectFactory.createAssetsPackage();
        assetsPackage.setId("AP01");
        assetsPackage.setIsActive(true);
        assetsPackage.setName(String.valueOf(this.projectName) + ASSETSPACKAGE_CLASS);
        PermissionConfig permissionConfig = this.dprojectFactory.createPermissionConfig();
        permissionConfig.setId("PC01");
        permissionConfig.setName(String.valueOf(this.projectName) + PERMISSIONCONFIG_CLASS);
        permissionConfig.setIsActive(true);
        ((AssuranceProject)rootObject).getBaselineConfig().add((Object)baseconfig);
        ((AssuranceProject)rootObject).getAssetsPackage().add((Object)assetsPackage);
        ((AssuranceProject)rootObject).getPermissionConf().add((Object)permissionConfig);
        return rootObject;
    }

    protected EObject createInitialCompliance(String name) {
        EClass eGroup = (EClass)this.mappingPackage.getEClassifier(MAPGROUP_CLASS);
        EObject groupObject = this.mappingFactory.create(eGroup);
        ((MapGroup)groupObject).setId("MG1");
        ((MapGroup)groupObject).setName(String.valueOf(name) + GROUP);
        EClass eClass = (EClass)this.mappingPackage.getEClassifier(MAPMODEL_CLASS);
        EObject rootObject = this.mappingFactory.create(eClass);
        ((MapModel)rootObject).setId("MM1");
        ((MapModel)rootObject).setName(String.valueOf(name) + COMPLIANCE);
        ((MapModel)rootObject).getMapGroupModel().add((Object)((MapGroup)groupObject));
        return rootObject;
    }

    private static void copyAEObjectToBEObject(EObject aEObject, EObject bEObject, Object[] reqs) {
        EStructuralFeature bFeature;
        Object[] objectArray = reqs;
        int n = reqs.length;
        int n2 = 0;
        while (n2 < n) {
            EObject eObjectSel;
            Object unSel = objectArray[n2];
            if (unSel instanceof EObject && (eObjectSel = (EObject)unSel).toString().equals(aEObject.toString())) {
                EStructuralFeature bFeature2 = bEObject.eClass().getEStructuralFeature("isSelected");
                if (bFeature2 != null) {
                    bEObject.eSet(bFeature2, (Object)Boolean.TRUE);
                }
                reqs = ArrayUtils.removeElement((Object[])reqs, (Object)unSel);
                break;
            }
            ++n2;
        }
        for (EStructuralFeature aFeature : aEObject.eClass().getEAllStructuralFeatures()) {
            EObject copy;
            if (!aEObject.eIsSet(aFeature)) continue;
            EStructuralFeature bFeature3 = bEObject.eClass().getEStructuralFeature(aFeature.getName());
            if (aFeature.getName().equals("equivalence")) {
                bFeature3 = bEObject.eClass().getEStructuralFeature("equivalenceMap");
            }
            if (bFeature3 == null) continue;
            if (aFeature instanceof EAttribute) {
                bEObject.eSet(bFeature3, aEObject.eGet(aFeature));
                continue;
            }
            if (aEObject.eClass().getName().equals("RefEquivalenceMap") && aFeature.getName().equals("target")) {
                bEObject.eSet(bFeature3, aEObject.eGet(aFeature));
                continue;
            }
            if (aFeature.getName().equals("mapJustification")) {
                copy = AssurProjInitializationHelper.getCorrespondingEObject((EObject)aEObject.eGet(aFeature));
                bEObject.eSet(bFeature3, (Object)copy);
                continue;
            }
            if (aFeature.getName().equals("mapGroup")) {
                bEObject.eSet(bFeature3, aEObject.eGet(aFeature));
                continue;
            }
            if (aEObject.eGet(aFeature) instanceof EList) {
                EList aList = (EList)aEObject.eGet(aFeature);
                BasicEList bList = new BasicEList();
                int i = 0;
                while (i < aList.size()) {
                    bList.add((Object)AssurProjInitializationHelper.getCorrespondingEObject((EObject)aList.get(i)));
                    ++i;
                }
                bEObject.eSet(bFeature3, (Object)bList);
                continue;
            }
            copy = AssurProjInitializationHelper.getCorrespondingEObject((EObject)aEObject.eGet(aFeature));
            bEObject.eSet(bFeature3, (Object)copy);
        }
        if (aEObject instanceof RefFramework) {
            bFeature = bEObject.eClass().getEStructuralFeature("refFramework");
            bEObject.eSet(bFeature, (Object)aEObject);
        } else if (bEObject instanceof BaseAssurableElement) {
            bFeature = bEObject.eClass().getEStructuralFeature("refAssurableElement");
            bEObject.eSet(bFeature, (Object)aEObject);
        }
    }

    private static EObject getCorrespondingEObject(EObject aEObject) {
        EObject bEObject = map.get(aEObject);
        if (bEObject == null) {
            EClass aEClass = aEObject.eClass();
            if (aEClass.getName().startsWith("Ref")) {
                String bClassName = aEClass.getName().replaceFirst("Ref", "Base");
                EClass bEClass = (EClass)BaselinePackage.eINSTANCE.getEClassifier(bClassName);
                bEObject = EcoreUtil.create((EClass)bEClass);
                map.put(aEObject, bEObject);
            } else if (aEClass.getName().equals("MapJustification")) {
                bEObject = EcoreUtil.create((EClass)aEClass);
                map.put(aEObject, bEObject);
            } else if (aEClass.getName().equals(MAPGROUP_CLASS)) {
                bEObject = EcoreUtil.create((EClass)aEClass);
                map.put(aEObject, bEObject);
            } else {
                bEObject = aEObject;
                map.put(aEObject, aEObject);
            }
        }
        return bEObject;
    }
}

