/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.opencert.apm.assurproj.wizards.ui.wizards;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.cdo.dawn.preferences.PreferenceConstants;
import org.eclipse.emf.cdo.dawn.ui.views.DawnExplorer;
import org.eclipse.emf.cdo.dawn.util.connection.CDOConnectionUtil;
import org.eclipse.emf.cdo.eresource.CDOResourceFolder;
import org.eclipse.emf.cdo.session.CDOSession;
import org.eclipse.emf.cdo.transaction.CDOTransaction;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.opencert.apm.assurproj.wizards.ui.wizards.AssurProjInitializationHelper;
import org.eclipse.opencert.apm.assurproj.wizards.ui.wizards.AssurProjRefFrameworkSelectionWizardPage;
import org.eclipse.opencert.apm.assurproj.wizards.ui.wizards.ProjectName;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;

public class NewAssurProjWizard
extends Wizard
implements IExecutableExtension,
INewWizard {
    private static final String REFERENCE_FRAMEWORK_SELECTION = "Reference Framework Selection";
    private static final String CREATE_ASSURANCE_PROJECT = "Create Assurance Project";
    private static final Log logger = LogFactory.getLog(NewAssurProjWizard.class);
    private AssurProjRefFrameworkSelectionWizardPage refSelectionPage;
    private ProjectName project;
    protected String qrefDir;

    public NewAssurProjWizard() {
        this.setNeedsProgressMonitor(true);
    }

    public boolean performFinish() {
        CDOTransaction transaction = null;
        DawnExplorer repoView = null;
        IViewReference[] viewReferences = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getViewReferences();
        int i = 0;
        while (i < viewReferences.length) {
            if ("org.eclipse.emf.cdo.dawn.ui.views.DawnExplorer".equals(viewReferences[i].getId())) {
                repoView = (DawnExplorer)viewReferences[i].getView(false);
                break;
            }
            ++i;
        }
        if (repoView != null) {
            transaction = repoView.getView().getSession().openTransaction();
        } else {
            CDOConnectionUtil.instance.init(PreferenceConstants.getRepositoryName(), PreferenceConstants.getProtocol(), PreferenceConstants.getServerName());
            CDOSession sessionCDO = CDOConnectionUtil.instance.openSession();
            CDOView view = sessionCDO.openView();
            transaction = sessionCDO.openTransaction();
        }
        CDOResourceFolder assuranceProject = transaction.getOrCreateResourceFolder(this.project.getName());
        if (!assuranceProject.getNodes().isEmpty()) {
            MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)"Already exists another Assurance Project with the same name. Please, change Assurance Project Name");
            return false;
        }
        boolean confirmation = MessageDialog.openConfirm((Shell)this.getShell(), (String)"Assurance Project generation", (String)"This process could take a several minutes.\n\nDo you want to continue?");
        if (!confirmation) {
            return false;
        }
        transaction.close();
        ProgressMonitorDialog dialog = new ProgressMonitorDialog(this.getShell());
        dialog.open();
        IProgressMonitor monitor = dialog.getProgressMonitor();
        monitor.beginTask(CREATE_ASSURANCE_PROJECT, 20);
        monitor.worked(1);
        AssurProjInitializationHelper projectInitializer = this.createProjectInitializationHelper(this.project.getName(), this.project.generateArgumentation());
        monitor.worked(1);
        Object[] refRequirements = this.refSelectionPage.getSelectedRefReq();
        this.qrefDir = this.refSelectionPage.getQRef();
        try {
            projectInitializer.createCreateCommands(monitor, this.getContainer(), refRequirements, this.qrefDir, this.refSelectionPage.getBaselineName(), null);
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
        monitor.worked(1);
        return true;
    }

    public void addPages() {
        super.addPages();
        this.project = new ProjectName();
        this.addPage((IWizardPage)this.project);
        this.refSelectionPage = this.createAssurProjReferenceSelectionPage();
        this.addPage((IWizardPage)this.refSelectionPage);
    }

    protected AssurProjRefFrameworkSelectionWizardPage createAssurProjReferenceSelectionPage() {
        return new AssurProjRefFrameworkSelectionWizardPage(REFERENCE_FRAMEWORK_SELECTION);
    }

    protected AssurProjInitializationHelper createProjectInitializationHelper(String projectName, boolean generateArgumentation) {
        return new AssurProjInitializationHelper(projectName, generateArgumentation);
    }

    protected String getqrefDir() {
        return this.qrefDir;
    }

    public void init(IWorkbench arg0, IStructuredSelection arg1) {
    }

    public void setInitializationData(IConfigurationElement arg0, String arg1, Object arg2) throws CoreException {
    }
}

