/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.textedit.parameter.xtext.umlParameter;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum EffectKind implements Enumerator
{
    CREATE(0, "CREATE", "create"),
    READ(1, "READ", "read"),
    UPDATE(2, "UPDATE", "update"),
    DELETE(3, "DELETE", "delete");

    public static final int CREATE_VALUE = 0;
    public static final int READ_VALUE = 1;
    public static final int UPDATE_VALUE = 2;
    public static final int DELETE_VALUE = 3;
    private static final EffectKind[] VALUES_ARRAY;
    public static final List<EffectKind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new EffectKind[]{CREATE, READ, UPDATE, DELETE};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static EffectKind get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            EffectKind result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static EffectKind getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            EffectKind result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static EffectKind get(int value) {
        switch (value) {
            case 0: {
                return CREATE;
            }
            case 1: {
                return READ;
            }
            case 2: {
                return UPDATE;
            }
            case 3: {
                return DELETE;
            }
        }
        return null;
    }

    private EffectKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

