/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.opencert.sam.arg.arg.diagram.edit.policies;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.cdo.eresource.CDOResource;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.OpenEditPolicy;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.opencert.sam.arg.arg.ArgPackage;
import org.eclipse.opencert.sam.arg.arg.diagram.part.ArgDiagramEditorUtil;
import org.eclipse.opencert.sam.arg.arg.diagram.part.Messages;
import org.eclipse.opencert.sam.arg.arg.impl.AgreementImpl;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.part.FileEditorInput;

public class OpenFileAgreementEditPolicy
extends OpenEditPolicy {
    protected Command getOpenCommand(Request request) {
        EditPart targetEditPart = this.getTargetEditPart(request);
        if (!(targetEditPart.getModel() instanceof View)) {
            return null;
        }
        View cfr_ignored_0 = (View)targetEditPart.getModel();
        return new ICommandProxy((ICommand)new OpenFileAgreementCommand(targetEditPart));
    }

    private static class OpenFileAgreementCommand
    extends AbstractTransactionalCommand {
        private final EditPart targetEditPart;

        OpenFileAgreementCommand(EditPart targetEditPart) {
            super(TransactionUtil.getEditingDomain((Object)targetEditPart.getModel()), Messages.CommandName_OpenDiagram, null);
            this.targetEditPart = targetEditPart;
        }

        protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            try {
                AgreementImpl agreeImpl;
                IFile agreement = this.getAgreementToOpen();
                if (agreement == null) {
                    agreement = this.intializeNewAgreement();
                }
                if ((agreeImpl = (AgreementImpl)((View)this.targetEditPart.getModel()).getElement()) == null && (agreement.getName() == null || agreement.getName().compareTo("") == 0)) {
                    throw new ExecutionException("Can't open agreement '");
                }
                IEditorDescriptor desc = PlatformUI.getWorkbench().getEditorRegistry().getDefaultEditor(agreement.getName());
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                page.openEditor((IEditorInput)new FileEditorInput(agreement), desc.getId());
                return CommandResult.newOKCommandResult();
            }
            catch (Exception ex) {
                throw new ExecutionException("Can't open agreement", (Throwable)ex);
            }
        }

        protected IFile getAgreementToOpen() {
            AgreementImpl agreeImpl = (AgreementImpl)((View)this.targetEditPart.getModel()).getElement();
            if (agreeImpl == null || agreeImpl.getId() == null) {
                return null;
            }
            IFile locationFile = null;
            agreeImpl.getId();
            String location = agreeImpl.getLocation();
            if (location != null) {
                URI agreementURI = URI.createFileURI((String)location);
                ResourceSet resourceSet = this.getEditingDomain().getResourceSet();
                System.out.println("Loaded " + agreementURI);
                Resource agreementResource = resourceSet.getResource(agreementURI, true);
                System.out.println("IsLoaded?: " + agreementResource.isLoaded());
                Path path = new Path(location);
                locationFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)path);
            }
            if (location == null || location.isEmpty() || locationFile == null || !locationFile.exists()) {
                return null;
            }
            return locationFile;
        }

        protected IFile intializeNewAgreement() throws ExecutionException {
            String diagramFullFilename;
            String finalDiagramLocation = "";
            String folder = null;
            if (!(((View)this.targetEditPart.getModel()).eResource() instanceof CDOResource)) {
                diagramFullFilename = ((View)this.targetEditPart.getModel()).eResource().getURI().toPlatformString(false);
                String folder0 = this.getPath2(diagramFullFilename.substring(diagramFullFilename.lastIndexOf("/") + 1, diagramFullFilename.length()));
                System.out.println("folder0=" + folder0);
                String uri = ((View)this.targetEditPart.getModel()).eResource().getURI().toPlatformString(false);
                int beginIndex = uri.toString().lastIndexOf("/");
                folder = uri.toString().substring(0, beginIndex + 1);
            } else {
                diagramFullFilename = Platform.getPreferencesService().getString("org.eclipse.opencert.sam.preferences", "agreementPathPreference", "Agreements Dir wrong", null);
                int beginIndex = diagramFullFilename.toString().lastIndexOf("\\");
                folder = diagramFullFilename.toString().substring(beginIndex, diagramFullFilename.length());
                folder = String.valueOf(folder) + "\\";
            }
            System.out.println("folder=" + folder);
            URI folderURI = URI.createPlatformResourceURI((String)folder, (boolean)false);
            ResourcesPlugin.getWorkspace().getRoot().getProject(folderURI.segment(1));
            AgreementImpl argImpl = (AgreementImpl)((View)this.targetEditPart.getModel()).getElement();
            if (argImpl == null || argImpl.getId() == null) {
                throw new ExecutionException("Can't create agreement file null.agree");
            }
            String name = argImpl.getId();
            String location = argImpl.getLocation();
            IFile locationFile = null;
            if (location != null) {
                Path path = new Path(location);
                IFile iresource = locationFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)path);
                finalDiagramLocation = iresource.getLocation().toOSString();
            }
            if (location == null || location.isEmpty() || locationFile == null || !locationFile.exists()) {
                String agreementName = String.valueOf(name) + ".agree";
                finalDiagramLocation = String.valueOf(folder) + agreementName;
                IFile ifile = null;
                Path path = new Path(finalDiagramLocation);
                ifile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)path);
                String content = "Agreement " + name + "\n";
                byte[] bytes = content.getBytes();
                ByteArrayInputStream source = new ByteArrayInputStream(bytes);
                try {
                    ifile.create((InputStream)source, 0, null);
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
                ResourceSetImpl rSet = new ResourceSetImpl();
                URI diagramfullFileNameURI = this.getFileURI(ifile, (ResourceSet)rSet);
                finalDiagramLocation = diagramfullFileNameURI.toString();
                System.out.println("finalDiagramLocation=" + finalDiagramLocation);
                locationFile = ifile;
            }
            String cfr_ignored_0 = (String)argImpl.eGet((EStructuralFeature)ArgPackage.Literals.ARGUMENTATION__LOCATION);
            String nombre = finalDiagramLocation.substring(finalDiagramLocation.lastIndexOf("/") + 1, finalDiagramLocation.length());
            String finalDiagramLocation2 = String.valueOf(folder) + nombre;
            argImpl.eSet((EStructuralFeature)ArgPackage.Literals.ARGUMENTATION__LOCATION, (Object)finalDiagramLocation2);
            EObject container = ((View)this.targetEditPart.getModel()).eContainer();
            while (container instanceof View) {
                ((View)container).persist();
                container = container.eContainer();
            }
            try {
                new WorkspaceModifyOperation(){

                    protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
                        try {
                            for (Resource nextResource : ((View)OpenFileAgreementCommand.this.targetEditPart.getModel()).eResource().getResourceSet().getResources()) {
                                if (!nextResource.isLoaded() || OpenFileAgreementCommand.this.getEditingDomain().isReadOnly(nextResource)) continue;
                                nextResource.save(ArgDiagramEditorUtil.getSaveOptions());
                            }
                        }
                        catch (IOException ex) {
                            throw new InvocationTargetException(ex, "Save operation failed");
                        }
                    }
                }.run(null);
            }
            catch (InvocationTargetException e) {
                throw new ExecutionException("Can't create agreement file: ", (Throwable)e);
            }
            catch (InterruptedException e) {
                throw new ExecutionException("Can't create agreement file: ", (Throwable)e);
            }
            return locationFile;
        }

        private List<IFile> getDiagramFiles(IContainer folder) {
            ArrayList<IFile> ret = new ArrayList<IFile>();
            try {
                IResource[] members;
                IResource[] iResourceArray = members = folder.members();
                int n = members.length;
                int n2 = 0;
                while (n2 < n) {
                    IFile file;
                    IResource resource = iResourceArray[n2];
                    if (resource instanceof IContainer) {
                        ret.addAll(this.getDiagramFiles((IContainer)resource));
                    } else if (resource instanceof IFile && (file = (IFile)resource).getName().endsWith(".arg_diagram")) {
                        ret.add(file);
                    }
                    ++n2;
                }
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            return ret;
        }

        private String getPath2(String fileName) {
            String path = "";
            IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
            int i = 0;
            while (i < projects.length) {
                IProject curr = projects[i];
                List<IFile> list = this.getDiagramFiles((IContainer)curr);
                for (IFile element : list) {
                    if (!element.getName().contains(fileName)) continue;
                    path = element.getFullPath().toString();
                    int lind = path.lastIndexOf(fileName);
                    String path2 = path.substring(0, lind);
                    return path2;
                }
                ++i;
            }
            return path;
        }

        private URI getFileURI(IFile file, ResourceSet resourceSet) {
            String pathName = file.getFullPath().toString();
            URI resourceURI = URI.createFileURI((String)pathName);
            resourceURI = resourceSet.getURIConverter().normalize(resourceURI);
            return resourceURI;
        }

        private IFile fileToIFile(File f) {
            String p = f.getPath();
            Path path = new Path(p);
            return ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)path);
        }
    }
}

