/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.wizards.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.jface.dialogs.IDialogSettings;

public class SettingsHelper {
    private static final String DIAGRAM_KIND_SEPARATOR = ",";
    private static final String TEMPLATE_SEPARATOR = ",";
    private static final String SETTINGS_KEY_REMEMBER_CURRENT_SELECTION = "RememberCurrentSelection";
    private static final String SETTINGS_KEY_DIAGRAM_KINDS = "DiagramKindsFor_";
    private static final String SETTINGS_KEY_DIAGRAM_TEMPLATES = "DiagramTemplatesFor_";
    private static final String DIAGRAM_CATEGORIES = "diagramCategory";
    private static final String SETTINGS_KEY_DIAGRAM_CATEGORY = "lastSelectedCategory";
    private final IDialogSettings mySettings;

    public SettingsHelper(IDialogSettings settings) {
        this.mySettings = settings;
    }

    public String[] getDefaultDiagramCategories() {
        return this.mySettings.getArray(DIAGRAM_CATEGORIES);
    }

    public void saveDefaultDiagramCategory(String[] categories) {
        this.mySettings.put(DIAGRAM_CATEGORIES, categories);
    }

    public List<String> getDefaultDiagramKinds(String category) {
        String csl = this.mySettings.get(this.getKeyForDiagramKind(category));
        if (csl == null || csl.equals("")) {
            return Collections.emptyList();
        }
        ArrayList<String> result = new ArrayList<String>();
        StringTokenizer tokenizer = new StringTokenizer(csl, ",");
        while (tokenizer.hasMoreTokens()) {
            result.add(tokenizer.nextToken().trim());
        }
        return result;
    }

    public void saveDefaultDiagramKinds(String category, List<String> kinds) {
        String value = "";
        for (String kind : kinds) {
            value = String.valueOf(value) + kind;
            value = String.valueOf(value) + ",";
        }
        this.mySettings.put(this.getKeyForDiagramKind(category), value);
    }

    public List<String> getDefaultTemplates(String category) {
        String csl = this.mySettings.get(this.getKeyForTemplate(category));
        if (csl == null || csl.equals("")) {
            return Collections.emptyList();
        }
        ArrayList<String> result = new ArrayList<String>();
        StringTokenizer tokenizer = new StringTokenizer(csl, ",");
        while (tokenizer.hasMoreTokens()) {
            result.add(tokenizer.nextToken().trim());
        }
        return result;
    }

    public void saveDefaultTemplates(String category, List<String> templates) {
        String value = "";
        for (String template : templates) {
            value = String.valueOf(value) + template;
            value = String.valueOf(value) + ",";
        }
        this.mySettings.put(this.getKeyForTemplate(category), value);
    }

    public void saveRememberCurrentSelection(boolean remember) {
        this.mySettings.put(SETTINGS_KEY_REMEMBER_CURRENT_SELECTION, remember);
    }

    public boolean rememberCurrentSelection(IDialogSettings settings) {
        return this.mySettings.getBoolean(SETTINGS_KEY_REMEMBER_CURRENT_SELECTION);
    }

    public void setCurrentSelection(String category) {
        this.mySettings.put(SETTINGS_KEY_DIAGRAM_CATEGORY, category);
    }

    public String getPreviousSelection() {
        return this.mySettings.get(SETTINGS_KEY_DIAGRAM_CATEGORY);
    }

    private String getKeyForDiagramKind(String category) {
        return SETTINGS_KEY_DIAGRAM_KINDS + category;
    }

    private String getKeyForTemplate(String category) {
        return SETTINGS_KEY_DIAGRAM_TEMPLATES + category;
    }
}

