/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.m2m.internal.qvt.oml.evaluator.QvtRuntimeException;
import org.eclipse.m2m.qvt.oml.ExecutionDiagnostic;
import org.eclipse.m2m.qvt.oml.ExecutionStackTraceElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ExecutionDiagnosticImpl
extends BasicDiagnostic
implements ExecutionDiagnostic {
    public static final ExecutionDiagnosticImpl OK_INSTANCE = new ExecutionDiagnosticImpl(0, 0, "OK", null);
    private List<ExecutionStackTraceElement> fStackTrace;

    public ExecutionDiagnosticImpl(int severity, int code, String message, Object[] data) {
        super(severity, "org.eclipse.m2m.qvt.oml.execution", code, message, data);
    }

    public ExecutionDiagnosticImpl(int severity, int code, String message) {
        super(severity, "org.eclipse.m2m.qvt.oml.execution", code, message, null);
    }

    public void setStackTrace(List<? extends ExecutionStackTraceElement> stackElements) {
        this.fStackTrace = new ArrayList<ExecutionStackTraceElement>(stackElements);
    }

    @Override
    public List<ExecutionStackTraceElement> getStackTrace() {
        return this.fStackTrace != null ? Collections.unmodifiableList(this.fStackTrace) : Collections.emptyList();
    }

    @Override
    public void printStackTrace(PrintWriter writer) {
        if (this.fStackTrace != null) {
            QvtRuntimeException.printQvtStackTrace(writer, this.fStackTrace);
        }
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("Diagnostic ");
        switch (this.severity) {
            case 0: {
                result.append("OK");
                break;
            }
            case 1: {
                result.append("INFO");
                break;
            }
            case 2: {
                result.append("WARNING");
                break;
            }
            case 4: {
                result.append("ERROR");
                break;
            }
            case 8: {
                result.append("CANCEL");
                break;
            }
            default: {
                result.append(Integer.toHexString(this.severity));
            }
        }
        result.append(" source=");
        result.append(this.source);
        result.append(" code=");
        result.append(this.code);
        result.append(": ");
        result.append(this.message);
        if (this.data != null && !this.data.isEmpty()) {
            result.append(" data=");
            result.append(this.data);
        }
        if (this.children != null && !this.children.isEmpty()) {
            result.append(' ');
            result.append(this.children);
        }
        return result.toString();
    }
}

