/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.figures;

import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.BorderLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gmf.runtime.draw2d.ui.figures.WrappingLabel;
import org.eclipse.papyrus.infra.gmfdiag.common.figure.node.PapyrusWrappingLabel;
import org.eclipse.papyrus.uml.diagram.common.figure.node.RectangularShadowBorder;
import org.eclipse.papyrus.uml.diagram.sequence.figures.StereotypeInteractionFigure;

public class CombinedFragmentFigure
extends StereotypeInteractionFigure {
    private WrappingLabel titleLabel;
    private RectangleFigure header;

    protected void createContents() {
        super.createContents();
        this.setShadow(false);
        this.interactionContentPane.setOutline(false);
        this.interactionContentPane.setOpaque(false);
        this.interactionContentPane.setBorder(null);
    }

    @Override
    protected RectangleFigure createHeader() {
        this.header = super.createHeader();
        this.titleLabel = new PapyrusWrappingLabel();
        this.titleLabel.setAlignment(4);
        this.titleLabel.setBorder((Border)new MarginBorder(3, 0, 0, 3));
        this.titleLabel.setTextWrap(false);
        this.header.add((IFigure)this.titleLabel, (Object)BorderLayout.RIGHT);
        return this.header;
    }

    public WrappingLabel getTitleLabel() {
        return this.titleLabel;
    }

    public IFigure getHeaderContainer() {
        return this.header;
    }

    public void setShadow(boolean shadow) {
        int BORDER_WIDTH = 3;
        if (!shadow) {
            super.setShadow(shadow);
        } else {
            RectangularShadowBorder b = new RectangularShadowBorder(3, this.getForegroundColor()){

                public Insets getInsets(IFigure figure) {
                    return new Insets(1, 1, 1, 1);
                }
            };
            this.setBorder((Border)b);
        }
        Rectangle figureRect = new Rectangle(this.getBounds()).expand(new Insets(0, 0, 3, 3));
        IFigure parent = this.getParent();
        while (parent != null) {
            if (parent.getBounds().contains(figureRect)) {
                parent.revalidate();
                parent.repaint();
                break;
            }
            parent = parent.getParent();
        }
    }
}

