/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.figures;

import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.BorderLayout;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.StackLayout;
import org.eclipse.draw2d.ToolbarLayout;
import org.eclipse.draw2d.TreeSearch;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gmf.runtime.draw2d.ui.figures.WrappingLabel;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.IMapMode;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.MapModeUtil;
import org.eclipse.papyrus.uml.diagram.common.figure.node.NodeNamedElementFigure;
import org.eclipse.papyrus.uml.diagram.common.figure.node.RectangularShadowBorder;
import org.eclipse.papyrus.uml.diagram.sequence.figures.LifelineDotLineCustomFigure;
import org.eclipse.swt.graphics.Color;

public class LifelineFigure
extends NodeNamedElementFigure {
    protected RectangleFigure fFigureLifelineNameContainerFigure;
    protected RectangleFigure fFigureExecutionsContainerFigure;
    protected LifelineDotLineCustomFigure fFigureLifelineDotLineFigure;

    public int getNameContainerPreferredHeight(int wHint) {
        return this.fFigureLifelineNameContainerFigure.getPreferredSize((int)wHint, (int)-1).height;
    }

    protected IFigure getDefaultLabelsContainer() {
        return this.getFigureLifelineNameContainerFigure();
    }

    protected void createCompositeFigureStructure() {
        BorderLayout layoutThis = new BorderLayout();
        this.setLayoutManager((LayoutManager)layoutThis);
        this.setOpaque(false);
        this.setPreferredSize(new Dimension(this.getMapMode().DPtoLP(100), this.getMapMode().DPtoLP(200)));
        this.createContents();
    }

    protected void paintBackground(Graphics graphics, Rectangle rectangle) {
        super.paintBackground(graphics, this.getFigureLifelineNameContainerFigure().getBounds());
    }

    protected IFigure getBorderedFigure() {
        return this.getFigureLifelineNameContainerFigure();
    }

    protected Border getDefaultBorder(Color borderColor) {
        int margin = this.getMapMode().DPtoLP(7);
        MarginBorder defaultBorder = new MarginBorder(margin, margin, margin, margin);
        return defaultBorder;
    }

    protected LayoutManager getPropertiesCompartmentLayout() {
        ToolbarLayout layout = new ToolbarLayout(false);
        layout.setStretchMinorAxis(true);
        return layout;
    }

    protected void createNameLabel() {
        super.createNameLabel();
    }

    private void createContents() {
        this.fFigureLifelineNameContainerFigure = new RectangleFigure(){

            protected void fillShape(Graphics graphics) {
                graphics.pushState();
                LifelineFigure.this.applyTransparency(graphics);
                graphics.fillRectangle(this.getBounds());
                graphics.popState();
            }
        };
        this.fFigureLifelineNameContainerFigure.setFill(false);
        this.fFigureLifelineNameContainerFigure.setBorder((Border)new MarginBorder(this.getMapMode().DPtoLP(7), this.getMapMode().DPtoLP(7), this.getMapMode().DPtoLP(7), this.getMapMode().DPtoLP(7)));
        this.fFigureLifelineNameContainerFigure.setPreferredSize(new Dimension(this.getMapMode().DPtoLP(100), this.getMapMode().DPtoLP(30)));
        this.add((IFigure)this.fFigureLifelineNameContainerFigure, BorderLayout.TOP);
        ToolbarLayout layout = new ToolbarLayout(false);
        layout.setMinorAlignment(0);
        this.fFigureLifelineNameContainerFigure.setLayoutManager((LayoutManager)layout);
        this.fFigureExecutionsContainerFigure = new RectangleFigure();
        this.fFigureExecutionsContainerFigure.setFill(false);
        this.fFigureExecutionsContainerFigure.setOutline(false);
        this.fFigureExecutionsContainerFigure.setLineWidth(1);
        this.add((IFigure)this.fFigureExecutionsContainerFigure, BorderLayout.CENTER);
        this.fFigureExecutionsContainerFigure.setLayoutManager((LayoutManager)new StackLayout());
        this.fFigureLifelineDotLineFigure = new LifelineDotLineCustomFigure();
        this.fFigureExecutionsContainerFigure.add((IFigure)this.fFigureLifelineDotLineFigure);
    }

    protected IMapMode getMapMode() {
        return MapModeUtil.getMapMode();
    }

    public WrappingLabel getFigureLifelineLabelFigure() {
        return this.getNameLabel();
    }

    public RectangleFigure getFigureLifelineNameContainerFigure() {
        return this.fFigureLifelineNameContainerFigure;
    }

    public RectangleFigure getFigureExecutionsContainerFigure() {
        return this.fFigureExecutionsContainerFigure;
    }

    public LifelineDotLineCustomFigure getFigureLifelineDotLineFigure() {
        return this.fFigureLifelineDotLineFigure;
    }

    public void setLineWidth(int w) {
        if (w < 0) {
            return;
        }
        super.setLineWidth(w);
        this.fFigureLifelineNameContainerFigure.setLineWidth(w);
        this.fFigureLifelineDotLineFigure.setLineWidth(w);
    }

    public void setShadow(boolean shadow) {
        if (!shadow) {
            this.fFigureLifelineNameContainerFigure.setBorder((Border)new MarginBorder(this.getMapMode().DPtoLP(7), this.getMapMode().DPtoLP(7), this.getMapMode().DPtoLP(7), this.getMapMode().DPtoLP(7)));
        } else {
            RectangularShadowBorder b = new RectangularShadowBorder(3, this.getForegroundColor()){

                public Insets getInsets(IFigure figure) {
                    Insets insetsNew = new Insets(LifelineFigure.this.getMapMode().DPtoLP(7), LifelineFigure.this.getMapMode().DPtoLP(7), LifelineFigure.this.getMapMode().DPtoLP(7), LifelineFigure.this.getMapMode().DPtoLP(7));
                    insetsNew.bottom = MapModeUtil.getMapMode((IFigure)figure).DPtoLP(insetsNew.bottom + 3);
                    insetsNew.right = MapModeUtil.getMapMode((IFigure)figure).DPtoLP(insetsNew.right + 3);
                    return insetsNew;
                }
            };
            this.fFigureLifelineNameContainerFigure.setBorder((Border)b);
        }
    }

    public IFigure findMouseEventTargetAt(int x, int y) {
        IFigure f = this.findMouseEventTargetInDescendantsAt(x, y);
        if (f != null) {
            return f;
        }
        if (!this.containsPoint(x, y)) {
            return null;
        }
        if (this.isMouseEventTarget()) {
            return this;
        }
        return null;
    }

    public IFigure findFigureAt(int x, int y, TreeSearch search) {
        if (search.prune((IFigure)this)) {
            return null;
        }
        IFigure child = this.findDescendantAtExcluding(x, y, search);
        if (child != null) {
            return child;
        }
        if (!this.containsPoint(x, y)) {
            return null;
        }
        if (search.accept((IFigure)this)) {
            return this;
        }
        return null;
    }
}

