/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.util;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ShapeNodeEditPart;
import org.eclipse.gmf.runtime.notation.Bounds;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.Shape;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.commands.wrappers.GMFtoEMFCommandWrapper;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.CustomLifelineEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.LifelineEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.util.CommandHelper;
import org.eclipse.uml2.uml.Interaction;
import org.eclipse.uml2.uml.InteractionFragment;
import org.eclipse.uml2.uml.Lifeline;
import org.eclipse.uml2.uml.UMLPackage;

public class LifelineCoveredByUpdater {
    protected GraphicalEditPart context;
    protected Map<LifelineEditPart, Rectangle> lifelines = new HashMap<LifelineEditPart, Rectangle>();
    protected HashMap<GraphicalEditPart, Rectangle> interactionFragments = new HashMap();
    protected TransactionalEditingDomain editingDomain;

    protected void init() {
        EditPart editPart;
        this.editingDomain = this.context.getEditingDomain();
        GraphicalEditPart parent = this.context;
        while ((editPart = parent.getParent()) instanceof GraphicalEditPart) {
            parent = (GraphicalEditPart)editPart;
        }
        this.childrenCollect(parent);
    }

    private void childrenCollect(GraphicalEditPart editPart) {
        EObject modelObject;
        if (editPart instanceof LifelineEditPart) {
            IFigure figure = editPart.getFigure();
            Rectangle childBounds = figure.getBounds().getCopy();
            figure.translateToAbsolute((Translatable)childBounds);
            Rectangle centralLineBounds = new Rectangle(childBounds.x() + childBounds.width() / 2, childBounds.y(), 1, childBounds.height());
            this.lifelines.put((LifelineEditPart)editPart, centralLineBounds);
        }
        if (editPart instanceof GraphicalEditPart && (modelObject = ViewUtil.resolveSemanticElement((View)((View)editPart.getModel()))) instanceof InteractionFragment && !(modelObject instanceof Interaction)) {
            IFigure figure = editPart.getFigure();
            Rectangle childBounds = figure.getBounds().getCopy();
            figure.translateToAbsolute((Translatable)childBounds);
            this.interactionFragments.put(editPart, childBounds);
        }
        for (Object child : editPart.getChildren()) {
            if (!(child instanceof GraphicalEditPart)) continue;
            this.childrenCollect((GraphicalEditPart)child);
        }
    }

    public void update(GraphicalEditPart context) {
        this.context = context;
        this.init();
        for (Map.Entry<LifelineEditPart, Rectangle> entry : this.lifelines.entrySet()) {
            LifelineEditPart editPart = entry.getKey();
            Rectangle childBounds = entry.getValue();
            this.updateLifeline(editPart, childBounds);
        }
    }

    public void updateLifeline(LifelineEditPart lifelineEditpart, Rectangle rect) {
        Lifeline lifeline = (Lifeline)lifelineEditpart.resolveSemanticElement();
        if (lifeline == null) {
            return;
        }
        EList coveredByLifelines = lifeline.getCoveredBys();
        LinkedHashSet<InteractionFragment> coveredByLifelinesToAdd = new LinkedHashSet<InteractionFragment>();
        LinkedHashSet<InteractionFragment> coveredByLifelinesToRemove = new LinkedHashSet<InteractionFragment>();
        int bottom = 0;
        for (Map.Entry<GraphicalEditPart, Rectangle> entry : this.interactionFragments.entrySet()) {
            GraphicalEditPart editPart = entry.getKey();
            Rectangle childBounds = entry.getValue();
            InteractionFragment interactionFragment = (InteractionFragment)editPart.resolveSemanticElement();
            if (rect.intersects(childBounds)) {
                coveredByLifelinesToAdd.add(interactionFragment);
                bottom = Math.max(childBounds.bottom(), bottom);
                continue;
            }
            if (!coveredByLifelines.contains((Object)interactionFragment)) continue;
            coveredByLifelinesToRemove.add(interactionFragment);
        }
        coveredByLifelinesToRemove.removeAll(coveredByLifelinesToAdd);
        coveredByLifelinesToAdd.removeAll((Collection<?>)coveredByLifelines);
        if (!coveredByLifelinesToAdd.isEmpty()) {
            CommandHelper.executeCommandWithoutHistory(this.editingDomain, AddCommand.create((EditingDomain)this.editingDomain, (Object)lifeline, (Object)UMLPackage.eINSTANCE.getLifeline_CoveredBy(), coveredByLifelinesToAdd), true);
            int newHeight = bottom - rect.y;
            if (newHeight > rect.height) {
                Bounds bounds = (Bounds)((Shape)lifelineEditpart.getModel()).getLayoutConstraint();
                int height = bounds.getHeight();
                if (height == -1) {
                    height = lifelineEditpart.getPrimaryShape().getBounds().height;
                }
                int heightDelta = newHeight - height;
                CommandHelper.executeCommandWithoutHistory(this.editingDomain, SetCommand.create((EditingDomain)this.editingDomain, (Object)bounds, (Object)NotationPackage.Literals.SIZE__HEIGHT, (Object)newHeight), true);
                CustomLifelineEditPart.PreserveAnchorsPositionCommandEx preserveAnchorsCommand = new CustomLifelineEditPart.PreserveAnchorsPositionCommandEx((ShapeNodeEditPart)lifelineEditpart, new Dimension(0, heightDelta), 0, (IFigure)lifelineEditpart.getPrimaryShape().getFigureLifelineDotLineFigure(), 4);
                if (preserveAnchorsCommand.canExecute()) {
                    CommandHelper.executeCommandWithoutHistory(this.editingDomain, (Command)new GMFtoEMFCommandWrapper((ICommand)preserveAnchorsCommand), true);
                }
            }
        }
        if (!coveredByLifelinesToRemove.isEmpty()) {
            CommandHelper.executeCommandWithoutHistory(this.editingDomain, RemoveCommand.create((EditingDomain)this.editingDomain, (Object)lifeline, (Object)UMLPackage.eINSTANCE.getLifeline_CoveredBy(), coveredByLifelinesToRemove), true);
        }
    }
}

