/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.core.pluginexplorer;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.papyrus.infra.core.pluginexplorer.Plugin;
import org.eclipse.papyrus.infra.core.pluginexplorer.PluginEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EmbeddedFile
implements PluginEntry {
    private Plugin plugin;
    private String relativePath;
    private String name;
    private List<PluginEntry> children;

    public String getEntry() {
        return this.relativePath;
    }

    public EmbeddedFile(Plugin plugin, String entryName) {
        this.plugin = plugin;
        this.relativePath = entryName;
        if (entryName.endsWith("/")) {
            this.relativePath = entryName.substring(0, entryName.length() - 1);
        }
        this.name = this.relativePath;
        this.children = new ArrayList<PluginEntry>();
    }

    public EmbeddedFile(Plugin plugin, String entryName, String parentEntry) {
        this.plugin = plugin;
        this.relativePath = entryName;
        if (entryName.endsWith("/")) {
            this.relativePath = entryName.substring(0, entryName.length() - 1);
        }
        this.name = this.relativePath.substring(parentEntry.length() + 1);
        this.children = new ArrayList<PluginEntry>();
    }

    @Override
    public Plugin getPlugin() {
        return this.plugin;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getLogicalPath() {
        return "platform:/plugin/" + this.plugin.getName() + "/" + this.relativePath;
    }

    @Override
    public String getPhysicalPath() {
        return null;
    }

    @Override
    public boolean hasChildren() {
        return !this.children.isEmpty();
    }

    @Override
    public List<PluginEntry> children() {
        return this.children;
    }

    @Override
    public PluginEntry getChild(String name) {
        for (PluginEntry entry : this.children) {
            if (!entry.getName().equals(name)) continue;
            return entry;
        }
        return null;
    }

    @Override
    public InputStream getInputStream() {
        return this.plugin.getStreamInJar(this.relativePath);
    }
}

