/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.parser;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.core.command.UnexecutableCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.services.edit.service.ElementEditServiceUtils;
import org.eclipse.papyrus.uml.diagram.common.Activator;
import org.eclipse.papyrus.uml.diagram.common.parser.NamedElementLabelParser;
import org.eclipse.papyrus.uml.tools.utils.ValueSpecificationUtil;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.ValueSpecification;

public class ConstraintLabelParser
extends NamedElementLabelParser {
    protected static final String NAME_FORMAT = "%s";
    protected static final String SPECIFICATION_FORMAT = "%s{%s}";

    @Override
    public String getEditString(IAdaptable element, int flags) {
        Collection<String> maskValues = this.getMaskValues(element);
        if (maskValues.isEmpty()) {
            return "<empty label>";
        }
        String editString = "";
        EObject eObject = EMFHelper.getEObject((Object)element);
        if (eObject != null && eObject instanceof Constraint) {
            Constraint semElement = (Constraint)eObject;
            if (maskValues.contains("name")) {
                if (semElement.isSetName()) {
                    editString = semElement.getName();
                }
            } else if (maskValues.contains("specification") && semElement.getSpecification() != null && (editString = ValueSpecificationUtil.getSpecificationValue((ValueSpecification)semElement.getSpecification())) == null) {
                editString = "";
            }
        }
        return editString;
    }

    @Override
    public String getPrintString(IAdaptable element, int flags) {
        Collection<String> maskValues = this.getMaskValues(element);
        if (maskValues.isEmpty()) {
            return "<empty label>";
        }
        String result = "";
        EObject eObject = EMFHelper.getEObject((Object)element);
        if (eObject != null && eObject instanceof Constraint) {
            Constraint semElement = (Constraint)eObject;
            if (maskValues.contains("name") && semElement.isSetName()) {
                String name = semElement.getName();
                result = String.format(NAME_FORMAT, name);
            }
            if (maskValues.contains("specification")) {
                String spec = "<Undefined>";
                if (semElement.getSpecification() != null && ((spec = ValueSpecificationUtil.getSpecificationValue((ValueSpecification)semElement.getSpecification())) == null || "".equals(spec))) {
                    spec = "<Undefined>";
                }
                result = String.format(SPECIFICATION_FORMAT, result, spec);
            }
        }
        return result;
    }

    @Override
    public ICommand getParseCommand(IAdaptable element, String newString, int flags) {
        Collection<String> maskValues = this.getMaskValues(element);
        UnexecutableCommand command = UnexecutableCommand.INSTANCE;
        SetRequest updateRequest = null;
        Constraint constraint = (Constraint)EMFHelper.getEObject((Object)element);
        if (constraint == null) {
            return UnexecutableCommand.INSTANCE;
        }
        if (maskValues.contains("name")) {
            updateRequest = new SetRequest((EObject)constraint, (EStructuralFeature)UMLPackage.eINSTANCE.getNamedElement_Name(), (Object)newString);
            updateRequest.setLabel("Update Constraint Label");
        } else if (maskValues.contains("specification")) {
            ValueSpecification spec = constraint.getSpecification();
            if (spec == null) {
                return UnexecutableCommand.INSTANCE;
            }
            ValueSpecification specCopy = (ValueSpecification)EcoreUtil.copy((EObject)spec);
            ValueSpecificationUtil.restoreSpecificationValue((ValueSpecification)specCopy, (String)newString);
            updateRequest = new SetRequest((EObject)constraint, (EStructuralFeature)UMLPackage.eINSTANCE.getConstraint_Specification(), (Object)specCopy);
            updateRequest.setLabel("Update Constraint Label");
        }
        try {
            if (updateRequest != null) {
                command = ElementEditServiceUtils.getEditServiceProvider().getEditService((Object)constraint).getEditCommand((IEditCommandRequest)updateRequest);
            }
        }
        catch (ServiceException e) {
            Activator.log.error((Throwable)e);
        }
        return command;
    }

    @Override
    public boolean isAffectingEvent(Object event, int flags) {
        Object feature;
        if (event instanceof Notification && (feature = ((Notification)event).getFeature()) instanceof EStructuralFeature) {
            return UMLPackage.eINSTANCE.getValueSpecification__BooleanValue().equals(feature) || UMLPackage.eINSTANCE.getValueSpecification__IntegerValue().equals(feature) || UMLPackage.eINSTANCE.getValueSpecification__StringValue().equals(feature) || UMLPackage.eINSTANCE.getValueSpecification__UnlimitedValue().equals(feature) || UMLPackage.eINSTANCE.getOpaqueExpression_Body().equals(feature) || UMLPackage.eINSTANCE.getOpaqueExpression_Language().equals(feature) || super.isAffectingEvent(event, flags);
        }
        return false;
    }

    @Override
    public List<EObject> getSemanticElementsBeingParsed(EObject element) {
        ArrayList<EObject> semanticElementsBeingParsed = new ArrayList<EObject>();
        if (element != null && element instanceof Constraint) {
            Constraint semElement = (Constraint)element;
            semanticElementsBeingParsed.add((EObject)semElement);
            if (semElement.getSpecification() != null) {
                semanticElementsBeingParsed.add((EObject)semElement.getSpecification());
            }
        }
        return semanticElementsBeingParsed;
    }

    @Override
    public Map<String, String> getMasks() {
        HashMap<String, String> masks = new HashMap<String, String>(2);
        masks.put("name", "Name");
        masks.put("specification", "Specification");
        return masks;
    }

    @Override
    public Collection<String> getDefaultValue(IAdaptable element) {
        return Arrays.asList("specification");
    }
}

