/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.opencert.vocabulary.diagram.part;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.opencert.vocabulary.diagram.part.Messages;
import org.eclipse.opencert.vocabulary.diagram.part.VocabularyCreationWizardPage;
import org.eclipse.opencert.vocabulary.diagram.part.VocabularyDiagramEditorPlugin;
import org.eclipse.opencert.vocabulary.diagram.part.VocabularyDiagramEditorUtil;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

public class VocabularyCreationWizard
extends Wizard
implements INewWizard {
    private IWorkbench workbench;
    protected IStructuredSelection selection;
    protected VocabularyCreationWizardPage diagramModelFilePage;
    protected VocabularyCreationWizardPage domainModelFilePage;
    protected Resource diagram;
    private boolean openNewlyCreatedDiagramEditor = true;

    public IWorkbench getWorkbench() {
        return this.workbench;
    }

    public IStructuredSelection getSelection() {
        return this.selection;
    }

    public final Resource getDiagram() {
        return this.diagram;
    }

    public final boolean isOpenNewlyCreatedDiagramEditor() {
        return this.openNewlyCreatedDiagramEditor;
    }

    public void setOpenNewlyCreatedDiagramEditor(boolean openNewlyCreatedDiagramEditor) {
        this.openNewlyCreatedDiagramEditor = openNewlyCreatedDiagramEditor;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.workbench = workbench;
        this.selection = selection;
        this.setWindowTitle(Messages.VocabularyCreationWizardTitle);
        this.setDefaultPageImageDescriptor(VocabularyDiagramEditorPlugin.getBundledImageDescriptor("icons/wizban/NewVocabularyWizard.gif"));
        this.setNeedsProgressMonitor(true);
    }

    public void addPages() {
        this.diagramModelFilePage = new VocabularyCreationWizardPage("DiagramModelFile", this.getSelection(), "vocabulary_diagram");
        this.diagramModelFilePage.setTitle(Messages.VocabularyCreationWizard_DiagramModelFilePageTitle);
        this.diagramModelFilePage.setDescription(Messages.VocabularyCreationWizard_DiagramModelFilePageDescription);
        this.addPage((IWizardPage)this.diagramModelFilePage);
        this.domainModelFilePage = new VocabularyCreationWizardPage("DomainModelFile", this.getSelection(), "vocabulary"){

            public void setVisible(boolean visible) {
                if (visible) {
                    String fileName = VocabularyCreationWizard.this.diagramModelFilePage.getFileName();
                    fileName = fileName.substring(0, fileName.length() - ".vocabulary_diagram".length());
                    this.setFileName(VocabularyDiagramEditorUtil.getUniqueFileName(this.getContainerFullPath(), fileName, "vocabulary"));
                }
                super.setVisible(visible);
            }
        };
        this.domainModelFilePage.setTitle(Messages.VocabularyCreationWizard_DomainModelFilePageTitle);
        this.domainModelFilePage.setDescription(Messages.VocabularyCreationWizard_DomainModelFilePageDescription);
        this.addPage((IWizardPage)this.domainModelFilePage);
    }

    public boolean performFinish() {
        WorkspaceModifyOperation op = new WorkspaceModifyOperation(null){

            protected void execute(IProgressMonitor monitor) throws CoreException, InterruptedException {
                VocabularyCreationWizard.this.diagram = VocabularyDiagramEditorUtil.createDiagram(VocabularyCreationWizard.this.diagramModelFilePage.getURI(), VocabularyCreationWizard.this.domainModelFilePage.getURI(), monitor);
                if (VocabularyCreationWizard.this.isOpenNewlyCreatedDiagramEditor() && VocabularyCreationWizard.this.diagram != null) {
                    try {
                        VocabularyDiagramEditorUtil.openDiagram(VocabularyCreationWizard.this.diagram);
                    }
                    catch (PartInitException e) {
                        ErrorDialog.openError((Shell)VocabularyCreationWizard.this.getContainer().getShell(), (String)Messages.VocabularyCreationWizardOpenEditorError, null, (IStatus)e.getStatus());
                    }
                }
            }
        };
        try {
            this.getContainer().run(false, true, (IRunnableWithProgress)op);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof CoreException) {
                ErrorDialog.openError((Shell)this.getContainer().getShell(), (String)Messages.VocabularyCreationWizardCreationError, null, (IStatus)((CoreException)e.getTargetException()).getStatus());
            } else {
                VocabularyDiagramEditorPlugin.getInstance().logError("Error creating diagram", e.getTargetException());
            }
            return false;
        }
        return this.diagram != null;
    }
}

