/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.opencert.apm.baseline.baseline.diagram.edit.commands;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.util.CDOUtil;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.diagram.ui.commands.SetViewMutabilityCommand;
import org.eclipse.gmf.runtime.diagram.ui.editparts.CompartmentEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.CanonicalEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.requests.ArrangeRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.RefreshConnectionsRequest;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.gmf.runtime.notation.Bounds;
import org.eclipse.gmf.runtime.notation.Location;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.opencert.apm.baseline.baseline.BaselinePackage;
import org.eclipse.opencert.apm.baseline.baseline.diagram.edit.commands.LoadViewLocations;
import org.eclipse.opencert.apm.baseline.baseline.diagram.part.BaselineDiagramUpdater;
import org.eclipse.opencert.apm.baseline.baseline.diagram.part.BaselineNodeDescriptor;
import org.eclipse.opencert.apm.baseline.baseline.diagram.part.BaselineVisualIDRegistry;
import org.eclipse.opencert.infra.general.general.NamedElement;

public class RepairDawnBaseActivityViewLocationsCommand
extends AbstractTransactionalCommand {
    private LoadViewLocations sourceFileViewLocations;
    private Point offset;
    private View parentView;
    private EditPart host;

    public RepairDawnBaseActivityViewLocationsCommand(LoadViewLocations sourceFileViewLocations, Point offset, TransactionalEditingDomain editingDomain, View parentView, EditPart host) {
        super(editingDomain, "Repair location of views", RepairDawnBaseActivityViewLocationsCommand.getWorkspaceFiles((EObject)parentView));
        this.sourceFileViewLocations = sourceFileViewLocations;
        this.parentView = parentView;
        this.host = host;
        this.offset = offset;
    }

    private List<View> findViews(List<EObject> listNodes) {
        ArrayList<View> res = new ArrayList<View>();
        for (EObject elem : listNodes) {
            EditPart editPart = this.lookForEditPart(elem);
            View view = ((IGraphicalEditPart)editPart).getNotationView();
            res.add(view);
        }
        return res;
    }

    private EditPart lookForEditPart(EObject semantic) {
        Collection editPartSet = ((IGraphicalEditPart)this.host).getViewer().getEditPartRegistry().values();
        Iterator editPartIterator = editPartSet.iterator();
        EditPart existedEditPart = null;
        while (editPartIterator.hasNext() && existedEditPart == null) {
            EditPart currentEditPart = (EditPart)editPartIterator.next();
            if (!this.isEditPartTypeAdapted(currentEditPart.getClass(), semantic.eClass()) || !semantic.equals(((GraphicalEditPart)currentEditPart).resolveSemanticElement())) continue;
            existedEditPart = currentEditPart;
        }
        return existedEditPart;
    }

    private boolean isEditPartTypeAdapted(Class<? extends EditPart> editPartClass, EClass eClass) {
        if (DiagramEditPart.class.isAssignableFrom(editPartClass) || CompartmentEditPart.class.isAssignableFrom(editPartClass)) {
            return false;
        }
        if (GraphicalEditPart.class.isAssignableFrom(editPartClass)) {
            return this.isEditPartTypeSuitableForEClass(editPartClass.asSubclass(GraphicalEditPart.class), eClass);
        }
        return false;
    }

    protected boolean isEditPartTypeSuitableForEClass(Class<? extends GraphicalEditPart> editPartClass, EClass eClass) {
        return true;
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        BaseActivityRepairDawnViewLocationsCanonicalEditPolicy kk = new BaseActivityRepairDawnViewLocationsCanonicalEditPolicy();
        kk.setHost(this.host);
        kk.setoffset(this.offset);
        kk.refresh();
        kk.deactivate();
        return CommandResult.newOKCommandResult();
    }

    public class BaseActivityRepairDawnViewLocationsCanonicalEditPolicy
    extends CanonicalEditPolicy {
        private Map<String, String> eObjectToIDMap = null;
        private Point offset;
        private List resultMCP = null;
        private Set<EStructuralFeature> myFeaturesToSynchronize;

        public void setoffset(Point offset) {
            this.offset = offset;
        }

        protected IStatus changeLocations(List<View> nodel, Location offset) {
            for (View elem : nodel) {
                this.changeLocation((Node)elem, offset);
            }
            return Status.OK_STATUS;
        }

        private IStatus changeLocation(Node node, Location offset) {
            Location lc = (Location)node.getLayoutConstraint();
            int x = lc.getX();
            int y = lc.getY();
            lc.setX(offset.getX() + x);
            lc.setY(offset.getY() + y);
            return Status.OK_STATUS;
        }

        protected void refreshOnActivate() {
            List c = this.getHost().getChildren();
            int i = 0;
            while (i < c.size()) {
                ((EditPart)c.get(i)).activate();
                ++i;
            }
            super.refreshOnActivate();
        }

        protected EStructuralFeature getFeatureToSynchronize() {
            return BaselinePackage.eINSTANCE.getBaseActivity_SubActivity();
        }

        protected List getSemanticChildrenList() {
            View viewObject = (View)this.getHost().getModel();
            LinkedList<EObject> result = new LinkedList<EObject>();
            List<BaselineNodeDescriptor> childDescriptors = BaselineDiagramUpdater.getBaseActivityBaseActivitySubActivityCompartment_7001SemanticChildren(viewObject);
            for (BaselineNodeDescriptor d : childDescriptors) {
                result.add(d.getModelElement());
            }
            return result;
        }

        protected boolean isOrphaned(Collection<EObject> semanticChildren, View view) {
            return this.isMyDiagramElement(view) && !semanticChildren.contains(view.getElement());
        }

        private boolean isMyDiagramElement(View view) {
            return 2001 == BaselineVisualIDRegistry.getVisualID(view);
        }

        private void setIDs() {
            this.eObjectToIDMap = new HashMap<String, String>();
            List result = this.getSemanticChildrenList();
            for (EObject elem : result) {
                CDOID cdoID = CDOUtil.getCDOObject((EObject)elem).cdoID();
                new Long(cdoID.toURIFragment());
                this.eObjectToIDMap.put(cdoID.toString(), cdoID.toString());
                NamedElement me = (NamedElement)elem;
                System.out.println("setIDs key = " + me.getId() + "|" + me.getName() + "|" + me.getClass().getName() + ". (" + cdoID.toString() + ")");
            }
        }

        private String getID(String eObjectID) {
            if (this.eObjectToIDMap == null) {
                return null;
            }
            return this.eObjectToIDMap.get(eObjectID);
        }

        protected Command createViewsAndArrangeCommand2(Point locat, Dimension size, List viewDescriptors) {
            CreateViewRequest createViewRequest = new CreateViewRequest(viewDescriptors);
            createViewRequest.setLocation(locat);
            createViewRequest.setSize(size);
            Command createCommand = this.getHost().getCommand((Request)createViewRequest);
            if (createCommand != null) {
                this.resultMCP = (List)createViewRequest.getNewObject();
                RefreshConnectionsRequest refreshRequest = new RefreshConnectionsRequest(this.resultMCP);
                Command refreshCommand = this.getHost().getCommand((Request)refreshRequest);
                ArrangeRequest arrangeRequest = new ArrangeRequest("arrange_deferred");
                arrangeRequest.setViewAdaptersToArrange(this.resultMCP);
                Command arrangeCommand = this.getHost().getCommand((Request)arrangeRequest);
                CompoundCommand cc = new CompoundCommand(createCommand.getLabel());
                cc.add(createCommand.chain(refreshCommand));
                cc.add(arrangeCommand);
                return cc;
            }
            return null;
        }

        protected void refreshSemantic() {
            if (this.resolveSemanticElement() == null) {
                return;
            }
            LinkedList createdViews = new LinkedList();
            List<BaselineNodeDescriptor> childDescriptors = BaselineDiagramUpdater.getBaseActivityBaseActivitySubActivityCompartment_7001SemanticChildren((View)this.getHost().getModel());
            this.setIDs();
            LinkedList orphaned = new LinkedList();
            LinkedList<View> knownViewChildren = new LinkedList<View>();
            for (View v : this.getViewChildren()) {
                if (!this.isMyDiagramElement(v)) continue;
                knownViewChildren.add(v);
            }
            orphaned.addAll(knownViewChildren);
            ArrayList<CreateViewRequest.ViewDescriptor> viewDescriptors = new ArrayList<CreateViewRequest.ViewDescriptor>(childDescriptors.size());
            for (BaselineNodeDescriptor next : childDescriptors) {
                String hint = BaselineVisualIDRegistry.getType(next.getVisualID());
                CanonicalEditPolicy.CanonicalElementAdapter elementAdapter = new CanonicalEditPolicy.CanonicalElementAdapter(next.getModelElement(), hint);
                CreateViewRequest.ViewDescriptor descriptor = new CreateViewRequest.ViewDescriptor((IAdaptable)elementAdapter, Node.class, hint, -1, true, this.host().getDiagramPreferencesHint());
                viewDescriptors.add(descriptor);
            }
            boolean changed = this.deleteViews(orphaned.iterator());
            SetViewMutabilityCommand.makeMutable((IAdaptable)new EObjectAdapter((EObject)this.host().getNotationView())).execute();
            for (CreateViewRequest.ViewDescriptor oneviewDescriptor : viewDescriptors) {
                this.resultMCP = null;
                ArrayList<CreateViewRequest.ViewDescriptor> oneviewDescriptorl = new ArrayList<CreateViewRequest.ViewDescriptor>(1);
                oneviewDescriptorl.add(oneviewDescriptor);
                NamedElement me = (NamedElement)oneviewDescriptor.getElementAdapter().getAdapter(NamedElement.class);
                System.out.println("refreshSemantic key = " + me.getId() + me.getName() + me.getClass().getName());
                Bounds lc = (Bounds)RepairDawnBaseActivityViewLocationsCommand.this.sourceFileViewLocations.getObjectLocation(String.valueOf(me.getId()) + me.getName() + me.eClass().getName());
                System.out.println("refreshSemantic lc = " + lc.getX() + ", " + lc.getY() + ", " + lc.getWidth() + ", " + lc.getHeight());
                Point point = new Point(lc.getX(), lc.getY());
                Dimension size = new Dimension(lc.getWidth(), lc.getHeight());
                Command command = this.createViewsAndArrangeCommand2(point, size, oneviewDescriptorl);
                if (command == null || !command.canExecute()) continue;
                this.executeCommand(command);
                createdViews.addAll(this.resultMCP);
            }
            if (changed || createdViews.size() > 0) {
                this.postProcessRefreshSemantic(createdViews);
            }
            this.makeViewsImmutable(createdViews);
        }
    }
}

