/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.emf.facet.efacet.ui.internal.view;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.osgi.util.NLS;
import org.eclipse.papyrus.emf.facet.efacet.ui.IETypedElementResultDisplayer;
import org.eclipse.papyrus.emf.facet.efacet.ui.internal.Activator;
import org.eclipse.papyrus.emf.facet.util.core.Logger;
import org.eclipse.papyrus.emf.facet.util.core.internal.exported.AbstractRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryResultDisplayersRegistry
extends AbstractRegistry {
    private static final String EXTENSION_POINT_NAME = "eTypedElementResultDisplay";
    private static final String ELEMENT_QUERY_RESULT_DISPLAYER = "displayer";
    private static final String ATTRIBUTE_CLASS = "class";
    private static QueryResultDisplayersRegistry instance = null;
    private final List<IETypedElementResultDisplayer> queryResultDisplayers = new ArrayList<IETypedElementResultDisplayer>();

    public QueryResultDisplayersRegistry() {
        this.initialize();
    }

    public static QueryResultDisplayersRegistry getInstance() {
        if (instance == null) {
            instance = new QueryResultDisplayersRegistry();
        }
        return instance;
    }

    public List<IETypedElementResultDisplayer> getQueryResultDisplayers() {
        return this.queryResultDisplayers;
    }

    public IETypedElementResultDisplayer getQueryResultDisplayer(String name) {
        for (IETypedElementResultDisplayer namedQueryResultDisplayer : this.queryResultDisplayers) {
            if (!name.equals(namedQueryResultDisplayer.getName())) continue;
            return namedQueryResultDisplayer;
        }
        return null;
    }

    protected String getExtensionPointName() {
        return EXTENSION_POINT_NAME;
    }

    protected String getExtensionPointNamespace() {
        return Activator.getDefault().getBundle().getSymbolicName();
    }

    protected void handleRootElement(IConfigurationElement configurationElement) {
        String name = configurationElement.getName();
        if (name.equalsIgnoreCase(ELEMENT_QUERY_RESULT_DISPLAYER)) {
            this.readQueryResultDisplayer(configurationElement);
        } else {
            QueryResultDisplayersRegistry.logUnknownElement((IConfigurationElement)configurationElement);
        }
    }

    private void readQueryResultDisplayer(IConfigurationElement configurationElement) {
        Object queryResultDisplayerObject = null;
        try {
            queryResultDisplayerObject = configurationElement.createExecutableExtension(ATTRIBUTE_CLASS);
        }
        catch (CoreException e) {
            Logger.logError((Throwable)e, (Plugin)Activator.getDefault());
        }
        if (queryResultDisplayerObject == null) {
            QueryResultDisplayersRegistry.logMissingAttribute((IConfigurationElement)configurationElement, (String)ATTRIBUTE_CLASS);
            return;
        }
        if (queryResultDisplayerObject instanceof IETypedElementResultDisplayer) {
            IETypedElementResultDisplayer queryResultDisplayer = (IETypedElementResultDisplayer)queryResultDisplayerObject;
            this.queryResultDisplayers.add(queryResultDisplayer);
        } else {
            QueryResultDisplayersRegistry.logError((IConfigurationElement)configurationElement, (String)NLS.bind((String)"The given class is not a {0}.", (Object)IETypedElementResultDisplayer.class.getSimpleName()));
        }
    }
}

