/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.chess.contracts.chessextension.dialogs;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.Property;
import org.polarsys.chess.contracts.profile.chesscontract.ComponentInstance;
import org.polarsys.chess.contracts.profile.chesscontract.ContractProperty;
import org.polarsys.chess.contracts.profile.chesscontract.DataTypes.ContractTypes;

public class SetContractRefinementDialog
extends Dialog {
    private List refineList;
    private Class ownerClass;
    private String[] selected;

    public SetContractRefinementDialog(Shell shell, Class ownerClass) {
        super(shell);
        this.ownerClass = ownerClass;
    }

    protected Control createDialogArea(Composite parent) {
        GridLayout layout = new GridLayout(1, true);
        layout.horizontalSpacing = 4;
        layout.verticalSpacing = 4;
        layout.marginBottom = 5;
        layout.marginTop = 5;
        parent.setLayout((Layout)layout);
        new Label(parent, 0).setText("Select Refinements:");
        GridData gridData = new GridData(768);
        this.refineList = new List(parent, 2562);
        for (Property part : this.ownerClass.getParts()) {
            if (part instanceof Port) continue;
            Class partClass = (Class)part.getType();
            for (Property prop : partClass.getAttributes()) {
                ContractProperty cp;
                if (prop.getAppliedStereotype("CHESSContract::ContractProperty") == null || !(cp = (ContractProperty)prop.getStereotypeApplication(prop.getAppliedStereotype("CHESSContract::ContractProperty"))).getContractType().equals((Object)ContractTypes.STRONG)) continue;
                this.refineList.add(String.valueOf(part.getName()) + "." + prop.getName());
            }
            if (part.getAppliedStereotype("CHESSContract::ComponentInstance") == null) continue;
            ComponentInstance compInst = (ComponentInstance)part.getStereotypeApplication(part.getAppliedStereotype("CHESSContract::ComponentInstance"));
            for (ContractProperty c : compInst.getWeakGuarantees()) {
                this.refineList.add(String.valueOf(part.getName()) + "." + c.getBase_Property().getName());
            }
        }
        this.refineList.setLayoutData((Object)gridData);
        return parent;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText("Set Contract Refinement");
    }

    protected boolean isResizable() {
        return true;
    }

    protected void okPressed() {
        this.setSelected(this.refineList.getSelection());
        super.okPressed();
    }

    public String[] getSelected() {
        return this.selected;
    }

    public void setSelected(String[] selected) {
        this.selected = selected;
    }
}

