/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.profile.custom.commands;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.emf.utils.ServiceUtilsForEObject;
import org.eclipse.papyrus.infra.services.edit.service.ElementEditServiceUtils;
import org.eclipse.papyrus.infra.services.edit.service.IElementEditService;
import org.eclipse.papyrus.infra.services.labelprovider.service.LabelProviderService;
import org.eclipse.papyrus.infra.widgets.editors.IElementSelector;
import org.eclipse.papyrus.infra.widgets.editors.MultipleValueSelectorDialog;
import org.eclipse.papyrus.infra.widgets.providers.IStaticContentProvider;
import org.eclipse.papyrus.infra.widgets.selectors.ReferenceSelector;
import org.eclipse.papyrus.uml.diagram.common.Activator;
import org.eclipse.papyrus.uml.diagram.profile.custom.helper.MetaclassHelper;
import org.eclipse.papyrus.uml.diagram.profile.custom.messages.Messages;
import org.eclipse.papyrus.uml.diagram.profile.custom.requests.CustomCreateElementRequestAdapter;
import org.eclipse.papyrus.uml.tools.providers.UMLMetaclassContentProvider;
import org.eclipse.swt.widgets.Display;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.ElementImport;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.PackageableElement;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.UMLFactory;
import org.eclipse.uml2.uml.UMLPackage;

public class CustomSemanticCreateCommand
extends AbstractTransactionalCommand {
    private CustomCreateElementRequestAdapter customRequestAdapter;
    private List<Object> addedMetaclasses;
    private Profile profile;

    public CustomSemanticCreateCommand(TransactionalEditingDomain domain, CustomCreateElementRequestAdapter requestAdapter, Profile profile) {
        super(domain, Messages.CustomSemanticCreateCommand_CreateCustomSemanticCommandForMetaclass, null);
        this.profile = profile;
        this.customRequestAdapter = requestAdapter;
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        CommandResult result = CommandResult.newCancelledCommandResult();
        ReferenceSelector selector = new ReferenceSelector(true);
        selector.setContentProvider((IStaticContentProvider)new UMLMetaclassContentProvider((Element)this.profile));
        LabelProviderService serv = null;
        try {
            serv = (LabelProviderService)ServiceUtilsForEObject.getInstance().getService(LabelProviderService.class, (Object)this.profile);
        }
        catch (ServiceException e) {
            Activator.log.error(Messages.CustomSemanticCreateCommand_LabelProviderServiceNotFound, (Throwable)e);
        }
        ILabelProvider labelProvider = serv.getLabelProvider();
        selector.setLabelProvider(labelProvider);
        ArrayList alreadyImportedElement = new ArrayList();
        CreateElementRequest request = this.customRequestAdapter.getRequest(0);
        if (MetaclassHelper.shouldSuppressDialog((IEditCommandRequest)request)) {
            this.addedMetaclasses = MetaclassHelper.getSuppressedDialogResult((IEditCommandRequest)request);
        } else {
            MultipleValueSelectorDialog dialog = new MultipleValueSelectorDialog(Display.getDefault().getActiveShell(), (IElementSelector)selector, Messages.CustomSemanticCreateCommand_SelectMetaclass, true, false, -1);
            dialog.setContextElement((Object)this.profile);
            dialog.setLabelProvider(labelProvider);
            dialog.setInitialElementSelections(alreadyImportedElement);
            if (dialog.open() == 0) {
                Object[] selectedMetaclass = dialog.getResult();
                this.addedMetaclasses = Arrays.asList(selectedMetaclass);
            }
        }
        if (!this.addedMetaclasses.isEmpty()) {
            ICommand createElementImportCommand = this.getImportElementCommand();
            if (createElementImportCommand != null) {
                createElementImportCommand.execute(progressMonitor, info);
            }
            return CommandResult.newOKCommandResult();
        }
        return result;
    }

    private ICommand getImportElementCommand() {
        CompositeCommand addindCommand = new CompositeCommand("Add ImportElement Command");
        EList metaclassSet = this.profile.getReferencedMetaclasses();
        int i = 0;
        while (i < this.addedMetaclasses.size()) {
            if (!metaclassSet.contains(this.addedMetaclasses.get(i))) {
                ElementImport ei = UMLFactory.eINSTANCE.createElementImport();
                ei.setImportedElement((PackageableElement)this.addedMetaclasses.get(i));
                ei.setAlias(((NamedElement)this.addedMetaclasses.get(i)).getName());
                ElementImport added = ei;
                EList list = this.profile.getElementImports();
                int iter = 0;
                while (iter < list.size()) {
                    if (list.get(iter) != null && ((ElementImport)list.get(iter)).getImportedElement() != null && ei.getImportedElement().getQualifiedName().equals(((ElementImport)list.get(iter)).getImportedElement().getQualifiedName())) {
                        added = (ElementImport)list.get(iter);
                        break;
                    }
                    ++iter;
                }
                SetRequest setRequest = new SetRequest((EObject)this.profile, (EStructuralFeature)UMLPackage.eINSTANCE.getProfile_MetaclassReference(), (Object)added);
                IElementEditService provider = ElementEditServiceUtils.getCommandProvider((Object)this.profile);
                if (provider != null) {
                    ICommand editCommand = null;
                    editCommand = provider.getEditCommand((IEditCommandRequest)setRequest);
                    if (editCommand != null) {
                        addindCommand.add((IUndoableOperation)editCommand);
                    }
                }
            }
            this.customRequestAdapter.setNewElement((EObject)this.addedMetaclasses.get(i));
            ++i;
        }
        if (!addindCommand.isEmpty()) {
            return addindCommand;
        }
        return null;
    }
}

