/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.internal.util.table;

import java.text.DecimalFormat;
import java.text.Format;
import org.eclipse.net4j.internal.util.table.Cell;
import org.eclipse.net4j.internal.util.table.Coordinate;
import org.eclipse.net4j.internal.util.table.Dumper;
import org.eclipse.net4j.internal.util.table.Formula;
import org.eclipse.net4j.internal.util.table.Generator;
import org.eclipse.net4j.internal.util.table.Range;
import org.eclipse.net4j.internal.util.table.RectangularRange;

public class Table
extends RectangularRange {
    Cell[][] cells;

    public Table(int cols, int rows) {
        super(null, Coordinate.ZERO, new Coordinate(cols - 1, rows - 1));
        this.cells = new Cell[cols][];
        int col = 0;
        while (col < cols) {
            this.cells[col] = new Cell[rows];
            int row = 0;
            while (row < rows) {
                this.cells[col][row] = new Cell(this, col, row);
                ++row;
            }
            ++col;
        }
    }

    public Table(int cols) {
        this(cols, 1);
    }

    public Table() {
        this(1);
    }

    public Table table() {
        return this;
    }

    public Cell cell(Coordinate coordinate) {
        return this.cell(coordinate.col, coordinate.row);
    }

    public Cell cell(int col, int row) {
        int c = this.cols();
        while (c <= col) {
            this.addColumn();
            ++c;
        }
        int r = this.rows();
        while (r <= row) {
            this.addRow();
            ++r;
        }
        return this.cells[col][row];
    }

    public RectangularRange range(Coordinate coordinate1, Coordinate coordinate2) {
        return new RectangularRange(this, coordinate1, coordinate2);
    }

    public RectangularRange range(int col1, int row1, int col2, int row2) {
        return this.range(new Coordinate(col1, row1), new Coordinate(col2, row2));
    }

    public RectangularRange column(int col) {
        return this.column(col, 0);
    }

    public RectangularRange column(int col, int skipTopRows) {
        return this.column(col, skipTopRows, 0);
    }

    public RectangularRange column(int col, int skipTopRows, int skipBottomRows) {
        return this.range(new Coordinate(col, skipTopRows), new Coordinate(col, this.bottomRight.row - skipBottomRows));
    }

    public Table addColumn(int index) {
        int cols = this.cells.length;
        this.addColumn();
        if (index < cols) {
            this.moveColumn(cols, index);
        }
        return this;
    }

    public Table addColumn() {
        int cols = this.cells.length;
        int rows = this.cells[0].length;
        Cell[][] newCells = new Cell[cols + 1][];
        System.arraycopy(this.cells, 0, newCells, 0, cols);
        newCells[cols] = new Cell[rows];
        int row = 0;
        while (row < rows) {
            newCells[cols][row] = new Cell(this, cols, row);
            ++row;
        }
        this.cells = newCells;
        this.bottomRight = this.bottomRight.offset(1, 0);
        return this;
    }

    public Table moveColumn(int from, int to) {
        int rows = this.cells[0].length;
        if (from != to) {
            int row = 0;
            while (row < rows) {
                int col;
                Cell cell = this.cells[from][row];
                if (from < to) {
                    col = from;
                    while (col < to) {
                        this.setCell(col, row, this.cells[col + 1][row]);
                        ++col;
                    }
                } else {
                    col = from;
                    while (col > to) {
                        this.setCell(col, row, this.cells[col - 1][row]);
                        --col;
                    }
                }
                this.setCell(to, row, cell);
                ++row;
            }
        }
        return this;
    }

    public RectangularRange row(int row) {
        return this.row(row, 0);
    }

    public RectangularRange row(int row, int skipLeftColumns) {
        return this.row(row, skipLeftColumns, 0);
    }

    public RectangularRange row(int row, int skipLeftColumns, int skipRightColumns) {
        return this.range(new Coordinate(skipLeftColumns, row), new Coordinate(this.bottomRight.col - skipRightColumns, row));
    }

    public Table addRow(int index) {
        int rows = this.cells[0].length;
        this.addRow();
        if (index < rows) {
            this.moveRow(rows, index);
        }
        return this;
    }

    public Table addRow() {
        int cols = this.cells.length;
        int rows = this.cells[0].length;
        int col = 0;
        while (col < cols) {
            Cell[] newColumn = new Cell[rows + 1];
            System.arraycopy(this.cells[col], 0, newColumn, 0, rows);
            newColumn[rows] = new Cell(this, col, rows);
            this.cells[col] = newColumn;
            ++col;
        }
        this.bottomRight = this.bottomRight.offset(0, 1);
        return this;
    }

    public Table moveRow(int from, int to) {
        int cols = this.cells.length;
        if (from != to) {
            int col = 0;
            while (col < cols) {
                int row;
                Cell cell = this.cells[col][from];
                if (from < to) {
                    row = from;
                    while (row < to) {
                        this.setCell(col, row, this.cells[col][row + 1]);
                        ++row;
                    }
                } else {
                    row = from;
                    while (row > to) {
                        this.setCell(col, row, this.cells[col][row - 1]);
                        --row;
                    }
                }
                this.setCell(col, to, cell);
                ++col;
            }
        }
        return this;
    }

    public Table value(Object value) {
        return (Table)super.value(value);
    }

    public Table format(Format format) {
        return (Table)super.format(format);
    }

    public Table alignment(Range.Alignment alignment) {
        return (Table)super.alignment(alignment);
    }

    private void setCell(int col, int row, Cell cell) {
        this.cells[col][row] = cell;
        cell.col = col;
        cell.row = row;
    }

    public static void main(String[] args) throws Exception {
        Table table1 = new Table();
        table1.range(0, 0, 5, 5).subtractRange(0, 0, 7, 0).value(new Generator.Incrementer());
        table1.row(0).format(new DecimalFormat("Series 0")).value(new Generator.Incrementer(1.0));
        Dumper.UTF8.dump(System.out, (RectangularRange)table1, 0);
        Table table2 = new Table(2, 11);
        table2.row(0).alignment(Range.Alignment.RIGHT);
        table2.cell(0, 0).value("Probe");
        table2.cell(1, 0).value("Percent");
        RectangularRange probes = table2.column(0, 1).value(new Generator.Incrementer(1.0));
        for (Cell cell : probes.offset(1, 0).format(new DecimalFormat("0.00 %"))) {
            cell.value(new Formula.Percent(probes, cell.offset(-1, 0)));
        }
        Dumper.UTF8.dump(System.out, (RectangularRange)table2, 0);
    }
}

