/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.cache;

import org.eclipse.net4j.util.cache.ICacheMonitor;

public class ThresholdConditionPolicy
implements ICacheMonitor.ConditionPolicy {
    private long thresholdRedYellow;
    private long thresholdYellowGreen;

    public ThresholdConditionPolicy(long thresholdRedYellow, long thresholdYellowGreen) {
        if (thresholdRedYellow > thresholdYellowGreen) {
            throw new IllegalArgumentException("thresholdRedYellow > thresholdYellowGreen");
        }
        this.thresholdRedYellow = thresholdRedYellow;
        this.thresholdYellowGreen = thresholdYellowGreen;
    }

    public long getThresholdRedYellow() {
        return this.thresholdRedYellow;
    }

    public long getThresholdYellowGreen() {
        return this.thresholdYellowGreen;
    }

    public ICacheMonitor.Condition getNewCondition(ICacheMonitor.Condition oldCondition) {
        return this.getNewCondition(oldCondition, Runtime.getRuntime().freeMemory());
    }

    protected ICacheMonitor.Condition getNewCondition(ICacheMonitor.Condition oldCondition, long freeMemory) {
        if (freeMemory > this.thresholdYellowGreen) {
            return ICacheMonitor.Condition.GREEN;
        }
        if (freeMemory > this.thresholdRedYellow) {
            return ICacheMonitor.Condition.YELLOW;
        }
        return ICacheMonitor.Condition.RED;
    }
}

