/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.opencert.apm.assurproj.assuranceproject.etl;

import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.epsilon.common.parse.problem.ParseProblem;
import org.eclipse.epsilon.common.util.StringProperties;
import org.eclipse.epsilon.emc.emf.EmfModel;
import org.eclipse.epsilon.emc.emf.xml.XmlModel;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;
import org.eclipse.epsilon.eol.exceptions.models.EolModelLoadingException;
import org.eclipse.epsilon.eol.models.IModel;
import org.eclipse.epsilon.eol.models.IRelativePathResolver;
import org.eclipse.epsilon.etl.EtlModule;
import org.eclipse.epsilon.etl.dom.TransformationRule;
import org.eclipse.epsilon.etl.trace.Transformation;
import org.eclipse.opencert.apm.assurproj.assuranceproject.etl.EpfTransformParameters;
import org.eclipse.opencert.apm.assurproj.assuranceproject.etl.RedirectSystemErr;
import org.eclipse.opencert.apm.assurproj.assuranceproject.provider.AssuranceprojectEditPlugin;

public class EpfTransformation {
    private static final String RESOURCE_PATH_PREFIX = "/";
    private static final String UTF_8 = "UTF-8";
    private String pluginID;
    private String etlTransform;
    private Object result;
    private String confName;
    private String confModelFilePath;
    private Boolean confReadOnLoad;
    private Boolean confStoreOnDisposal;
    private String libName;
    private String libModelFilePath;
    private boolean libReadOnLoad;
    private boolean libStoreOnDisposal;
    private String epfMetamodelURI;
    private String epfMetamodelFilePath;
    private String processName;
    private String processMetamodelURI;
    private String processMetaModelFilePath;
    private String processModelFilePath;
    private boolean processReadOnLoad;
    private boolean processStoreOnDisposal;
    private String artName;
    private String artMetamodelURI;
    private String artMetaModelFilePath;
    private String artModelFilePath;
    private boolean artReadOnLoad;
    private boolean artStoreOnDisposal;

    public void execute() throws Exception {
        URL resolvedTransformationURL = null;
        java.net.URI transformURI = null;
        String file = null;
        try {
            String spluginPath = AssuranceprojectEditPlugin.getPlugin().getBundle().getLocation();
            RedirectSystemErr.out("spluginPath:= ." + spluginPath + ".");
            if (spluginPath.contains("plugins")) {
                String file2;
                String pluginPath = "configuration";
                Iterator transformationEntry = AssuranceprojectEditPlugin.getPlugin().getBundle().getEntry(this.etlTransform);
                resolvedTransformationURL = FileLocator.resolve((URL)((Object)transformationEntry));
                file = resolvedTransformationURL.getFile();
                file = file.replace(" ", "%20");
                String wrong = file.substring(file.indexOf("plugins"), file.indexOf(RESOURCE_PATH_PREFIX + this.etlTransform));
                file = file2 = file.replace(wrong, pluginPath);
            } else {
                URL transformationEntry = AssuranceprojectEditPlugin.getPlugin().getBundle().getEntry(this.etlTransform);
                resolvedTransformationURL = FileLocator.resolve((URL)transformationEntry);
                file = "file:" + resolvedTransformationURL.getFile();
                file = file.replace(" ", "%20");
            }
            RedirectSystemErr.out("rules file:= ." + file + ".");
            transformURI = new java.net.URI(file);
        }
        catch (IOException e) {
            e.printStackTrace();
            RedirectSystemErr.out("execute exception 1: " + e.toString());
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
            RedirectSystemErr.out("execute exception 2: " + e.toString());
        }
        EtlModule etlModule = new EtlModule();
        try {
            etlModule.parse(transformURI);
        }
        catch (Exception e) {
            e.printStackTrace();
            RedirectSystemErr.out("execute exception 3: " + e.toString());
        }
        if (etlModule.getParseProblems().size() > 0) {
            System.err.println("Parse errors occured...");
            for (ParseProblem problem : etlModule.getParseProblems()) {
                System.err.println(problem.toString());
                RedirectSystemErr.out("encontrado " + problem.toString());
            }
        }
        for (TransformationRule rule : etlModule.getTransformationRules()) {
            RedirectSystemErr.out("rule = ." + rule.toString() + ".");
        }
        XmlModel confModel = this.createSourceXmlModel(this.confName, this.epfMetamodelFilePath, this.confModelFilePath, this.confReadOnLoad, this.confStoreOnDisposal);
        XmlModel libModel = this.createSourceXmlModel(this.libName, this.epfMetamodelFilePath, this.libModelFilePath, this.libReadOnLoad, this.libStoreOnDisposal);
        EmfModel processModel = this.createTargetEmFModel(this.processName, this.processMetamodelURI, this.processMetaModelFilePath, this.processModelFilePath, this.processReadOnLoad, this.processStoreOnDisposal);
        EmfModel artModel = this.createTargetEmFModel(this.artName, this.artMetamodelURI, this.artMetaModelFilePath, this.artModelFilePath, this.artReadOnLoad, this.artStoreOnDisposal);
        if (confModel == null) {
            RedirectSystemErr.out("confModel is null");
        }
        if (libModel == null) {
            RedirectSystemErr.out("libModel is null");
        }
        if (processModel == null) {
            RedirectSystemErr.out("processModel is null");
        }
        if (artModel == null) {
            RedirectSystemErr.out("artModel is null");
        }
        etlModule.getContext().getModelRepository().addModel((IModel)confModel);
        etlModule.getContext().getModelRepository().addModel((IModel)libModel);
        etlModule.getContext().getModelRepository().addModel((IModel)processModel);
        etlModule.getContext().getModelRepository().addModel((IModel)artModel);
        try {
            this.result = etlModule.execute();
        }
        catch (EolRuntimeException e) {
            e.printStackTrace();
            RedirectSystemErr.out("execute exception 4: " + e.toString());
        }
        RedirectSystemErr.out("execute voy a leer reglas disparadas ");
        for (Transformation elem : etlModule.getContext().getTransformationTrace().getTransformations()) {
            TransformationRule rule = elem.getRule();
            Object source = elem.getSource();
            Collection targets = elem.getTargets();
            System.out.println("Fired rule =" + rule.getName() + ": source =[" + source.toString() + "] & tragets =[" + targets.toString() + "]");
        }
        confModel.dispose();
        libModel.dispose();
        processModel.dispose();
        artModel.dispose();
        etlModule.getContext().getModelRepository().dispose();
    }

    private URI getResourceEmfURI(String resourcePath) {
        URI res = URI.createURI((String)this.getClass().getResource(RESOURCE_PATH_PREFIX + resourcePath).toExternalForm());
        System.out.println(res.toFileString());
        return res;
    }

    protected XmlModel createSourceXmlModel(String name, String sourceMetaModelFilePath, String sourceModelFilePath, Boolean sourceReadOnLoad, Boolean sourceStoreOnDisposal) {
        XmlModel xmlModel = new XmlModel();
        try {
            StringProperties sp = new StringProperties();
            sp.put((Object)"name", (Object)name);
            sp.put((Object)"readOnLoad", (Object)sourceReadOnLoad);
            sp.put((Object)"storeOnDisposal", (Object)sourceStoreOnDisposal);
            sp.put((Object)XmlModel.PROPERTY_XSD_FILE, (Object)sourceMetaModelFilePath);
            sp.put((Object)"modelFile", (Object)sourceModelFilePath);
            xmlModel.load(sp, new IRelativePathResolver(){

                public String resolve(String relativePath) {
                    return relativePath;
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return xmlModel;
    }

    protected EmfModel createTargetEmFModel(String name, String targetMetaModelURI, String targetMetaModelFilePath, String targetModelFilePath, Boolean targetReadOnLoad, Boolean targetStoreOnDisposal) {
        int i;
        String[] metaModelURIs;
        EmfModel emfModel = new EmfModel();
        emfModel.setName(name);
        if (targetMetaModelURI != null && !targetMetaModelURI.isEmpty()) {
            emfModel.setMetamodelFileBased(false);
            if (targetMetaModelURI.contains(",")) {
                metaModelURIs = targetMetaModelURI.split(",");
                ArrayList<String> uris = new ArrayList<String>(metaModelURIs.length);
                i = 0;
                while (i < metaModelURIs.length) {
                    uris.add(metaModelURIs[i].trim());
                    ++i;
                }
                RedirectSystemErr.out("target uris:= ." + ((Object)uris).toString() + ".");
                emfModel.setMetamodelUris(uris);
            } else {
                RedirectSystemErr.out("targetMetaModelURI:= ." + targetMetaModelURI + ".");
                emfModel.setMetamodelUri(targetMetaModelURI);
            }
        }
        if (targetMetaModelFilePath != null && !targetMetaModelFilePath.isEmpty()) {
            emfModel.setMetamodelFileBased(true);
            if (targetMetaModelFilePath.contains(",")) {
                metaModelURIs = targetMetaModelFilePath.split(",");
                ArrayList<String> files = new ArrayList<String>(metaModelURIs.length);
                new ArrayList(metaModelURIs.length);
                i = 0;
                while (i < metaModelURIs.length) {
                    files.add(metaModelURIs[i].trim());
                    ++i;
                }
                RedirectSystemErr.out("target files:= ." + ((Object)files).toString() + ".");
                emfModel.setMetamodelFiles(files);
            } else {
                RedirectSystemErr.out("targetMetaModelFilePath:= ." + targetMetaModelFilePath + ".");
                emfModel.setMetamodelFile(targetMetaModelFilePath);
            }
        }
        RedirectSystemErr.out("targetModelFilePath:= ." + targetModelFilePath + ".");
        emfModel.setModelFile(targetModelFilePath);
        emfModel.setReadOnLoad(targetReadOnLoad.booleanValue());
        emfModel.setStoredOnDisposal(targetStoreOnDisposal.booleanValue());
        emfModel.setCachingEnabled(true);
        emfModel.setExpand(true);
        try {
            emfModel.load();
        }
        catch (EolModelLoadingException e) {
            e.printStackTrace();
        }
        return emfModel;
    }

    public void createJob(EpfTransformParameters parameters) {
        this.pluginID = parameters.getPluginID();
        this.etlTransform = parameters.getEtlTransform();
        this.confName = parameters.getConfName();
        this.confModelFilePath = parameters.getConfModelFilePath();
        this.confReadOnLoad = parameters.isConfReadOnLoad();
        this.confStoreOnDisposal = parameters.isConfStoreOnDisposal();
        this.libName = parameters.getLibName();
        this.libModelFilePath = parameters.getLibModelFilePath();
        this.libReadOnLoad = parameters.isLibReadOnLoad();
        this.libStoreOnDisposal = parameters.isLibStoreOnDisposal();
        this.epfMetamodelURI = parameters.getEPFMetaModelURI();
        this.epfMetamodelFilePath = parameters.getEPFMetaModelFilePath();
        this.processName = parameters.getProcessName();
        this.processMetamodelURI = parameters.getProcessMetamodelURI();
        this.processMetaModelFilePath = parameters.getProcessMetamodelFilePath();
        this.processModelFilePath = parameters.getProcessModelFilePath();
        this.processReadOnLoad = parameters.isProcessReadOnLoad();
        this.processStoreOnDisposal = parameters.isProcessStoreOnDisposal();
        this.artName = parameters.getArtName();
        this.artMetamodelURI = parameters.getArtMetamodelURI();
        this.artMetaModelFilePath = parameters.getArtMetamodelFilePath();
        this.artModelFilePath = parameters.getArtModelFilePath();
        this.artReadOnLoad = parameters.isArtReadOnLoad();
        this.artStoreOnDisposal = parameters.isArtStoreOnDisposal();
    }

    public Object getResult() {
        return this.result;
    }
}

