/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.opencert.userguidance.autocomplete;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.jface.fieldassist.IContentProposalListener;
import org.eclipse.jface.fieldassist.IContentProposalListener2;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.fieldassist.IControlContentAdapter2;
import org.eclipse.jface.util.Util;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.opencert.userguidance.autocomplete.ContentProposalPopup;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class ContentProposalAdapter2 {
    public static final boolean DEBUG = false;
    public static final int PROPOSAL_INSERT = 1;
    public static final int PROPOSAL_REPLACE = 2;
    public static final int PROPOSAL_IGNORE = 3;
    public static final int FILTER_NONE = 1;
    public static final int FILTER_CHARACTER = 2;
    public static final int FILTER_CUMULATIVE = 3;
    static final boolean USE_VIRTUAL = !Util.isMotif();
    static final int POPUP_DELAY = 750;
    static final int POPUP_CHAR_HEIGHT = 10;
    static final int POPUP_MINIMUM_WIDTH = 300;
    static final int POPUP_OFFSET = 3;
    static final String EMPTY = "";
    private IContentProposalProvider proposalProvider;
    ILabelProvider labelProvider;
    Control control;
    IControlContentAdapter controlContentAdapter;
    private ContentProposalPopup popup;
    private KeyStroke triggerKeyStroke;
    private String autoActivateString;
    private int proposalAcceptanceStyle = 1;
    boolean propagateKeys = true;
    int filterStyle = 1;
    private Listener controlListener;
    private ListenerList proposalListeners = new ListenerList();
    private ListenerList proposalListeners2 = new ListenerList();
    private boolean isEnabled = true;
    private int autoActivationDelay = 0;
    private boolean receivedKeyDown;
    Point popupSize;
    private int insertionPos = -1;
    private Point selectionRange = new Point(-1, -1);
    private boolean watchModify = false;

    public ContentProposalAdapter2(Control control, IControlContentAdapter controlContentAdapter, IContentProposalProvider proposalProvider, KeyStroke keyStroke, char[] autoActivationCharacters) {
        Assert.isNotNull((Object)control);
        Assert.isNotNull((Object)controlContentAdapter);
        this.control = control;
        this.controlContentAdapter = controlContentAdapter;
        this.proposalProvider = proposalProvider;
        this.triggerKeyStroke = keyStroke;
        if (autoActivationCharacters != null) {
            this.autoActivateString = new String(autoActivationCharacters);
        }
        this.addControlListener(control);
    }

    public Control getControl() {
        return this.control;
    }

    public ILabelProvider getLabelProvider() {
        return this.labelProvider;
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public void setLabelProvider(ILabelProvider labelProvider) {
        this.labelProvider = labelProvider;
    }

    public IContentProposalProvider getContentProposalProvider() {
        return this.proposalProvider;
    }

    public void setContentProposalProvider(IContentProposalProvider proposalProvider) {
        this.proposalProvider = proposalProvider;
    }

    public char[] getAutoActivationCharacters() {
        if (this.autoActivateString == null) {
            return null;
        }
        return this.autoActivateString.toCharArray();
    }

    public void setAutoActivationCharacters(char[] autoActivationCharacters) {
        this.autoActivateString = autoActivationCharacters == null ? null : new String(autoActivationCharacters);
    }

    public int getAutoActivationDelay() {
        return this.autoActivationDelay;
    }

    public void setAutoActivationDelay(int delay) {
        this.autoActivationDelay = delay;
    }

    public int getProposalAcceptanceStyle() {
        return this.proposalAcceptanceStyle;
    }

    public void setProposalAcceptanceStyle(int acceptance) {
        this.proposalAcceptanceStyle = acceptance;
    }

    public int getFilterStyle() {
        return this.filterStyle;
    }

    public void setFilterStyle(int filterStyle) {
        this.filterStyle = filterStyle;
    }

    public Point getPopupSize() {
        return this.popupSize;
    }

    public void setPopupSize(Point size) {
        this.popupSize = size;
    }

    public boolean getPropagateKeys() {
        return this.propagateKeys;
    }

    public void setPropagateKeys(boolean propagateKeys) {
        this.propagateKeys = propagateKeys;
    }

    public IControlContentAdapter getControlContentAdapter() {
        return this.controlContentAdapter;
    }

    public void setEnabled(boolean enabled) {
        if (this.isEnabled && !enabled && this.popup != null) {
            this.popup.close();
        }
        this.isEnabled = enabled;
    }

    public void addContentProposalListener(IContentProposalListener listener) {
        this.proposalListeners.add((Object)listener);
    }

    public void removeContentProposalListener(IContentProposalListener listener) {
        this.proposalListeners.remove((Object)listener);
    }

    public void addContentProposalListener(IContentProposalListener2 listener) {
        this.proposalListeners2.add((Object)listener);
    }

    public void removeContentProposalListener(IContentProposalListener2 listener) {
        this.proposalListeners2.remove((Object)listener);
    }

    private void addControlListener(Control control) {
        if (this.controlListener != null) {
            return;
        }
        this.controlListener = new Listener(){

            public void handleEvent(Event e) {
                if (!ContentProposalAdapter2.this.isEnabled) {
                    return;
                }
                switch (e.type) {
                    case 1: 
                    case 31: {
                        if (ContentProposalAdapter2.this.popup != null) {
                            ContentProposalAdapter2.this.popup.getTargetControlListener().handleEvent(e);
                            if (ContentProposalAdapter2.this.propagateKeys && e.character != '\u0000') {
                                ContentProposalAdapter2.this.watchModify = true;
                            }
                            return;
                        }
                        if (e.type == 31) {
                            return;
                        }
                        if (ContentProposalAdapter2.this.triggerKeyStroke != null && (ContentProposalAdapter2.this.triggerKeyStroke.getModifierKeys() == 0 && ContentProposalAdapter2.this.triggerKeyStroke.getNaturalKey() == e.character || ContentProposalAdapter2.this.triggerKeyStroke.getNaturalKey() == e.keyCode && (ContentProposalAdapter2.this.triggerKeyStroke.getModifierKeys() & e.stateMask) == ContentProposalAdapter2.this.triggerKeyStroke.getModifierKeys())) {
                            e.doit = false;
                            ContentProposalAdapter2.this.openProposalPopup(false);
                            return;
                        }
                        if (e.character != '\u0000') {
                            if (ContentProposalAdapter2.this.autoActivateString != null) {
                                if (ContentProposalAdapter2.this.autoActivateString.indexOf(e.character) >= 0) {
                                    ContentProposalAdapter2.this.autoActivate();
                                    break;
                                }
                                ContentProposalAdapter2.this.receivedKeyDown = true;
                                ContentProposalAdapter2.this.watchModify = true;
                                break;
                            }
                            if (ContentProposalAdapter2.this.triggerKeyStroke != null) break;
                            ContentProposalAdapter2.this.watchModify = true;
                            break;
                        }
                        ContentProposalAdapter2.this.receivedKeyDown = true;
                        break;
                    }
                    case 24: {
                        if (!ContentProposalAdapter2.this.allowsAutoActivate() || !ContentProposalAdapter2.this.watchModify) break;
                        ContentProposalAdapter2.this.watchModify = false;
                        if (ContentProposalAdapter2.this.isControlContentEmpty()) {
                            ContentProposalAdapter2.this.closeProposalPopup();
                            break;
                        }
                        if (ContentProposalAdapter2.this.autoActivateString == null) {
                            ContentProposalAdapter2.this.autoActivate();
                            break;
                        }
                        if (ContentProposalAdapter2.this.shouldPopupRemainOpen()) break;
                        ContentProposalAdapter2.this.closeProposalPopup();
                        break;
                    }
                }
            }

            private void dump(String who, Event e) {
                StringBuffer sb = new StringBuffer("--- [ContentProposalAdapter]\n");
                sb.append(who);
                sb.append(" - e: keyCode=" + e.keyCode + this.hex(e.keyCode));
                sb.append("; character=" + e.character + this.hex(e.character));
                sb.append("; stateMask=" + e.stateMask + this.hex(e.stateMask));
                sb.append("; doit=" + e.doit);
                sb.append("; detail=" + e.detail + this.hex(e.detail));
                sb.append("; widget=" + e.widget);
                System.out.println(sb);
            }

            private String hex(int i) {
                return "[0x" + Integer.toHexString(i) + ']';
            }
        };
        control.addListener(1, this.controlListener);
        control.addListener(31, this.controlListener);
        control.addListener(24, this.controlListener);
    }

    private void openProposalPopup(boolean autoActivated) {
        if (this.isValid() && this.popup == null) {
            this.recordCursorPosition();
            IContentProposal[] proposals = this.getProposals();
            if (proposals.length > 0) {
                this.recordCursorPosition();
                this.popup = new ContentProposalPopup(this, null, proposals);
                this.popup.open();
                this.popup.getShell().addDisposeListener(new DisposeListener(){

                    public void widgetDisposed(DisposeEvent event) {
                        ContentProposalAdapter2.this.popup = null;
                    }
                });
                this.internalPopupOpened();
                this.notifyPopupOpened();
            } else if (!autoActivated) {
                this.getControl().getDisplay().beep();
            }
        }
    }

    protected void openProposalPopup() {
        this.openProposalPopup(false);
    }

    protected void closeProposalPopup() {
        if (this.popup != null) {
            this.popup.close();
        }
    }

    void proposalAccepted(IContentProposal proposal) {
        switch (this.proposalAcceptanceStyle) {
            case 2: {
                this.setControlContent(proposal.getContent(), proposal.getCursorPosition());
                break;
            }
            case 1: {
                this.insertControlContent(proposal.getContent(), proposal.getCursorPosition());
                break;
            }
        }
        this.notifyProposalAccepted(proposal);
    }

    private void setControlContent(String text, int cursorPosition) {
        if (this.isValid()) {
            this.watchModify = false;
            this.controlContentAdapter.setControlContents(this.control, text, cursorPosition);
        }
    }

    private void insertControlContent(String text, int cursorPosition) {
        if (this.isValid()) {
            this.watchModify = false;
            if (this.controlContentAdapter instanceof IControlContentAdapter2 && this.selectionRange.x != -1) {
                ((IControlContentAdapter2)this.controlContentAdapter).setSelection(this.control, this.selectionRange);
            } else if (this.insertionPos != -1) {
                this.controlContentAdapter.setCursorPosition(this.control, this.insertionPos);
            }
            this.controlContentAdapter.insertControlContents(this.control, text, cursorPosition);
        }
    }

    private boolean isValid() {
        return this.control != null && !this.control.isDisposed() && this.controlContentAdapter != null;
    }

    void recordCursorPosition() {
        if (this.isValid()) {
            IControlContentAdapter adapter = this.getControlContentAdapter();
            this.insertionPos = adapter.getCursorPosition(this.control);
            if (adapter instanceof IControlContentAdapter2) {
                this.selectionRange = ((IControlContentAdapter2)adapter).getSelection(this.control);
            }
        }
    }

    IContentProposal[] getProposals() {
        if (this.proposalProvider == null || !this.isValid()) {
            return null;
        }
        int position = this.insertionPos;
        if (position == -1) {
            position = this.getControlContentAdapter().getCursorPosition(this.getControl());
        }
        String contents = this.getControlContentAdapter().getControlContents(this.getControl());
        IContentProposal[] proposals = this.proposalProvider.getProposals(contents, position);
        return proposals;
    }

    private void autoActivate() {
        if (this.autoActivationDelay > 0) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    ContentProposalAdapter2.this.receivedKeyDown = false;
                    try {
                        Thread.sleep(ContentProposalAdapter2.this.autoActivationDelay);
                    }
                    catch (InterruptedException interruptedException) {}
                    if (!ContentProposalAdapter2.this.isValid() || ContentProposalAdapter2.this.receivedKeyDown) {
                        return;
                    }
                    ContentProposalAdapter2.this.getControl().getDisplay().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            ContentProposalAdapter2.this.openProposalPopup(true);
                        }
                    });
                }
            };
            Thread t = new Thread(runnable);
            t.start();
        } else {
            this.getControl().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (ContentProposalAdapter2.this.isValid()) {
                        ContentProposalAdapter2.this.openProposalPopup(true);
                    }
                }
            });
        }
    }

    private void notifyProposalAccepted(IContentProposal proposal) {
        Object[] listenerArray = this.proposalListeners.getListeners();
        int i = 0;
        while (i < listenerArray.length) {
            ((IContentProposalListener)listenerArray[i]).proposalAccepted(proposal);
            ++i;
        }
    }

    private void notifyPopupOpened() {
        Object[] listenerArray = this.proposalListeners2.getListeners();
        int i = 0;
        while (i < listenerArray.length) {
            ((IContentProposalListener3)listenerArray[i]).proposalPopupOpened(this);
            ++i;
        }
    }

    void notifyPopupClosed() {
        Object[] listenerArray = this.proposalListeners2.getListeners();
        int i = 0;
        while (i < listenerArray.length) {
            ((IContentProposalListener3)listenerArray[i]).proposalPopupClosed(this);
            ++i;
        }
    }

    public boolean hasProposalPopupFocus() {
        return this.popup != null && this.popup.hasFocus();
    }

    private boolean isControlContentEmpty() {
        return this.getControlContentAdapter().getControlContents(this.getControl()).length() == 0;
    }

    private void internalPopupOpened() {
        if (this.control instanceof Combo) {
            ((Combo)this.control).setListVisible(false);
        }
    }

    private boolean shouldPopupRemainOpen() {
        if (this.autoActivateString == null || this.autoActivateString.length() == 0) {
            return true;
        }
        String content = this.getControlContentAdapter().getControlContents(this.getControl());
        int i = 0;
        while (i < this.autoActivateString.length()) {
            if (content.indexOf(this.autoActivateString.charAt(i)) >= 0) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean allowsAutoActivate() {
        return this.autoActivateString != null && this.autoActivateString.length() > 0 || this.autoActivateString == null && this.triggerKeyStroke == null;
    }

    public void setProposalPopupFocus() {
        if (this.isValid() && this.popup != null) {
            this.popup.getShell().setFocus();
        }
    }

    public boolean isProposalPopupOpen() {
        return this.isValid() && this.popup != null;
    }

    public static interface IContentProposalListener3 {
        public void proposalPopupOpened(ContentProposalAdapter2 var1);

        public void proposalPopupClosed(ContentProposalAdapter2 var1);
    }
}

