/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.opencert.userguidance.autocomplete.proposalproviders;

import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.opencert.userguidance.autocomplete.ContentProposal2;
import org.eclipse.swt.graphics.Image;

public abstract class AbstractProposalProvider
implements IContentProposalProvider {
    private EObject eobj;
    private int featureID;
    private Image image;

    public AbstractProposalProvider(EObject eobj, int featureID) {
        this.eobj = eobj;
        this.featureID = featureID;
    }

    public IContentProposal[] getProposals(String contents, int position) {
        String stringToComplete = this.getStringToComplete(contents, position);
        List<ContentProposal2> proposals = this.createProposals(stringToComplete, this.eobj, this.featureID);
        for (ContentProposal2 prop : proposals) {
            prop.setImage(this.image);
        }
        IContentProposal[] result = proposals.toArray(new IContentProposal[proposals.size()]);
        return result;
    }

    protected String getStringToComplete(String contents, int caretOffset) {
        String beforeCaret = contents.substring(0, caretOffset);
        int postWhiteSpaceString = this.getLastWhiteSpace(beforeCaret, caretOffset);
        return beforeCaret.substring(postWhiteSpaceString + 1);
    }

    private int getLastWhiteSpace(String contents, int caretOffset) {
        int i = caretOffset - 1;
        while (i >= 0) {
            char c = contents.charAt(i);
            if (Character.isWhitespace(c)) {
                return i;
            }
            --i;
        }
        return -1;
    }

    protected abstract List<ContentProposal2> createProposals(String var1, EObject var2, int var3);

    public Image getImage() {
        if (this.image == null) {
            this.image = this.createImage();
        }
        return this.image;
    }

    protected abstract Image createImage();
}

