/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.opencert.userguidance.labelparser;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.opencert.userguidance.labelparser.LabelParserUtil;
import org.eclipse.opencert.userguidance.labelparser.tokens.HighlightItem;
import org.eclipse.opencert.userguidance.labelparser.tokens.TextToken;
import org.eclipse.opencert.userguidance.labelparser.tokens.Token;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;

public abstract class Highlighter {
    private static final Color idColor = new Color(null, 185, 50, 96);
    private static final Color pathColor = new Color(null, 87, 173, 143);
    private static final Color uriColor = new Color(null, 70, 70, 250);
    private static final Color varColor = new Color(null, 130, 110, 30);
    private static final Color vocColor = new Color(null, 100, 100, 100);
    private final String inputText;
    private final Font normalFont;
    private final Font boldFont;
    private String outputText;
    private List<StyleRange> styles;
    private List<Token> tokens;

    public Highlighter(String input, Font normalFont, Font boldFont) {
        this.inputText = input;
        this.normalFont = normalFont;
        this.boldFont = boldFont;
    }

    public void calculateHighlighting() {
        this.tokens = LabelParserUtil.parse(this.inputText);
        this.styles = new ArrayList<StyleRange>(this.tokens.size());
        StringBuilder outputTextBuilder = new StringBuilder();
        int truncationOffset = 0;
        if (this.tokens != null) {
            for (Token token : this.tokens) {
                String tokenRepresentation;
                if (token instanceof HighlightItem) {
                    HighlightItem item = (HighlightItem)token;
                    tokenRepresentation = this.getRepresentation(item);
                    outputTextBuilder.append(tokenRepresentation);
                    StyleRange styleRange = new StyleRange();
                    styleRange.start = item.getStartIndex() - truncationOffset;
                    styleRange.length = tokenRepresentation.length();
                    styleRange.foreground = this.getHighlightColor(item.getHeaderType());
                    styleRange.font = this.getHighlightFont(item.getHeaderType());
                    styleRange.underline = this.isUnderlined(item.getHeaderType());
                    this.styles.add(styleRange);
                    truncationOffset += item.getRawString().length() - tokenRepresentation.length();
                    continue;
                }
                if (!(token instanceof TextToken)) continue;
                TextToken textToken = (TextToken)token;
                tokenRepresentation = textToken.getRepresentation();
                outputTextBuilder.append(tokenRepresentation);
            }
        }
        this.outputText = outputTextBuilder.toString();
    }

    public String getOutputText() {
        return this.outputText;
    }

    public List<StyleRange> getStyles() {
        return this.styles;
    }

    public StyleRange[] getStylesArray() {
        StyleRange[] stylesArray = this.styles.toArray(new StyleRange[this.styles.size()]);
        return stylesArray;
    }

    public List<Token> getTokens() {
        return this.tokens;
    }

    protected Color getHighlightColor(HighlightItem.ItemHeaderType type) {
        Color result = null;
        switch (type) {
            case id: {
                result = idColor;
                break;
            }
            case path: {
                result = pathColor;
                break;
            }
            case uri: {
                result = uriColor;
                break;
            }
            case var: {
                result = varColor;
                break;
            }
            case voc: {
                result = vocColor;
                break;
            }
            default: {
                result = ColorConstants.black;
            }
        }
        return result;
    }

    protected Font getHighlightFont(HighlightItem.ItemHeaderType type) {
        Font result = null;
        switch (type) {
            case id: {
                result = this.boldFont;
                break;
            }
            case path: {
                result = this.boldFont;
                break;
            }
            case uri: {
                result = this.boldFont;
                break;
            }
            case var: {
                result = this.boldFont;
                break;
            }
            case voc: {
                result = this.boldFont;
                break;
            }
            default: {
                result = this.normalFont;
            }
        }
        return result;
    }

    protected boolean isUnderlined(HighlightItem.ItemHeaderType type) {
        boolean result;
        switch (type) {
            case id: {
                result = false;
                break;
            }
            case path: {
                result = true;
                break;
            }
            case uri: {
                result = true;
                break;
            }
            case var: {
                result = false;
                break;
            }
            case voc: {
                result = false;
                break;
            }
            default: {
                result = false;
            }
        }
        return result;
    }

    protected abstract String getRepresentation(HighlightItem var1);
}

