/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.opencert.userguidance.util;

import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.opencert.infra.ui.loadresource.EditorTypeUtil;
import org.eclipse.opencert.userguidance.util.CdoConnection;
import org.eclipse.opencert.userguidance.util.CdoUtil;
import org.eclipse.opencert.userguidance.util.FileUtil;
import org.eclipse.opencert.vocabulary.Vocabulary;
import org.eclipse.opencert.vocabulary.VocabularyPackage;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;

public abstract class VocabFetcher {
    public void execute() {
        List<EObject> vocabularies = null;
        CdoConnection connection = null;
        try {
            IEditorPart editor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
            if (editor != null) {
                if (EditorTypeUtil.isFileEditor((IEditorPart)editor)) {
                    vocabularies = FileUtil.fetch("vocabulary");
                    this.readFromVocab(vocabularies);
                } else {
                    connection = new CdoConnection();
                    vocabularies = CdoUtil.fetch(connection, VocabularyPackage.eINSTANCE.getVocabulary(), true);
                    this.readFromVocab(vocabularies);
                    connection.dispose();
                }
            }
        }
        finally {
            if (connection != null) {
                connection.dispose();
            }
        }
    }

    protected abstract void readFromVocab(List<Vocabulary> var1);
}

