/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.db.mapping.horizontal;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDUtil;
import org.eclipse.emf.cdo.common.revision.CDOList;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.common.revision.CDORevisionUtil;
import org.eclipse.emf.cdo.common.revision.delta.CDOAddFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDOClearFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDOContainerFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDOFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDOFeatureDeltaVisitor;
import org.eclipse.emf.cdo.common.revision.delta.CDOListFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDOMoveFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDORemoveFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDOSetFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDOUnsetFeatureDelta;
import org.eclipse.emf.cdo.server.IStoreAccessor;
import org.eclipse.emf.cdo.server.IStoreChunkReader;
import org.eclipse.emf.cdo.server.db.IDBStore;
import org.eclipse.emf.cdo.server.db.IDBStoreAccessor;
import org.eclipse.emf.cdo.server.db.IDBStoreChunkReader;
import org.eclipse.emf.cdo.server.db.IIDHandler;
import org.eclipse.emf.cdo.server.db.mapping.IListMappingDeltaSupport;
import org.eclipse.emf.cdo.server.db.mapping.IMappingStrategy;
import org.eclipse.emf.cdo.server.db.mapping.ITypeMapping;
import org.eclipse.emf.cdo.server.internal.db.bundle.OM;
import org.eclipse.emf.cdo.server.internal.db.mapping.horizontal.AbstractBasicListTableMapping;
import org.eclipse.emf.cdo.spi.common.branch.InternalCDOBranchManager;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevisionManager;
import org.eclipse.emf.cdo.spi.server.InternalRepository;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.net4j.db.DBException;
import org.eclipse.net4j.db.DBType;
import org.eclipse.net4j.db.DBUtil;
import org.eclipse.net4j.db.IDBDatabase;
import org.eclipse.net4j.db.IDBPreparedStatement;
import org.eclipse.net4j.db.IDBResultSet;
import org.eclipse.net4j.db.ddl.IDBIndex;
import org.eclipse.net4j.db.ddl.IDBTable;
import org.eclipse.net4j.util.ImplementationError;
import org.eclipse.net4j.util.om.trace.ContextTracer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BranchingFeatureMapTableMappingWithRanges
extends AbstractBasicListTableMapping
implements IListMappingDeltaSupport {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG, BranchingFeatureMapTableMappingWithRanges.class);
    private static final int FINAL_VERSION = Integer.MAX_VALUE;
    private IDBTable table;
    private Map<CDOID, String> tagMap;
    private List<String> columnNames;
    private Map<CDOID, ITypeMapping> typeMappings;
    private List<DBType> dbTypes;
    private String sqlSelectChunksPrefix;
    private String sqlOrderByIndex;
    private String sqlInsert;
    private String sqlRemoveEntry;
    private String sqlDeleteEntry;
    private String sqlUpdateIndex;
    private String sqlGetValue;
    private String sqlClearList;

    public BranchingFeatureMapTableMappingWithRanges(IMappingStrategy mappingStrategy, EClass eClass, EStructuralFeature feature) {
        super(mappingStrategy, eClass, feature);
        this.initDBTypes();
        this.initTable();
        this.initSQLStrings();
    }

    private void initDBTypes() {
        ITypeMapping.Registry registry = ITypeMapping.Registry.INSTANCE;
        this.dbTypes = new ArrayList<DBType>(registry.getDefaultFeatureMapDBTypes());
    }

    private void initTable() {
        String tableName = this.getMappingStrategy().getTableName(this.getContainingClass(), this.getFeature());
        IDBStore store = this.getMappingStrategy().getStore();
        DBType idType = store.getIDHandler().getDBType();
        int idLength = store.getIDColumnLength();
        IDBDatabase database = this.getMappingStrategy().getStore().getDatabase();
        this.table = database.getSchema().getTable(tableName);
        if (this.table == null) {
            this.table = database.getSchemaTransaction().getWorkingCopy().addTable(tableName);
            this.table.addField("CDO_SOURCE", idType, idLength);
            this.table.addField("CDO_BRANCH", DBType.INTEGER);
            this.table.addField("CDO_VERSION_ADDED", DBType.INTEGER);
            this.table.addField("CDO_VERSION_REMOVED", DBType.INTEGER);
            this.table.addField("CDO_IDX", DBType.INTEGER);
            this.table.addField("CDO_FEATURE", idType, idLength);
            this.tagMap = CDOIDUtil.createMap();
            this.typeMappings = CDOIDUtil.createMap();
            this.columnNames = new ArrayList<String>();
            this.initTypeColumns(true);
            this.table.addIndex(IDBIndex.Type.NON_UNIQUE, new String[]{"CDO_SOURCE"});
            this.table.addIndex(IDBIndex.Type.NON_UNIQUE, new String[]{"CDO_BRANCH"});
            this.table.addIndex(IDBIndex.Type.NON_UNIQUE, new String[]{"CDO_VERSION_ADDED"});
            this.table.addIndex(IDBIndex.Type.NON_UNIQUE, new String[]{"CDO_VERSION_REMOVED"});
            this.table.addIndex(IDBIndex.Type.NON_UNIQUE, new String[]{"CDO_IDX"});
            this.table.addIndex(IDBIndex.Type.NON_UNIQUE, new String[]{"CDO_FEATURE"});
        } else {
            this.initTypeColumns(false);
        }
    }

    private void initTypeColumns(boolean create) {
        for (DBType type : this.getDBTypes()) {
            String column = "CDO_VALUE_" + type.name();
            if (create) {
                this.table.addField(column, type);
            }
            this.columnNames.add(column);
        }
    }

    private void initSQLStrings() {
        String tableName = this.getTable().getName();
        StringBuilder builder = new StringBuilder();
        builder.append("SELECT ");
        builder.append("CDO_IDX");
        builder.append(", ");
        builder.append("CDO_FEATURE");
        builder.append(", ");
        Iterator<String> iter = this.columnNames.iterator();
        while (iter.hasNext()) {
            builder.append(iter.next());
            if (!iter.hasNext()) continue;
            builder.append(", ");
        }
        builder.append(" FROM ");
        builder.append(tableName);
        builder.append(" WHERE ");
        builder.append("CDO_SOURCE");
        builder.append("=? AND ");
        builder.append("CDO_BRANCH");
        builder.append("=? AND ");
        builder.append("CDO_VERSION_ADDED");
        builder.append("<=? AND (");
        builder.append("CDO_VERSION_REMOVED");
        builder.append(" IS NULL OR ");
        builder.append("CDO_VERSION_REMOVED");
        builder.append(">?)");
        this.sqlSelectChunksPrefix = builder.toString();
        this.sqlOrderByIndex = " ORDER BY CDO_IDX";
        builder = new StringBuilder("INSERT INTO ");
        builder.append(tableName);
        builder.append("(");
        builder.append("CDO_SOURCE");
        builder.append(", ");
        builder.append("CDO_BRANCH");
        builder.append(", ");
        builder.append("CDO_VERSION_ADDED");
        builder.append(", ");
        builder.append("CDO_VERSION_REMOVED");
        builder.append(", ");
        builder.append("CDO_IDX");
        builder.append(", ");
        builder.append("CDO_FEATURE");
        int i = 0;
        while (i < this.columnNames.size()) {
            builder.append(", ");
            builder.append(this.columnNames.get(i));
            ++i;
        }
        builder.append(") VALUES (?, ?, ?, ?, ?, ?");
        i = 0;
        while (i < this.columnNames.size()) {
            builder.append(", ?");
            ++i;
        }
        builder.append(")");
        this.sqlInsert = builder.toString();
        builder = new StringBuilder("UPDATE ");
        builder.append(tableName);
        builder.append(" SET ");
        builder.append("CDO_VERSION_REMOVED");
        builder.append("=? ");
        builder.append(" WHERE ");
        builder.append("CDO_SOURCE");
        builder.append("=? AND ");
        builder.append("CDO_BRANCH");
        builder.append("=? AND ");
        builder.append("CDO_IDX");
        builder.append("=? AND ");
        builder.append("CDO_VERSION_REMOVED");
        builder.append(" IS NULL");
        this.sqlRemoveEntry = builder.toString();
        builder = new StringBuilder("DELETE FROM ");
        builder.append(tableName);
        builder.append(" WHERE ");
        builder.append("CDO_SOURCE");
        builder.append("=? AND ");
        builder.append("CDO_BRANCH");
        builder.append("=? AND ");
        builder.append("CDO_IDX");
        builder.append("=? AND ");
        builder.append("CDO_VERSION_ADDED");
        builder.append("=?");
        this.sqlDeleteEntry = builder.toString();
        builder = new StringBuilder("UPDATE ");
        builder.append(tableName);
        builder.append(" SET ");
        builder.append("CDO_IDX");
        builder.append("=? WHERE ");
        builder.append("CDO_SOURCE");
        builder.append("=? AND ");
        builder.append("CDO_BRANCH");
        builder.append("=? AND ");
        builder.append("CDO_VERSION_ADDED");
        builder.append("=? AND ");
        builder.append("CDO_IDX");
        builder.append("=?");
        this.sqlUpdateIndex = builder.toString();
        builder = new StringBuilder("SELECT ");
        builder.append("CDO_FEATURE");
        builder.append(", ");
        iter = this.columnNames.iterator();
        while (iter.hasNext()) {
            builder.append(iter.next());
            if (!iter.hasNext()) continue;
            builder.append(", ");
        }
        builder.append(" FROM ");
        builder.append(tableName);
        builder.append(" WHERE ");
        builder.append("CDO_SOURCE");
        builder.append("=? AND ");
        builder.append("CDO_BRANCH");
        builder.append("=? AND ");
        builder.append("CDO_IDX");
        builder.append("=? AND ");
        builder.append("CDO_VERSION_REMOVED");
        builder.append(" IS NULL");
        this.sqlGetValue = builder.toString();
        builder = new StringBuilder("UPDATE ");
        builder.append(tableName);
        builder.append(" SET ");
        builder.append("CDO_VERSION_REMOVED");
        builder.append("=? ");
        builder.append(" WHERE ");
        builder.append("CDO_SOURCE");
        builder.append("=? AND ");
        builder.append("CDO_BRANCH");
        builder.append("=? AND ");
        builder.append("CDO_VERSION_REMOVED");
        builder.append(" IS NULL");
        this.sqlClearList = builder.toString();
    }

    @Override
    public Collection<IDBTable> getDBTables() {
        return Collections.singleton(this.table);
    }

    protected List<DBType> getDBTypes() {
        return this.dbTypes;
    }

    protected final IDBTable getTable() {
        return this.table;
    }

    protected final List<String> getColumnNames() {
        return this.columnNames;
    }

    protected final Map<CDOID, ITypeMapping> getTypeMappings() {
        return this.typeMappings;
    }

    protected final Map<CDOID, String> getTagMap() {
        return this.tagMap;
    }

    @Override
    public void readValues(IDBStoreAccessor accessor, InternalCDORevision revision, int listChunk) {
        CDOList list = revision.getList(this.getFeature());
        int valuesToRead = list.size();
        if (listChunk != -1 && listChunk < valuesToRead) {
            valuesToRead = listChunk;
        }
        if (valuesToRead == 0) {
            return;
        }
        if (TRACER.isEnabled()) {
            TRACER.format("Reading list values for feature {0}.{1} of {2}", new Object[]{this.getContainingClass().getName(), this.getFeature().getName(), revision});
        }
        String sql = String.valueOf(this.sqlSelectChunksPrefix) + this.sqlOrderByIndex;
        IIDHandler idHandler = this.getMappingStrategy().getStore().getIDHandler();
        IDBPreparedStatement stmt = accessor.getDBConnection().prepareStatement(sql, IDBPreparedStatement.ReuseProbability.HIGH);
        IDBResultSet resultSet = null;
        IStoreChunkReader baseReader = null;
        try {
            try {
                CDOID id = revision.getID();
                int branchID = revision.getBranch().getID();
                idHandler.setCDOID((PreparedStatement)stmt, 1, id);
                stmt.setInt(2, branchID);
                stmt.setInt(3, revision.getVersion());
                stmt.setInt(4, revision.getVersion());
                stmt.setMaxRows(valuesToRead);
                resultSet = stmt.executeQuery();
                int currentIndex = 0;
                while (valuesToRead > 0 && resultSet.next()) {
                    int index = resultSet.getInt(1);
                    if (index > currentIndex) {
                        if (baseReader == null) {
                            baseReader = this.createBaseChunkReader(accessor, id, branchID);
                        }
                        baseReader.addRangedChunk(currentIndex, index);
                        if (TRACER.isEnabled()) {
                            TRACER.format("Scheduling range {0}-{1} to be read from base revision", new Object[]{currentIndex, index});
                        }
                        valuesToRead -= index - currentIndex;
                        currentIndex = index;
                    }
                    CDOID tag = idHandler.getCDOID((ResultSet)resultSet, 2);
                    Object value = this.getTypeMapping(tag).readValue((ResultSet)resultSet);
                    if (TRACER.isEnabled()) {
                        TRACER.format("Read value for index {0} from result set: {1}", new Object[]{currentIndex, value});
                    }
                    list.set(currentIndex++, (Object)CDORevisionUtil.createFeatureMapEntry((EStructuralFeature)this.getFeatureByTag(tag), (Object)value));
                    --valuesToRead;
                }
                if (valuesToRead > 0) {
                    if (baseReader == null) {
                        baseReader = this.createBaseChunkReader(accessor, id, branchID);
                    }
                    baseReader.addRangedChunk(currentIndex, currentIndex + valuesToRead);
                }
            }
            catch (SQLException ex) {
                throw new DBException((Throwable)ex);
            }
        }
        catch (Throwable throwable) {
            DBUtil.close(resultSet);
            DBUtil.close((Statement)stmt);
            throw throwable;
        }
        DBUtil.close((ResultSet)resultSet);
        DBUtil.close((Statement)stmt);
        if (baseReader != null) {
            if (TRACER.isEnabled()) {
                TRACER.format("Reading base revision chunks for featureMap {0}.{1} of {2} from base revision {3}", new Object[]{this.getContainingClass().getName(), this.getFeature().getName(), revision, baseReader.getRevision()});
            }
            List baseChunks = baseReader.executeRead();
            for (IStoreChunkReader.Chunk chunk : baseChunks) {
                int startIndex = chunk.getStartIndex();
                int i = 0;
                while (i < chunk.size()) {
                    list.set(startIndex + i, chunk.get(i));
                    ++i;
                }
            }
        }
        if (TRACER.isEnabled()) {
            TRACER.format("Reading list values done for feature {0}.{1} of {2}", new Object[]{this.getContainingClass().getName(), this.getFeature().getName(), revision});
        }
    }

    @Override
    public final void readChunks(IDBStoreChunkReader chunkReader, List<IStoreChunkReader.Chunk> chunks, String where) {
        CDORevision revision = chunkReader.getRevision();
        if (TRACER.isEnabled()) {
            TRACER.format("Reading list chunk values for feature {0}.{1} of {2}", new Object[]{this.getContainingClass().getName(), this.getFeature().getName(), revision});
        }
        StringBuilder builder = new StringBuilder(this.sqlSelectChunksPrefix);
        if (where != null) {
            builder.append(" AND ");
            builder.append(where);
        }
        builder.append(this.sqlOrderByIndex);
        String sql = builder.toString();
        IIDHandler idHandler = this.getMappingStrategy().getStore().getIDHandler();
        IDBPreparedStatement stmt = chunkReader.getAccessor().getDBConnection().prepareStatement(sql, IDBPreparedStatement.ReuseProbability.LOW);
        IDBResultSet resultSet = null;
        IStoreChunkReader baseReader = null;
        try {
            try {
                idHandler.setCDOID((PreparedStatement)stmt, 1, revision.getID());
                stmt.setInt(2, revision.getBranch().getID());
                stmt.setInt(3, revision.getVersion());
                stmt.setInt(4, revision.getVersion());
                resultSet = stmt.executeQuery();
                int nextDBIndex = Integer.MAX_VALUE;
                if (resultSet.next()) {
                    nextDBIndex = resultSet.getInt(1);
                }
                for (IStoreChunkReader.Chunk chunk : chunks) {
                    int startIndex = chunk.getStartIndex();
                    int missingValueStartIndex = -1;
                    int i = 0;
                    while (i < chunk.size()) {
                        int nextListIndex = startIndex + i;
                        if (nextDBIndex == nextListIndex) {
                            if (missingValueStartIndex != -1) {
                                if (baseReader == null) {
                                    baseReader = this.createBaseChunkReader(chunkReader.getAccessor(), chunkReader.getRevision().getID(), chunkReader.getRevision().getBranch().getID());
                                }
                                if (TRACER.isEnabled()) {
                                    TRACER.format("Scheduling range {0}-{1} to be read from base revision", new Object[]{missingValueStartIndex, nextListIndex});
                                }
                                baseReader.addRangedChunk(missingValueStartIndex, nextListIndex);
                                missingValueStartIndex = -1;
                            }
                            CDOID tag = idHandler.getCDOID((ResultSet)resultSet, 2);
                            Object value = this.getTypeMapping(tag).readValue((ResultSet)resultSet);
                            if (TRACER.isEnabled()) {
                                TRACER.format("ChunkReader read value for index {0} from result set: {1}", new Object[]{nextDBIndex, value});
                            }
                            chunk.add(i, (Object)CDORevisionUtil.createFeatureMapEntry((EStructuralFeature)this.getFeatureByTag(tag), (Object)value));
                            nextDBIndex = resultSet.next() ? resultSet.getInt(1) : Integer.MAX_VALUE;
                        } else if (missingValueStartIndex == -1) {
                            missingValueStartIndex = nextListIndex;
                        }
                        ++i;
                    }
                    if (missingValueStartIndex == -1) continue;
                    if (baseReader == null) {
                        baseReader = this.createBaseChunkReader(chunkReader.getAccessor(), chunkReader.getRevision().getID(), chunkReader.getRevision().getBranch().getID());
                    }
                    baseReader.addRangedChunk(missingValueStartIndex, chunk.getStartIndex() + chunk.size());
                }
            }
            catch (SQLException ex) {
                throw new DBException((Throwable)ex);
            }
        }
        catch (Throwable throwable) {
            DBUtil.close(resultSet);
            DBUtil.close((Statement)stmt);
            throw throwable;
        }
        DBUtil.close((ResultSet)resultSet);
        DBUtil.close((Statement)stmt);
        if (baseReader != null) {
            List baseChunks = baseReader.executeRead();
            Iterator<IStoreChunkReader.Chunk> thisIterator = chunks.iterator();
            IStoreChunkReader.Chunk thisChunk = thisIterator.next();
            for (IStoreChunkReader.Chunk baseChunk : baseChunks) {
                int baseStartIndex = baseChunk.getStartIndex();
                while (baseStartIndex > thisChunk.getStartIndex() + thisChunk.size()) {
                    thisChunk = thisIterator.next();
                }
                int offset = thisChunk.getStartIndex() - baseStartIndex;
                int i = 0;
                while (i < baseChunk.size()) {
                    thisChunk.add(i + offset, baseChunk.get(i));
                    ++i;
                }
            }
        }
        if (TRACER.isEnabled()) {
            TRACER.format("Reading list chunk values done for feature {0}.{1} of {2}", new Object[]{this.getContainingClass().getName(), this.getFeature(), revision});
        }
    }

    @Override
    public void writeValues(IDBStoreAccessor accessor, InternalCDORevision revision) {
        CDOList values = revision.getList(this.getFeature());
        int idx = 0;
        for (Object element : values) {
            this.writeValue(accessor, (CDORevision)revision, idx++, element);
        }
        if (TRACER.isEnabled()) {
            TRACER.format("Writing done", new Object[0]);
        }
    }

    protected final void writeValue(IDBStoreAccessor accessor, CDORevision revision, int idx, Object value) {
        if (TRACER.isEnabled()) {
            TRACER.format("Writing value for feature {0}.{1} index {2} of {3} : {4}", new Object[]{this.getContainingClass().getName(), this.getFeature(), idx, revision, value});
        }
        this.addEntry(accessor, revision.getID(), revision.getBranch().getID(), revision.getVersion(), idx, value, revision.getTimeStamp());
    }

    protected String getColumnName(CDOID tag) {
        String column = this.tagMap.get(tag);
        if (column == null) {
            this.addFeature(tag);
            column = this.tagMap.get(tag);
        }
        return column;
    }

    protected ITypeMapping getTypeMapping(CDOID tag) {
        ITypeMapping typeMapping = this.typeMappings.get(tag);
        if (typeMapping == null) {
            this.addFeature(tag);
            typeMapping = this.typeMappings.get(tag);
        }
        return typeMapping;
    }

    private void addFeature(CDOID tag) {
        EStructuralFeature modelFeature = this.getFeatureByTag(tag);
        ITypeMapping typeMapping = this.getMappingStrategy().createValueMapping(modelFeature);
        String column = "CDO_VALUE_" + typeMapping.getDBType();
        this.tagMap.put(tag, column);
        typeMapping.setDBField(this.table, column);
        this.typeMappings.put(tag, typeMapping);
    }

    private EStructuralFeature getFeatureByTag(CDOID tag) {
        return (EStructuralFeature)this.getMappingStrategy().getStore().getMetaDataManager().getMetaInstance(tag);
    }

    protected CDOID getTagByFeature(EStructuralFeature feature, long created) {
        return this.getMappingStrategy().getStore().getMetaDataManager().getMetaID((EModelElement)feature, created);
    }

    public void clearList(IDBStoreAccessor accessor, CDOID id, int branchId, int oldVersion, int newVersion, int lastIndex, long timestamp) {
        int i = 0;
        while (i <= lastIndex) {
            if (this.getValue(accessor, id, branchId, i, false) == null) {
                this.addHistoricEntry(accessor, id, branchId, 0, newVersion, i, this.getValueFromBase(accessor, id, branchId, i), timestamp);
            }
            ++i;
        }
        IIDHandler idHandler = this.getMappingStrategy().getStore().getIDHandler();
        IDBPreparedStatement stmt = accessor.getDBConnection().prepareStatement(this.sqlClearList, IDBPreparedStatement.ReuseProbability.HIGH);
        try {
            try {
                stmt.setInt(1, newVersion);
                idHandler.setCDOID((PreparedStatement)stmt, 2, id);
                stmt.setInt(3, branchId);
                int result = DBUtil.update((PreparedStatement)stmt, (boolean)false);
                if (TRACER.isEnabled()) {
                    TRACER.format("ClearList result: {0}", new Object[]{result});
                }
            }
            catch (SQLException e) {
                throw new DBException((Throwable)e);
            }
        }
        finally {
            DBUtil.close((Statement)stmt);
        }
    }

    @Override
    public void objectDetached(IDBStoreAccessor accessor, CDOID id, long revised) {
        InternalCDORevision revision = (InternalCDORevision)accessor.getTransaction().getRevision(id);
        int branchId = accessor.getTransaction().getBranch().getID();
        if (TRACER.isEnabled()) {
            TRACER.format("objectDetached {1}", new Object[]{revision});
        }
        this.clearList(accessor, id, branchId, revision.getVersion(), Integer.MAX_VALUE, revision.getList(this.getFeature()).size() - 1, revised);
    }

    @Override
    public void rawDeleted(IDBStoreAccessor accessor, CDOID id, CDOBranch branch, int version) {
        throw new UnsupportedOperationException("Raw deletion does not work in range-based mappings");
    }

    @Override
    public void processDelta(IDBStoreAccessor accessor, CDOID id, int branchId, int oldVersion, int newVersion, long created, CDOListFeatureDelta delta) {
        List listChanges = delta.getListChanges();
        if (listChanges.size() == 0) {
            return;
        }
        InternalCDORevision originalRevision = (InternalCDORevision)accessor.getTransaction().getRevision(id);
        int oldListSize = originalRevision.getList(this.getFeature()).size();
        if (TRACER.isEnabled()) {
            TRACER.format("ListTableMapping.processDelta for revision {0} - previous list size: {1}", new Object[]{originalRevision, oldListSize});
        }
        ListDeltaVisitor visitor = new ListDeltaVisitor(accessor, originalRevision, branchId, oldVersion, newVersion, created);
        if (TRACER.isEnabled()) {
            TRACER.format("Processing deltas...", new Object[0]);
        }
        int index = listChanges.size() - 1;
        while (index > 0) {
            CDOFeatureDelta listDelta = (CDOFeatureDelta)listChanges.get(index);
            if (listDelta instanceof CDOClearFeatureDelta || listDelta instanceof CDOUnsetFeatureDelta) break;
            --index;
        }
        while (index < listChanges.size()) {
            ((CDOFeatureDelta)listChanges.get(index++)).accept((CDOFeatureDeltaVisitor)visitor);
        }
    }

    private void addEntry(IDBStoreAccessor accessor, CDOID id, int branchId, int version, int index, Object value, long timestamp) {
        if (TRACER.isEnabled()) {
            TRACER.format("Adding value for feature() {0}.{1} index {2} of {3}v{4} : {5}", new Object[]{this.getContainingClass().getName(), this.getFeature().getName(), index, id, version, value});
        }
        FeatureMap.Entry entry = (FeatureMap.Entry)value;
        EStructuralFeature entryFeature = entry.getEStructuralFeature();
        CDOID tag = this.getTagByFeature(entryFeature, timestamp);
        String columnName = this.getColumnName(tag);
        IIDHandler idHandler = this.getMappingStrategy().getStore().getIDHandler();
        IDBPreparedStatement stmt = accessor.getDBConnection().prepareStatement(this.sqlInsert, IDBPreparedStatement.ReuseProbability.HIGH);
        try {
            try {
                int column = 1;
                idHandler.setCDOID((PreparedStatement)stmt, column++, id);
                stmt.setInt(column++, branchId);
                stmt.setInt(column++, version);
                stmt.setNull(column++, DBType.INTEGER.getCode());
                stmt.setInt(column++, index);
                idHandler.setCDOID((PreparedStatement)stmt, column++, tag);
                int i = 0;
                while (i < this.columnNames.size()) {
                    if (this.columnNames.get(i).equals(columnName)) {
                        this.getTypeMapping(tag).setValue((PreparedStatement)stmt, column++, entry.getValue());
                    } else {
                        stmt.setNull(column++, this.getDBTypes().get(i).getCode());
                    }
                    ++i;
                }
                DBUtil.update((PreparedStatement)stmt, (boolean)true);
            }
            catch (SQLException e) {
                throw new DBException((Throwable)e);
            }
            catch (IllegalStateException e) {
                throw new DBException((Throwable)e);
            }
        }
        finally {
            DBUtil.close((Statement)stmt);
        }
    }

    private void addHistoricEntry(IDBStoreAccessor accessor, CDOID id, int branchId, int versionAdded, int versionRemoved, int index, Object value, long timestamp) {
        if (TRACER.isEnabled()) {
            TRACER.format("Adding historic value for feature {0}.{1} index {2} of {3}:{4}v{5}-v{6} : {7}", new Object[]{this.getContainingClass().getName(), this.getFeature().getName(), index, id, branchId, versionAdded, versionRemoved, value});
        }
        FeatureMap.Entry entry = (FeatureMap.Entry)value;
        EStructuralFeature entryFeature = entry.getEStructuralFeature();
        CDOID tag = this.getTagByFeature(entryFeature, timestamp);
        ITypeMapping typeMapping = this.getTypeMapping(tag);
        String columnName = this.getColumnName(tag);
        IIDHandler idHandler = this.getMappingStrategy().getStore().getIDHandler();
        IDBPreparedStatement stmt = accessor.getDBConnection().prepareStatement(this.sqlInsert, IDBPreparedStatement.ReuseProbability.HIGH);
        try {
            try {
                int column = 1;
                idHandler.setCDOID((PreparedStatement)stmt, column++, id);
                stmt.setInt(column++, branchId);
                stmt.setInt(column++, versionAdded);
                stmt.setNull(column++, versionRemoved);
                stmt.setInt(column++, index);
                idHandler.setCDOID((PreparedStatement)stmt, column++, tag);
                int i = 0;
                while (i < this.columnNames.size()) {
                    if (this.columnNames.get(i).equals(columnName)) {
                        typeMapping.setValue((PreparedStatement)stmt, column++, entry.getValue());
                    } else {
                        stmt.setNull(column++, this.getDBTypes().get(i).getCode());
                    }
                    ++i;
                }
                DBUtil.update((PreparedStatement)stmt, (boolean)true);
            }
            catch (SQLException e) {
                throw new DBException((Throwable)e);
            }
            catch (IllegalStateException e) {
                throw new DBException((Throwable)e);
            }
        }
        finally {
            DBUtil.close((Statement)stmt);
        }
    }

    private void removeEntry(IDBStoreAccessor accessor, CDOID id, int branchId, int oldVersion, int newVersion, int index, long timestamp) {
        if (TRACER.isEnabled()) {
            TRACER.format("Removing value for feature() {0}.{1} index {2} of {3}v{4}", new Object[]{this.getContainingClass().getName(), this.getFeature().getName(), index, id, newVersion});
        }
        IIDHandler idHandler = this.getMappingStrategy().getStore().getIDHandler();
        IDBPreparedStatement stmt = accessor.getDBConnection().prepareStatement(this.sqlDeleteEntry, IDBPreparedStatement.ReuseProbability.HIGH);
        try {
            try {
                int column = 1;
                idHandler.setCDOID((PreparedStatement)stmt, column++, id);
                stmt.setInt(column++, branchId);
                stmt.setInt(column++, index);
                stmt.setInt(column++, newVersion);
                int result = DBUtil.update((PreparedStatement)stmt, (boolean)false);
                if (result == 1) {
                    if (TRACER.isEnabled()) {
                        TRACER.format("removeEntry deleted: {0}", new Object[]{index});
                    }
                } else {
                    if (result > 1) {
                        if (TRACER.isEnabled()) {
                            TRACER.format("removeEntry Too many results: {0}: {1}", new Object[]{index, result});
                        }
                        throw new DBException("Too many results");
                    }
                    DBUtil.close((Statement)stmt);
                    stmt = accessor.getDBConnection().prepareStatement(this.sqlRemoveEntry, IDBPreparedStatement.ReuseProbability.HIGH);
                    column = 1;
                    stmt.setInt(column++, newVersion);
                    idHandler.setCDOID((PreparedStatement)stmt, column++, id);
                    stmt.setInt(column++, branchId);
                    stmt.setInt(column++, index);
                    result = DBUtil.update((PreparedStatement)stmt, (boolean)false);
                    if (result == 0) {
                        FeatureMap.Entry value = this.getValueFromBase(accessor, id, branchId, index);
                        this.addHistoricEntry(accessor, id, branchId, 0, newVersion, index, value, timestamp);
                    }
                }
            }
            catch (SQLException e) {
                if (TRACER.isEnabled()) {
                    TRACER.format("Removing value for feature() {0}.{1} index {2} of {3}v{4} FAILED {5}", new Object[]{this.getContainingClass().getName(), this.getFeature().getName(), index, id, newVersion, e.getMessage()});
                }
                throw new DBException((Throwable)e);
            }
            catch (IllegalStateException e) {
                if (TRACER.isEnabled()) {
                    TRACER.format("Removing value for feature() {0}.{1} index {2} of {3}v{4} FAILED {5}", new Object[]{this.getContainingClass().getName(), this.getFeature().getName(), index, id, newVersion, e.getMessage()});
                }
                throw new DBException((Throwable)e);
            }
        }
        finally {
            DBUtil.close((Statement)stmt);
        }
    }

    private FeatureMap.Entry getValue(IDBStoreAccessor accessor, CDOID id, int branchId, int index, boolean getFromBase) {
        IIDHandler idHandler = this.getMappingStrategy().getStore().getIDHandler();
        IDBPreparedStatement stmt = accessor.getDBConnection().prepareStatement(this.sqlGetValue, IDBPreparedStatement.ReuseProbability.HIGH);
        FeatureMap.Entry result = null;
        try {
            try {
                int column = 1;
                idHandler.setCDOID((PreparedStatement)stmt, column++, id);
                stmt.setInt(column++, branchId);
                stmt.setInt(column++, index);
                IDBResultSet resultSet = stmt.executeQuery();
                if (resultSet.next()) {
                    CDOID tag = idHandler.getCDOID((ResultSet)resultSet, 1);
                    Object value = this.getTypeMapping(tag).readValue((ResultSet)resultSet);
                    result = CDORevisionUtil.createFeatureMapEntry((EStructuralFeature)this.getFeatureByTag(tag), (Object)value);
                } else if (getFromBase) {
                    result = this.getValueFromBase(accessor, id, branchId, index);
                }
                if (TRACER.isEnabled()) {
                    TRACER.format("Read value (index {0}) from result set: {1}", new Object[]{index, result});
                }
            }
            catch (SQLException e) {
                throw new DBException((Throwable)e);
            }
        }
        finally {
            DBUtil.close((Statement)stmt);
        }
        return result;
    }

    private FeatureMap.Entry getValueFromBase(IDBStoreAccessor accessor, CDOID id, int branchID, int index) {
        IStoreChunkReader chunkReader = this.createBaseChunkReader(accessor, id, branchID);
        chunkReader.addSimpleChunk(index);
        List chunks = chunkReader.executeRead();
        return (FeatureMap.Entry)((IStoreChunkReader.Chunk)chunks.get(0)).get(0);
    }

    private IStoreChunkReader createBaseChunkReader(IDBStoreAccessor accessor, CDOID id, int branchID) {
        InternalRepository repository = (InternalRepository)accessor.getStore().getRepository();
        InternalCDOBranchManager branchManager = repository.getBranchManager();
        CDOBranch branch = branchManager.getBranch(branchID);
        CDOBranchPoint base = branch.getBase();
        if (base.getBranch() == null) {
            throw new IllegalArgumentException("Base branch is null: " + branch);
        }
        InternalCDORevisionManager revisionManager = repository.getRevisionManager();
        InternalCDORevision baseRevision = revisionManager.getRevision(id, base, 0, 0, true);
        return accessor.createChunkReader(baseRevision, this.getFeature());
    }

    @Override
    public final boolean queryXRefs(IDBStoreAccessor accessor, String mainTableName, String mainTableWhere, IStoreAccessor.QueryXRefsContext context, String idString) {
        throw new ImplementationError("Should never be called!");
    }

    private class ListDeltaVisitor
    implements CDOFeatureDeltaVisitor {
        private IDBStoreAccessor accessor;
        private InternalCDORevision originalRevision;
        private CDOID id;
        private int branchID;
        private int oldVersion;
        private int newVersion;
        private int lastIndex;
        private long timestamp;

        public ListDeltaVisitor(IDBStoreAccessor accessor, InternalCDORevision originalRevision, int targetBranchID, int oldVersion, int newVersion, long timestamp) {
            this.accessor = accessor;
            this.originalRevision = originalRevision;
            this.id = this.originalRevision.getID();
            this.branchID = targetBranchID;
            this.oldVersion = oldVersion;
            this.newVersion = newVersion;
            this.lastIndex = originalRevision.getList(BranchingFeatureMapTableMappingWithRanges.this.getFeature()).size() - 1;
            this.timestamp = timestamp;
        }

        public void visit(CDOMoveFeatureDelta delta) {
            int fromIdx = delta.getOldPosition();
            int toIdx = delta.getNewPosition();
            if (TRACER.isEnabled()) {
                TRACER.format("Delta Moving: {0} to {1}", new Object[]{fromIdx, toIdx});
            }
            FeatureMap.Entry value = BranchingFeatureMapTableMappingWithRanges.this.getValue(this.accessor, this.id, this.branchID, fromIdx, true);
            BranchingFeatureMapTableMappingWithRanges.this.removeEntry(this.accessor, this.id, this.branchID, this.oldVersion, this.newVersion, fromIdx, this.timestamp);
            if (fromIdx < toIdx) {
                this.moveOneUp(this.accessor, this.id, this.branchID, this.oldVersion, this.newVersion, fromIdx + 1, toIdx);
            } else {
                this.moveOneDown(this.accessor, this.id, this.branchID, this.oldVersion, this.newVersion, toIdx, fromIdx - 1);
            }
            BranchingFeatureMapTableMappingWithRanges.this.addEntry(this.accessor, this.id, this.branchID, this.newVersion, toIdx, value, this.timestamp);
        }

        public void visit(CDOAddFeatureDelta delta) {
            int startIndex = delta.getIndex();
            int endIndex = this.lastIndex;
            if (TRACER.isEnabled()) {
                TRACER.format("Delta Adding at: {0}", new Object[]{startIndex});
            }
            if (startIndex <= endIndex) {
                this.moveOneDown(this.accessor, this.id, this.branchID, this.oldVersion, this.newVersion, startIndex, endIndex);
            }
            BranchingFeatureMapTableMappingWithRanges.this.addEntry(this.accessor, this.id, this.branchID, this.newVersion, startIndex, delta.getValue(), this.timestamp);
            ++this.lastIndex;
        }

        public void visit(CDORemoveFeatureDelta delta) {
            int startIndex = delta.getIndex();
            int endIndex = this.lastIndex;
            if (TRACER.isEnabled()) {
                TRACER.format("Delta Removing at: {0}", new Object[]{startIndex});
            }
            BranchingFeatureMapTableMappingWithRanges.this.removeEntry(this.accessor, this.id, this.branchID, this.oldVersion, this.newVersion, startIndex, this.timestamp);
            this.moveOneUp(this.accessor, this.id, this.branchID, this.oldVersion, this.newVersion, startIndex + 1, endIndex);
            --this.lastIndex;
        }

        public void visit(CDOSetFeatureDelta delta) {
            int index = delta.getIndex();
            if (TRACER.isEnabled()) {
                TRACER.format("Delta Setting at: {0}", new Object[]{index});
            }
            BranchingFeatureMapTableMappingWithRanges.this.removeEntry(this.accessor, this.id, this.branchID, this.oldVersion, this.newVersion, index, this.timestamp);
            BranchingFeatureMapTableMappingWithRanges.this.addEntry(this.accessor, this.id, this.branchID, this.newVersion, index, delta.getValue(), this.timestamp);
        }

        public void visit(CDOUnsetFeatureDelta delta) {
            if (delta.getFeature().isUnsettable()) {
                throw new ImplementationError("Should not be called");
            }
            if (TRACER.isEnabled()) {
                TRACER.format("Delta Unsetting", new Object[0]);
            }
            BranchingFeatureMapTableMappingWithRanges.this.clearList(this.accessor, this.id, this.branchID, this.oldVersion, this.newVersion, this.lastIndex, this.timestamp);
            this.lastIndex = -1;
        }

        public void visit(CDOListFeatureDelta delta) {
            throw new ImplementationError("Should not be called");
        }

        public void visit(CDOClearFeatureDelta delta) {
            if (TRACER.isEnabled()) {
                TRACER.format("Delta Clearing", new Object[0]);
            }
            BranchingFeatureMapTableMappingWithRanges.this.clearList(this.accessor, this.id, this.branchID, this.oldVersion, this.newVersion, this.lastIndex, this.timestamp);
            this.lastIndex = -1;
        }

        public void visit(CDOContainerFeatureDelta delta) {
            throw new ImplementationError("Should not be called");
        }

        private void moveOneUp(IDBStoreAccessor accessor, CDOID id, int branchId, int oldVersion, int newVersion, int startIndex, int endIndex) {
            IIDHandler idHandler = BranchingFeatureMapTableMappingWithRanges.this.getMappingStrategy().getStore().getIDHandler();
            IDBPreparedStatement stmt = accessor.getDBConnection().prepareStatement(BranchingFeatureMapTableMappingWithRanges.this.sqlUpdateIndex, IDBPreparedStatement.ReuseProbability.HIGH);
            try {
                try {
                    int index = startIndex;
                    while (index <= endIndex) {
                        if (TRACER.isEnabled()) {
                            TRACER.format("moveOneUp moving: {0} -> {1}", new Object[]{index, index - 1});
                        }
                        int column = 1;
                        stmt.setInt(column++, index - 1);
                        idHandler.setCDOID((PreparedStatement)stmt, startIndex++, id);
                        stmt.setInt(column++, branchId);
                        stmt.setInt(column++, newVersion);
                        stmt.setInt(column++, index);
                        int result = DBUtil.update((PreparedStatement)stmt, (boolean)false);
                        switch (result) {
                            case 1: {
                                if (!TRACER.isEnabled()) break;
                                TRACER.format("moveOneUp updated: {0} -> {1}", new Object[]{index, index - 1});
                                break;
                            }
                            case 0: {
                                FeatureMap.Entry value = BranchingFeatureMapTableMappingWithRanges.this.getValue(accessor, id, branchId, index, false);
                                if (value != null) {
                                    if (TRACER.isEnabled()) {
                                        TRACER.format("moveOneUp remove: {0}", new Object[]{index});
                                    }
                                    BranchingFeatureMapTableMappingWithRanges.this.removeEntry(accessor, id, branchId, oldVersion, newVersion, index, this.timestamp);
                                } else {
                                    value = BranchingFeatureMapTableMappingWithRanges.this.getValueFromBase(accessor, id, branchId, index);
                                    TRACER.format("moveOneUp add historic entry at: {0}", new Object[]{index});
                                    BranchingFeatureMapTableMappingWithRanges.this.addHistoricEntry(accessor, id, branchId, 0, newVersion, index, value, this.timestamp);
                                }
                                if (TRACER.isEnabled()) {
                                    TRACER.format("moveOneUp add: {0}", new Object[]{index - 1});
                                }
                                BranchingFeatureMapTableMappingWithRanges.this.addEntry(accessor, id, branchId, newVersion, index - 1, value, this.timestamp);
                                break;
                            }
                            default: {
                                if (TRACER.isEnabled()) {
                                    TRACER.format("moveOneUp Too many results: {0} -> {1}: {2}", new Object[]{index, index + 1, result});
                                }
                                throw new DBException("Too many results");
                            }
                        }
                        ++index;
                    }
                }
                catch (SQLException e) {
                    throw new DBException((Throwable)e);
                }
            }
            finally {
                DBUtil.close((Statement)stmt);
            }
        }

        private void moveOneDown(IDBStoreAccessor accessor, CDOID id, int branchId, int oldVersion, int newVersion, int startIndex, int endIndex) {
            IIDHandler idHandler = BranchingFeatureMapTableMappingWithRanges.this.getMappingStrategy().getStore().getIDHandler();
            IDBPreparedStatement stmt = accessor.getDBConnection().prepareStatement(BranchingFeatureMapTableMappingWithRanges.this.sqlUpdateIndex, IDBPreparedStatement.ReuseProbability.HIGH);
            try {
                try {
                    int index = endIndex;
                    while (index >= startIndex) {
                        if (TRACER.isEnabled()) {
                            TRACER.format("moveOneDown moving: {0} -> {1}", new Object[]{index, index + 1});
                        }
                        int column = 1;
                        stmt.setInt(column++, index + 1);
                        idHandler.setCDOID((PreparedStatement)stmt, column++, id);
                        stmt.setInt(column++, branchId);
                        stmt.setInt(column++, newVersion);
                        stmt.setInt(column++, index);
                        int result = DBUtil.update((PreparedStatement)stmt, (boolean)false);
                        switch (result) {
                            case 1: {
                                if (!TRACER.isEnabled()) break;
                                TRACER.format("moveOneDown updated: {0} -> {1}", new Object[]{index, index + 1});
                                break;
                            }
                            case 0: {
                                FeatureMap.Entry value = BranchingFeatureMapTableMappingWithRanges.this.getValue(accessor, id, branchId, index, false);
                                if (value != null) {
                                    if (TRACER.isEnabled()) {
                                        TRACER.format("moveOneDown remove: {0}", new Object[]{index});
                                    }
                                    BranchingFeatureMapTableMappingWithRanges.this.removeEntry(accessor, id, branchId, oldVersion, newVersion, index, this.timestamp);
                                } else {
                                    value = BranchingFeatureMapTableMappingWithRanges.this.getValueFromBase(accessor, id, branchId, index);
                                    TRACER.format("moveOneDown add historic entry at: {0}", new Object[]{index});
                                    BranchingFeatureMapTableMappingWithRanges.this.addHistoricEntry(accessor, id, branchId, 0, newVersion, index, value, this.timestamp);
                                }
                                BranchingFeatureMapTableMappingWithRanges.this.addEntry(accessor, id, branchId, newVersion, index + 1, value, this.timestamp);
                                break;
                            }
                            default: {
                                if (TRACER.isEnabled()) {
                                    TRACER.format("moveOneDown Too many results: {0} -> {1}: {2}", new Object[]{index, index + 1, result});
                                }
                                throw new DBException("Too many results");
                            }
                        }
                        --index;
                    }
                }
                catch (SQLException e) {
                    throw new DBException((Throwable)e);
                }
            }
            finally {
                DBUtil.close((Statement)stmt);
            }
        }
    }
}

