/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.common.sync;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.SetBoundsCommand;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.Size;
import org.eclipse.papyrus.commands.wrappers.GMFtoEMFCommandWrapper;
import org.eclipse.papyrus.infra.gmfdiag.common.sync.NodeSizeSyncDispatcher;
import org.eclipse.papyrus.infra.gmfdiag.common.sync.NotationSyncPolicyDelegate;
import org.eclipse.papyrus.infra.sync.EMFDispatch;
import org.eclipse.papyrus.infra.sync.EMFDispatchManager;
import org.eclipse.papyrus.infra.sync.SyncBucket;
import org.eclipse.papyrus.infra.sync.SyncFeature;
import org.eclipse.papyrus.infra.sync.SyncItem;
import org.eclipse.papyrus.infra.tools.util.TypeUtils;

public class NodeSizeSyncFeature<M extends EObject, T extends EditPart>
extends SyncFeature<M, T, Notification> {
    private EMFDispatchManager<Dispatcher> dispatchMgr = this.createSingleDispatchManager();

    public NodeSizeSyncFeature(SyncBucket<M, T, Notification> bucket) {
        super(bucket);
    }

    public void observe(SyncItem<M, T> item) {
        this.dispatchMgr.add(item, (EMFDispatch)new Dispatcher(item));
    }

    public void unobserve(SyncItem<M, T> item) {
        this.dispatchMgr.remove(item);
    }

    protected void onClear() {
        this.dispatchMgr.removeAll();
    }

    public void synchronize(SyncItem<M, T> from, SyncItem<M, T> to, Notification message) {
        Dimension sizeTo;
        EditPart fromEditPart = (EditPart)from.getBackend();
        EditPart toEditPart = (EditPart)to.getBackend();
        Dimension sizeFrom = this.getSize(fromEditPart);
        if (!sizeFrom.equals((Object)(sizeTo = this.getSize(toEditPart)))) {
            Command reaction = GMFtoEMFCommandWrapper.wrap((ICommand)new SetBoundsCommand(this.getEditingDomain(), "Synchronize Node Size", (IAdaptable)toEditPart, sizeFrom));
            if (message == null) {
                this.execute(reaction);
            } else {
                Dispatcher dispatcher = (Dispatcher)this.dispatchMgr.getDispatcher(from, message.getFeature());
                if (dispatcher != null) {
                    dispatcher.react(reaction);
                }
            }
        }
    }

    Dimension getSize(EditPart editPart) {
        Dimension result = null;
        Node node = (Node)editPart.getModel();
        Size size = (Size)TypeUtils.as((Object)node.getLayoutConstraint(), Size.class);
        if (size != null && size.getWidth() >= 0 && size.getHeight() >= 0) {
            result = new Dimension(size.getWidth(), size.getHeight());
        }
        if (result == null) {
            IFigure figure = ((GraphicalEditPart)editPart).getFigure();
            result = figure.getBounds().getSize();
        }
        return result;
    }

    public static <M extends EObject, T extends EditPart> NotationSyncPolicyDelegate<M, T> createPolicyDelegate() {
        return new NotationSyncPolicyDelegate<M, T>(NotationPackage.Literals.SIZE.getName()){

            protected EMFDispatch createDispatcher(SyncItem<M, T> syncTarget) {
                return new NodeSizeSyncDispatcher<M, T>(syncTarget){

                    public void onClear() {
                    }

                    @Override
                    protected void onFilteredChange(Notification notification) {
                        this.overrideOccurred(this, this.getItem());
                    }
                };
            }
        };
    }

    private class Dispatcher
    extends NodeSizeSyncDispatcher<M, T> {
        public Dispatcher(SyncItem<M, T> item) {
            super(item);
        }

        public void onClear() {
            NodeSizeSyncFeature.this.getBucket().clear();
        }

        @Override
        protected void onFilteredChange(Notification notification) {
            NodeSizeSyncFeature.this.onChange(this.item, notification);
        }
    }
}

