/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.common.utils;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.UnmodifiableIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.AbstractTreeIterator;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.editparts.AbstractConnectionEditPart;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gef.util.EditPartUtilities;
import org.eclipse.gmf.runtime.diagram.ui.editparts.AbstractBorderItemEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramRootEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ITextAwareEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.CanonicalEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramEditor;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramGraphicalViewer;
import org.eclipse.gmf.runtime.diagram.ui.parts.IDiagramGraphicalViewer;
import org.eclipse.gmf.runtime.diagram.ui.parts.IDiagramWorkbenchPart;
import org.eclipse.gmf.runtime.emf.core.util.EMFCoreUtil;
import org.eclipse.gmf.runtime.notation.CanonicalStyle;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.papyrus.infra.core.resource.IReadOnlyHandler2;
import org.eclipse.papyrus.infra.core.resource.ReadOnlyAxis;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.emf.readonly.ReadOnlyManager;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.gmfdiag.common.editpart.ConnectionEditPart;
import org.eclipse.papyrus.infra.gmfdiag.common.editpart.PapyrusDiagramEditPart;
import org.eclipse.papyrus.infra.gmfdiag.common.helper.NotationHelper;
import org.eclipse.papyrus.infra.gmfdiag.common.utils.ServiceUtilsForEditPart;
import org.eclipse.papyrus.infra.ui.util.EditorHelper;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class DiagramEditPartsUtil {
    public static final String BelongToDiagramSource = "es.cv.gvcase.mdt.uml2.diagram.common.Belongs_To_This_Diagram";
    public static final String DiagramsRelatedToElement = "es.cv.gvcase.mdt.uml2.diagram.common.DiagramsRelatedToElement";

    protected DiagramEditPartsUtil() {
    }

    public static EditPart getEditPartFromView(View view, EditPart anyEditPart) {
        if (view != null && anyEditPart != null) {
            return (EditPart)anyEditPart.getViewer().getEditPartRegistry().get(view);
        }
        return null;
    }

    public static DiagramEditPart getDiagramEditPart(EditPart editPart) {
        if (editPart == null) {
            return null;
        }
        if (editPart instanceof IGraphicalEditPart) {
            IGraphicalEditPart graphicalEditPart = (IGraphicalEditPart)editPart;
            View view = graphicalEditPart.getNotationView();
            Diagram diagram = view.getDiagram();
            Object object = graphicalEditPart.getViewer().getEditPartRegistry().get(diagram);
            if (object instanceof DiagramEditPart) {
                return (DiagramEditPart)object;
            }
        }
        if (editPart instanceof DiagramEditPart) {
            return (DiagramEditPart)editPart;
        }
        EditPart actual = editPart;
        EditPart parent = null;
        while ((parent = actual.getParent()) != null) {
            if (parent instanceof DiagramEditPart) {
                return (DiagramEditPart)parent;
            }
            actual = parent;
        }
        return null;
    }

    public static Collection<EditPart> getAllTopSemanticEditPart(EditPart ep) {
        HashSet<EditPart> editparts = new HashSet<EditPart>();
        for (Object current : ep.getChildren()) {
            if (!(current instanceof EditPart)) continue;
            editparts.addAll(DiagramEditPartsUtil.getAllTopSemanticEditPart((EditPart)current));
            EditPart topEP = DiagramEditPartsUtil.getTopSemanticEditPart((EditPart)current);
            if (topEP == null) continue;
            editparts.add(topEP);
        }
        return editparts;
    }

    public static final EditPart getTopSemanticEditPart(EditPart ep) {
        EObject currentEObject = (EObject)ep.getAdapter(EObject.class);
        if (currentEObject != null) {
            EditPart previousParent = ep;
            EditPart parent = ep;
            while (parent != null) {
                if (parent.getAdapter(EObject.class) != currentEObject || parent instanceof DiagramEditPart) {
                    return previousParent;
                }
                previousParent = parent;
                parent = parent.getParent();
            }
            return previousParent;
        }
        return null;
    }

    public static final IDiagramGraphicalViewer getActiveDiagramGraphicalViewer() {
        IDiagramWorkbenchPart part = DiagramEditPartsUtil.getActiveDiagramWorkbenchPart();
        return part != null ? part.getDiagramGraphicalViewer() : null;
    }

    public static final IDiagramWorkbenchPart getActiveDiagramWorkbenchPart() {
        IDiagramWorkbenchPart diagramPart = null;
        IWorkbenchPart part = EditorHelper.getActivePart();
        if (part instanceof IDiagramWorkbenchPart) {
            diagramPart = (IDiagramWorkbenchPart)part;
        } else if (part != null) {
            diagramPart = (IDiagramWorkbenchPart)part.getAdapter(IDiagramWorkbenchPart.class);
        }
        return diagramPart;
    }

    public static final IPreferenceStore getDiagramWorkspacePreferenceStore(EditPart anEditPart) {
        EditPartViewer viewer = anEditPart.getViewer();
        if (viewer instanceof DiagramGraphicalViewer) {
            return ((DiagramGraphicalViewer)viewer).getWorkspaceViewerPreferenceStore();
        }
        return null;
    }

    public static final boolean isSnapToGridActive(EditPart anEditPart) {
        boolean result = false;
        IPreferenceStore store = DiagramEditPartsUtil.getDiagramWorkspacePreferenceStore(anEditPart);
        if (store != null) {
            result = store.getBoolean("rulergrid.snaptogrid");
        }
        return result;
    }

    public static final double getDiagramGridSpacing(EditPart anEditPart) {
        RootEditPart rootEP = anEditPart.getRoot();
        if (rootEP instanceof DiagramRootEditPart) {
            return ((DiagramRootEditPart)rootEP).getGridSpacing();
        }
        return -1.0;
    }

    public static final EditPart getContainerEditPart(org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart currentEP) {
        EditPart parent = currentEP.getParent();
        EditPart container = parent instanceof AbstractConnectionEditPart ? parent.getParent() : (parent instanceof AbstractBorderItemEditPart ? parent.getParent().getParent() : (currentEP instanceof AbstractBorderItemEditPart ? parent.getParent() : parent));
        return container;
    }

    public static final double getDiagramZoomLevel(EditPart anEditPart) {
        ZoomManager zoomManager;
        RootEditPart rootEP = anEditPart.getRoot();
        if (rootEP instanceof DiagramRootEditPart && (zoomManager = ((DiagramRootEditPart)rootEP).getZoomManager()) != null) {
            return zoomManager.getZoom();
        }
        return 1.0;
    }

    public static List<IGraphicalEditPart> getAllEditParts(EditPart editPart) {
        if (editPart == null) {
            return null;
        }
        EditPart topEditPart = DiagramEditPartsUtil.getTopMostEditPart(editPart);
        ArrayList<IGraphicalEditPart> editParts = new ArrayList<IGraphicalEditPart>();
        if (editPart instanceof IGraphicalEditPart) {
            editParts.add((IGraphicalEditPart)editPart);
        }
        DiagramEditPartsUtil.addEditPartGraphicalChildren(editPart, editParts);
        return editParts;
    }

    public static EditPart getTopMostEditPart(EditPart editPart) {
        EditPart parent;
        if (editPart == null) {
            return null;
        }
        EditPart actual = editPart;
        while ((parent = actual.getParent()) != null) {
            actual = parent;
        }
        return actual;
    }

    public static void handleNotificationForDiagram(IGraphicalEditPart editPart, Notification notification, List<EStructuralFeature> features) {
        EObject element = editPart.resolveSemanticElement();
        Object notifier = notification.getNotifier();
        Object feature = notification.getFeature();
        Object oldValue = notification.getOldValue();
        Object newValue = notification.getNewValue();
        if (notifier != null && notifier == element && feature != null && oldValue != null && oldValue != newValue && features.contains(feature)) {
            DiagramEditPartsUtil.updateDiagram(editPart);
        }
    }

    public static void handleNotificationForView(IGraphicalEditPart editPart, Notification notification, List<EStructuralFeature> features) {
        EObject element = editPart.resolveSemanticElement();
        Object notifier = notification.getNotifier();
        Object feature = notification.getFeature();
        Object oldValue = notification.getOldValue();
        Object newValue = notification.getNewValue();
        if (notifier != null && notifier == element && feature != null && oldValue != null && oldValue != newValue && features.contains(feature)) {
            DiagramEditPartsUtil.updateEditPart(editPart);
        }
    }

    public static void updateDiagram(View view) {
        if (view == null) {
            return;
        }
        if ((view = view.getDiagram()) == null) {
            return;
        }
        EObject element = view.getElement();
        if (element == null) {
            return;
        }
        List editPolicies = CanonicalEditPolicy.getRegisteredEditPolicies((EObject)element);
        for (CanonicalEditPolicy nextEditPolicy : editPolicies) {
            nextEditPolicy.refresh();
        }
    }

    public static void updateDiagram(IGraphicalEditPart editPart) {
        if (editPart == null) {
            return;
        }
        View view = editPart.getNotationView();
        if (view == null) {
            return;
        }
        if ((view = view.getDiagram()) == null) {
            return;
        }
        EObject element = view.getElement();
        if (element == null) {
            return;
        }
        List editPolicies = CanonicalEditPolicy.getRegisteredEditPolicies((EObject)element);
        for (CanonicalEditPolicy nextEditPolicy : editPolicies) {
            nextEditPolicy.refresh();
        }
    }

    public static void updateEditPart(IGraphicalEditPart editPart) {
        if (editPart == null) {
            return;
        }
        View view = editPart.getNotationView();
        if (view == null) {
            return;
        }
        EObject element = view.getElement();
        if (element == null) {
            return;
        }
        List editPolicies = CanonicalEditPolicy.getRegisteredEditPolicies((EObject)element);
        for (CanonicalEditPolicy nextEditPolicy : editPolicies) {
            nextEditPolicy.refresh();
        }
    }

    public static void updateEditPartAndChildren(IGraphicalEditPart editPart, EClass eClass) {
        if (editPart == null) {
            return;
        }
        View view = editPart.getNotationView();
        if (view == null) {
            return;
        }
        for (Object child : editPart.getChildren()) {
            if (!(child instanceof IGraphicalEditPart)) continue;
            DiagramEditPartsUtil.updateEditPartAndChildren((IGraphicalEditPart)child, eClass);
        }
        EObject element = view.getElement();
        if (eClass != null && eClass.isInstance((Object)element)) {
            List editPolicies = CanonicalEditPolicy.getRegisteredEditPolicies((EObject)element);
            for (CanonicalEditPolicy nextEditPolicy : editPolicies) {
                nextEditPolicy.refresh();
            }
        }
    }

    private static void addEditPartGraphicalChildren(EditPart editPart, List<IGraphicalEditPart> list) {
        if (editPart == null) {
            return;
        }
        List children = editPart.getChildren();
        for (EditPart ep : children) {
            if (ep instanceof IGraphicalEditPart) {
                list.add((IGraphicalEditPart)ep);
            }
            DiagramEditPartsUtil.addEditPartGraphicalChildren(ep, list);
        }
    }

    public static List<View> getEObjectViews(EObject element) {
        ArrayList<View> views = new ArrayList<View>();
        if (element != null) {
            EReference[] features = new EReference[]{NotationPackage.eINSTANCE.getView_Element()};
            Collection referencingViews = EMFCoreUtil.getReferencers((EObject)element, (EReference[])features);
            views.addAll(referencingViews);
        }
        return views;
    }

    public static List<View> findViews(EObject parserElement, EditPartViewer viewer) {
        ArrayList<View> modelElements = new ArrayList<View>();
        if (parserElement != null) {
            for (Object ep : viewer.getEditPartRegistry().keySet()) {
                View view;
                if (!(ep instanceof View) || !parserElement.equals((view = (View)ep).getElement())) continue;
                modelElements.add(view);
            }
        }
        return modelElements;
    }

    public static Iterable<EditPart> findEditParts(View view) {
        ArrayList result;
        Diagram diagram = view.getDiagram();
        if (diagram == null) {
            result = Collections.emptyList();
        } else {
            result = Lists.newArrayListWithExpectedSize((int)1);
            TreeIterator<EditPart> iter = DiagramEditPartsUtil.getAllContents(PapyrusDiagramEditPart.getDiagramEditPartsFor(diagram));
            while (iter.hasNext()) {
                EditPart next = (EditPart)iter.next();
                if (next.getModel() != view) continue;
                result.add(next);
            }
        }
        return result;
    }

    public static List<EditPart> getEditPartsFromSelection(ISelection selection, IDiagramGraphicalViewer viewer) {
        if (selection instanceof StructuredSelection && !selection.isEmpty()) {
            StructuredSelection structuredSelection = (StructuredSelection)selection;
            ArrayList<View> views = new ArrayList<View>();
            for (Object o : structuredSelection.toList()) {
                if (!(o instanceof EObject)) continue;
                List<View> referencerViews = DiagramEditPartsUtil.getEObjectViews((EObject)o);
                for (View ro : referencerViews) {
                    if (!(ro instanceof View)) continue;
                    views.add(ro);
                }
            }
            if (!views.isEmpty()) {
                ArrayList<EditPart> editParts = new ArrayList<EditPart>();
                for (View view : views) {
                    Object ep = viewer.getEditPartRegistry().get(view);
                    if (!(ep instanceof EditPart)) continue;
                    editParts.add((EditPart)ep);
                }
                if (!editParts.isEmpty()) {
                    return editParts;
                }
            }
        }
        return Collections.EMPTY_LIST;
    }

    public static Diagram findDiagramFromPlugin(AbstractUIPlugin plugin) {
        IEditorPart editor = plugin.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        if (editor instanceof DiagramEditor) {
            return ((DiagramEditor)editor).getDiagram();
        }
        return null;
    }

    public static Diagram findDiagramFromEditPart(EditPart editPart) {
        Object object = editPart.getModel();
        if (object instanceof View) {
            return ((View)object).getDiagram();
        }
        return null;
    }

    public static void refreshITextAwareEditParts(EditPart editPart) {
        for (Object obj : editPart.getChildren()) {
            if (!(obj instanceof EditPart)) continue;
            DiagramEditPartsUtil.refreshITextAwareEditParts((EditPart)obj);
        }
        if (editPart instanceof ITextAwareEditPart) {
            editPart.refresh();
        }
    }

    public static IGraphicalEditPart getChildByEObject(final EObject eObject, IGraphicalEditPart rootEditPart, boolean isEdge) {
        if (eObject != null && rootEditPart != null) {
            try {
                Predicate<EditPart> predicate = new Predicate<EditPart>(){

                    public boolean apply(EditPart input) {
                        EditPart parent;
                        IGraphicalEditPart current;
                        return input instanceof IGraphicalEditPart && eObject.equals((current = (IGraphicalEditPart)input).resolveSemanticElement()) && ((parent = current.getParent()) instanceof IGraphicalEditPart ? !eObject.equals(((IGraphicalEditPart)parent).resolveSemanticElement()) : parent instanceof RootEditPart);
                    }
                };
                EditPart find = isEdge ? (EditPart)Iterables.find((Iterable)EditPartUtilities.getAllNestedConnectionEditParts((GraphicalEditPart)rootEditPart), (Predicate)predicate) : (EditPart)Iterables.find((Iterable)EditPartUtilities.getAllChildren((GraphicalEditPart)rootEditPart), (Predicate)predicate);
                return (IGraphicalEditPart)find;
            }
            catch (NoSuchElementException noSuchElementException) {
                // empty catch block
            }
        }
        return null;
    }

    public static Iterable<IGraphicalEditPart> getChildrenByEObject(final EObject eObject, IGraphicalEditPart rootEditPart, boolean isEdge) {
        if (eObject != null && rootEditPart != null) {
            try {
                Predicate<EditPart> predicate = new Predicate<EditPart>(){

                    public boolean apply(EditPart input) {
                        EditPart parent;
                        IGraphicalEditPart current;
                        return input instanceof IGraphicalEditPart && eObject.equals((current = (IGraphicalEditPart)input).resolveSemanticElement()) && ((parent = current.getParent()) instanceof IGraphicalEditPart ? !eObject.equals(((IGraphicalEditPart)parent).resolveSemanticElement()) : parent instanceof RootEditPart);
                    }
                };
                Iterable find = isEdge ? Iterables.filter((Iterable)EditPartUtilities.getAllNestedConnectionEditParts((GraphicalEditPart)rootEditPart), (Predicate)predicate) : Iterables.filter((Iterable)EditPartUtilities.getAllChildren((GraphicalEditPart)rootEditPart), (Predicate)predicate);
                return Iterables.transform((Iterable)find, (Function)new Function<EditPart, IGraphicalEditPart>(){

                    public IGraphicalEditPart apply(EditPart from) {
                        if (from instanceof IGraphicalEditPart) {
                            return (IGraphicalEditPart)from;
                        }
                        return null;
                    }
                });
            }
            catch (NoSuchElementException e) {
                return Collections.EMPTY_LIST;
            }
        }
        return Collections.EMPTY_LIST;
    }

    public static TreeIterator<EditPart> getAllContents(EditPart editPart, boolean includeRoot) {
        return DiagramEditPartsUtil.internalGetAllContents(editPart, includeRoot);
    }

    public static TreeIterator<EditPart> getAllContents(Iterable<? extends EditPart> editParts) {
        return DiagramEditPartsUtil.internalGetAllContents(editParts, false);
    }

    private static final TreeIterator<EditPart> internalGetAllContents(Object root, boolean includeRoot) {
        return new AbstractTreeIterator<EditPart>(root, includeRoot, root){
            private static final long serialVersionUID = 1L;
            private final Iterable<EditPart> rootCollection;
            {
                this.rootCollection = object instanceof Iterable ? (Iterable)object : null;
            }

            protected Iterator<? extends EditPart> getChildren(Object object) {
                UnmodifiableIterator result;
                if (object == this.rootCollection) {
                    result = ImmutableList.copyOf(this.rootCollection).iterator();
                } else {
                    ImmutableList.Builder copy = ImmutableList.builder();
                    EditPart editPart = (EditPart)object;
                    copy.addAll((Iterable)editPart.getChildren());
                    if (editPart instanceof DiagramEditPart && editPart.getViewer() != null) {
                        copy.addAll((Iterable)((DiagramEditPart)editPart).getConnections());
                    }
                    result = copy.build().iterator();
                }
                return result;
            }
        };
    }

    public static boolean isCanonical(EditPart editPart) {
        CanonicalStyle style;
        View view;
        boolean result = false;
        if (editPart instanceof IGraphicalEditPart && (view = ((IGraphicalEditPart)editPart).getNotationView()) != null && (style = (CanonicalStyle)view.getStyle(NotationPackage.Literals.CANONICAL_STYLE)) != null) {
            result = style.isCanonical();
        }
        return result;
    }

    public static boolean isSemanticDeletion(IGraphicalEditPart editPart) {
        boolean isSemanticDeletion = false;
        TransactionalEditingDomain editingDomain = null;
        try {
            editingDomain = ServiceUtilsForEditPart.getInstance().getTransactionalEditingDomain(editPart);
        }
        catch (ServiceException serviceException) {
            // empty catch block
        }
        if (editingDomain != null) {
            IReadOnlyHandler2 readOnly = ReadOnlyManager.getReadOnlyHandler((EditingDomain)editingDomain);
            EObject semantic = EMFHelper.getEObject((Object)editPart);
            View graphical = NotationHelper.findView(editPart);
            boolean bl = isSemanticDeletion = semantic != null && semantic != graphical && semantic.eContainer() != null;
            if (!isSemanticDeletion && editPart instanceof ConnectionEditPart) {
                isSemanticDeletion = ((ConnectionEditPart)editPart).isSemanticConnection();
            }
            if (isSemanticDeletion && readOnly != null) {
                Optional result = readOnly.isReadOnly(ReadOnlyAxis.anyAxis(), semantic);
                if (!((Boolean)result.or((Object)false)).booleanValue() && graphical != null) {
                    result = readOnly.isReadOnly(ReadOnlyAxis.anyAxis(), (EObject)graphical);
                }
                isSemanticDeletion = (Boolean)result.or((Object)false) == false;
            }
        }
        return isSemanticDeletion;
    }

    public static boolean isReadOnly(IGraphicalEditPart editPart) {
        boolean isReadOnly = true;
        TransactionalEditingDomain editingDomain = null;
        try {
            editingDomain = ServiceUtilsForEditPart.getInstance().getTransactionalEditingDomain(editPart);
        }
        catch (ServiceException serviceException) {
            // empty catch block
        }
        if (editingDomain != null) {
            Optional result;
            IReadOnlyHandler2 readOnly = ReadOnlyManager.getReadOnlyHandler((EditingDomain)editingDomain);
            EObject semantic = EMFHelper.getEObject((Object)editPart);
            View graphical = NotationHelper.findView(editPart);
            if (readOnly != null && semantic != null && !(isReadOnly = ((Boolean)(result = readOnly.isReadOnly(ReadOnlyAxis.anyAxis(), semantic)).get()).booleanValue()) && graphical != null) {
                result = readOnly.isReadOnly(ReadOnlyAxis.anyAxis(), (EObject)graphical);
                isReadOnly = (Boolean)result.get();
            }
        }
        return isReadOnly;
    }
}

