/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.filters.impl;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EFactoryImpl;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.papyrus.infra.filters.CompoundFilter;
import org.eclipse.papyrus.infra.filters.Equals;
import org.eclipse.papyrus.infra.filters.FiltersFactory;
import org.eclipse.papyrus.infra.filters.FiltersPackage;
import org.eclipse.papyrus.infra.filters.OperatorKind;
import org.eclipse.papyrus.infra.filters.impl.CompoundFilterImpl;
import org.eclipse.papyrus.infra.filters.impl.EqualsImpl;

public class FiltersFactoryImpl
extends EFactoryImpl
implements FiltersFactory {
    public static FiltersFactory init() {
        try {
            FiltersFactory theFiltersFactory = (FiltersFactory)EPackage.Registry.INSTANCE.getEFactory("http://www.eclipse.org/Papyrus/2014/common/filters");
            if (theFiltersFactory != null) {
                return theFiltersFactory;
            }
        }
        catch (Exception exception) {
            EcorePlugin.INSTANCE.log((Object)exception);
        }
        return new FiltersFactoryImpl();
    }

    public EObject create(EClass eClass) {
        switch (eClass.getClassifierID()) {
            case 0: {
                return this.createCompoundFilter();
            }
            case 2: {
                return this.createEquals();
            }
        }
        throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
    }

    public Object createFromString(EDataType eDataType, String initialValue) {
        switch (eDataType.getClassifierID()) {
            case 3: {
                return this.createOperatorKindFromString(eDataType, initialValue);
            }
            case 4: {
                return this.createObjectFromString(eDataType, initialValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    public String convertToString(EDataType eDataType, Object instanceValue) {
        switch (eDataType.getClassifierID()) {
            case 3: {
                return this.convertOperatorKindToString(eDataType, instanceValue);
            }
            case 4: {
                return this.convertObjectToString(eDataType, instanceValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    @Override
    public CompoundFilter createCompoundFilter() {
        CompoundFilterImpl compoundFilter = new CompoundFilterImpl();
        return compoundFilter;
    }

    @Override
    public Equals createEquals() {
        EqualsImpl equals = new EqualsImpl();
        return equals;
    }

    public OperatorKind createOperatorKindFromString(EDataType eDataType, String initialValue) {
        OperatorKind result = OperatorKind.get(initialValue);
        if (result == null) {
            throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return result;
    }

    public String convertOperatorKindToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    public Object createObjectFromString(EDataType eDataType, String initialValue) {
        return super.createFromString(eDataType, initialValue);
    }

    public String convertObjectToString(EDataType eDataType, Object instanceValue) {
        return super.convertToString(eDataType, instanceValue);
    }

    @Override
    public FiltersPackage getFiltersPackage() {
        return (FiltersPackage)this.getEPackage();
    }

    @Deprecated
    public static FiltersPackage getPackage() {
        return FiltersPackage.eINSTANCE;
    }
}

