/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.filters.util;

import java.util.Map;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.util.EObjectValidator;
import org.eclipse.papyrus.infra.filters.CompoundFilter;
import org.eclipse.papyrus.infra.filters.Equals;
import org.eclipse.papyrus.infra.filters.Filter;
import org.eclipse.papyrus.infra.filters.FiltersPackage;
import org.eclipse.papyrus.infra.filters.OperatorKind;
import org.eclipse.papyrus.infra.filters.internal.FiltersPlugin;

public class FiltersValidator
extends EObjectValidator {
    public static final FiltersValidator INSTANCE = new FiltersValidator();
    public static final String DIAGNOSTIC_SOURCE = "org.eclipse.papyrus.infra.filters";
    public static final int COMPOUND_FILTER__ACYCLIC = 1;
    private static final int GENERATED_DIAGNOSTIC_CODE_COUNT = 1;
    protected static final int DIAGNOSTIC_CODE_COUNT = 1;

    protected EPackage getEPackage() {
        return FiltersPackage.eINSTANCE;
    }

    protected boolean validate(int classifierID, Object value, DiagnosticChain diagnostics, Map<Object, Object> context) {
        switch (classifierID) {
            case 0: {
                return this.validateCompoundFilter((CompoundFilter)value, diagnostics, context);
            }
            case 1: {
                return this.validateFilter((Filter)value, diagnostics, context);
            }
            case 2: {
                return this.validateEquals((Equals)value, diagnostics, context);
            }
            case 3: {
                return this.validateOperatorKind((OperatorKind)((Object)value), diagnostics, context);
            }
            case 4: {
                return this.validateObject(value, diagnostics, context);
            }
        }
        return true;
    }

    public boolean validateCompoundFilter(CompoundFilter compoundFilter, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(compoundFilter, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(compoundFilter, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(compoundFilter, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(compoundFilter, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(compoundFilter, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(compoundFilter, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(compoundFilter, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(compoundFilter, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(compoundFilter, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateCompoundFilter_validateAcyclic(compoundFilter, diagnostics, context);
        }
        return result;
    }

    public boolean validateCompoundFilter_validateAcyclic(CompoundFilter compoundFilter, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return compoundFilter.validateAcyclic(diagnostics, context);
    }

    public boolean validateFilter(Filter filter, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(filter, diagnostics, context);
    }

    public boolean validateEquals(Equals equals, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(equals, diagnostics, context);
    }

    public boolean validateOperatorKind(OperatorKind operatorKind, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public boolean validateObject(Object object, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public ResourceLocator getResourceLocator() {
        return FiltersPlugin.INSTANCE;
    }
}

