/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.opencert.impactanalysis.test;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.cdo.transaction.CDOTransaction;
import org.eclipse.emf.cdo.view.CDOQuery;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.opencert.apm.assuranceassets.assuranceasset.EventKind;
import org.eclipse.opencert.evm.evidspec.evidence.Artefact;
import org.eclipse.opencert.impactanalysis.ImpactAnalyser;
import org.eclipse.opencert.impactanalysis.ImpactSource;
import org.eclipse.opencert.impactanalysis.relations.IArtefactRelationImpact;
import org.eclipse.opencert.storage.cdo.CDOStorageUtil;
import org.eclipse.opencert.storage.cdo.executors.TemplatedSimpleInTransactionExecutor;
import org.eclipse.opencert.storage.cdo.property.IOpencertClientConfigurationAdapter;
import org.eclipse.opencert.storage.cdo.property.OpencertPropertiesReader;

public class BasicArtefactStructureIATest {
    public static void main(String[] args) {
        ArrayList<ImpactSource> impactSources = new ArrayList<ImpactSource>();
        impactSources.add(BasicArtefactStructureIATest.createImpactSource("Artefact000", EventKind.MODIFICATION));
        System.out.println("----- IMPACT ANALYSIS VISUALIZATION -----");
        System.out.print("rootImpactingSources: ");
        for (ImpactSource impactSource : impactSources) {
            System.out.print("(");
            System.out.print(impactSource.getImpactingArtefactCdoId());
            System.out.print(", ");
            System.out.print(impactSource.getImpactingEventKind());
            System.out.print("), ");
        }
        System.out.println("-----------------------------------------\n\n");
        String result = BasicArtefactStructureIATest.performIASimulation(impactSources);
        System.out.println(result);
    }

    private static String performIASimulation(List<ImpactSource> impactSources) {
        String result = null;
        try (ImpactAnalyser impactAnalyser = new ImpactAnalyser((IOpencertClientConfigurationAdapter)OpencertPropertiesReader.getInstance());){
            List<IArtefactRelationImpact> artefactsRelationImpacts = impactAnalyser.listArtefactsRelationImpacts(impactSources);
            result = impactAnalyser.visualizeArtefactsRelationImpacts(artefactsRelationImpacts);
            impactAnalyser.executeArtefactsRelationImpacts(artefactsRelationImpacts);
        }
        return result;
    }

    private static ImpactSource createImpactSource(final String rootImpactingArtefact, EventKind rootEventKind) {
        Long initialArtefactCDOId = (Long)new TemplatedSimpleInTransactionExecutor<Long>(){

            public Long executeInTransaction(CDOTransaction cdoTransaction) {
                CDOQuery query = cdoTransaction.createQuery("sql", "select * from evidence_artefact where name ilike '" + rootImpactingArtefact + "'" + CDOStorageUtil.getMandatoryCDOQuerySuffix());
                Artefact artefact = (Artefact)query.getResultValue(Artefact.class);
                if (artefact == null) {
                    throw new RuntimeException("Root impacting artefact doesn't exist in database");
                }
                return CDOStorageUtil.getCDOId((EObject)artefact);
            }
        }.executeReadOnlyOperation();
        ImpactSource rootImpactSource = new ImpactSource(initialArtefactCDOId, rootEventKind);
        return rootImpactSource;
    }
}

