/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.opencert.infra.properties.property.components;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.eef.runtime.api.component.IPropertiesEditionComponent;
import org.eclipse.emf.eef.runtime.api.notify.EStructuralFeatureNotificationFilter;
import org.eclipse.emf.eef.runtime.api.notify.IPropertiesEditionEvent;
import org.eclipse.emf.eef.runtime.api.notify.NotificationFilter;
import org.eclipse.emf.eef.runtime.context.PropertiesEditingContext;
import org.eclipse.emf.eef.runtime.context.impl.EObjectPropertiesEditionContext;
import org.eclipse.emf.eef.runtime.context.impl.EReferencePropertiesEditionContext;
import org.eclipse.emf.eef.runtime.impl.components.SinglePartPropertiesEditingComponent;
import org.eclipse.emf.eef.runtime.impl.utils.EEFConverterUtil;
import org.eclipse.emf.eef.runtime.policies.PropertiesEditingPolicy;
import org.eclipse.emf.eef.runtime.policies.impl.CreateEditingPolicy;
import org.eclipse.emf.eef.runtime.providers.PropertiesEditingProvider;
import org.eclipse.emf.eef.runtime.ui.widgets.referencestable.ReferencesTableSettings;
import org.eclipse.emf.eef.runtime.ui.widgets.settings.EEFEditorSettings;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.opencert.infra.general.general.GeneralPackage;
import org.eclipse.opencert.infra.properties.property.Property;
import org.eclipse.opencert.infra.properties.property.PropertyModel;
import org.eclipse.opencert.infra.properties.property.PropertyPackage;
import org.eclipse.opencert.infra.properties.property.parts.PropertyModelPropertiesEditionPart;
import org.eclipse.opencert.infra.properties.property.parts.PropertyViewsRepository;

public class PropertyModelPropertiesEditionComponent
extends SinglePartPropertiesEditingComponent {
    public static String BASE_PART = "Base";
    protected ReferencesTableSettings hasPropertySettings;

    public PropertyModelPropertiesEditionComponent(PropertiesEditingContext editingContext, EObject propertyModel, String editing_mode) {
        super(editingContext, propertyModel, editing_mode);
        this.parts = new String[]{BASE_PART};
        this.repositoryKey = PropertyViewsRepository.class;
        this.partKey = PropertyViewsRepository.PropertyModel.class;
    }

    public void initPart(Object key, int kind, EObject elt, ResourceSet allResource) {
        this.setInitializing(true);
        if (this.editingPart != null && key == this.partKey) {
            this.editingPart.setContext(elt, allResource);
            PropertyModel propertyModel = (PropertyModel)elt;
            PropertyModelPropertiesEditionPart basePart = (PropertyModelPropertiesEditionPart)this.editingPart;
            if (this.isAccessible(PropertyViewsRepository.PropertyModel.Properties.id)) {
                basePart.setId(EEFConverterUtil.convertToString((EDataType)EcorePackage.Literals.ESTRING, (Object)propertyModel.getId()));
            }
            if (this.isAccessible(PropertyViewsRepository.PropertyModel.Properties.name)) {
                basePart.setName(EEFConverterUtil.convertToString((EDataType)EcorePackage.Literals.ESTRING, (Object)propertyModel.getName()));
            }
            if (this.isAccessible(PropertyViewsRepository.PropertyModel.Properties.description)) {
                basePart.setDescription(EEFConverterUtil.convertToString((EDataType)EcorePackage.Literals.ESTRING, (Object)propertyModel.getDescription()));
            }
            if (this.isAccessible(PropertyViewsRepository.PropertyModel.Properties.hasProperty)) {
                this.hasPropertySettings = new ReferencesTableSettings((EObject)propertyModel, new EReference[]{PropertyPackage.eINSTANCE.getPropertyModel_HasProperty()});
                basePart.initHasProperty(this.hasPropertySettings);
            }
            if (this.isAccessible(PropertyViewsRepository.PropertyModel.Properties.hasProperty)) {
                basePart.addFilterToHasProperty(new ViewerFilter(){

                    public boolean select(Viewer viewer, Object parentElement, Object element) {
                        return element instanceof String && element.equals("") || element instanceof Property;
                    }
                });
            }
        }
        this.setInitializing(false);
    }

    public EStructuralFeature associatedFeature(Object editorKey) {
        if (editorKey == PropertyViewsRepository.PropertyModel.Properties.id) {
            return GeneralPackage.eINSTANCE.getNamedElement_Id();
        }
        if (editorKey == PropertyViewsRepository.PropertyModel.Properties.name) {
            return GeneralPackage.eINSTANCE.getNamedElement_Name();
        }
        if (editorKey == PropertyViewsRepository.PropertyModel.Properties.description) {
            return GeneralPackage.eINSTANCE.getDescribableElement_Description();
        }
        if (editorKey == PropertyViewsRepository.PropertyModel.Properties.hasProperty) {
            return PropertyPackage.eINSTANCE.getPropertyModel_HasProperty();
        }
        return super.associatedFeature(editorKey);
    }

    public void updateSemanticModel(IPropertiesEditionEvent event) {
        PropertyModel propertyModel = (PropertyModel)this.semanticObject;
        if (PropertyViewsRepository.PropertyModel.Properties.id == event.getAffectedEditor()) {
            propertyModel.setId((String)EEFConverterUtil.createFromString((EDataType)EcorePackage.Literals.ESTRING, (String)((String)event.getNewValue())));
        }
        if (PropertyViewsRepository.PropertyModel.Properties.name == event.getAffectedEditor()) {
            propertyModel.setName((String)EEFConverterUtil.createFromString((EDataType)EcorePackage.Literals.ESTRING, (String)((String)event.getNewValue())));
        }
        if (PropertyViewsRepository.PropertyModel.Properties.description == event.getAffectedEditor()) {
            propertyModel.setDescription((String)EEFConverterUtil.createFromString((EDataType)EcorePackage.Literals.ESTRING, (String)((String)event.getNewValue())));
        }
        if (PropertyViewsRepository.PropertyModel.Properties.hasProperty == event.getAffectedEditor()) {
            if (event.getKind() == 3) {
                PropertiesEditingPolicy policy;
                EReferencePropertiesEditionContext context = new EReferencePropertiesEditionContext(this.editingContext, (IPropertiesEditionComponent)this, (EEFEditorSettings)this.hasPropertySettings, this.editingContext.getAdapterFactory());
                PropertiesEditingProvider provider = (PropertiesEditingProvider)this.editingContext.getAdapterFactory().adapt((Notifier)this.semanticObject, PropertiesEditingProvider.class);
                if (provider != null && (policy = provider.getPolicy((PropertiesEditingContext)context)) instanceof CreateEditingPolicy) {
                    policy.execute();
                }
            } else if (event.getKind() == 9) {
                PropertiesEditingPolicy editionPolicy;
                EObjectPropertiesEditionContext context = new EObjectPropertiesEditionContext(this.editingContext, (IPropertiesEditionComponent)this, (EObject)event.getNewValue(), this.editingContext.getAdapterFactory());
                PropertiesEditingProvider provider = (PropertiesEditingProvider)this.editingContext.getAdapterFactory().adapt((Notifier)((EObject)event.getNewValue()), PropertiesEditingProvider.class);
                if (provider != null && (editionPolicy = provider.getPolicy((PropertiesEditingContext)context)) != null) {
                    editionPolicy.execute();
                }
            } else if (event.getKind() == 4) {
                this.hasPropertySettings.removeFromReference((EObject)event.getNewValue());
            } else if (event.getKind() == 7) {
                this.hasPropertySettings.move(event.getNewIndex(), (EObject)((Property)event.getNewValue()));
            }
        }
    }

    public void updatePart(Notification msg) {
        super.updatePart(msg);
        if (this.editingPart.isVisible()) {
            PropertyModelPropertiesEditionPart basePart = (PropertyModelPropertiesEditionPart)this.editingPart;
            if (GeneralPackage.eINSTANCE.getNamedElement_Id().equals(msg.getFeature()) && msg.getNotifier().equals(this.semanticObject) && basePart != null && this.isAccessible(PropertyViewsRepository.PropertyModel.Properties.id)) {
                if (msg.getNewValue() != null) {
                    basePart.setId(EcoreUtil.convertToString((EDataType)EcorePackage.Literals.ESTRING, (Object)msg.getNewValue()));
                } else {
                    basePart.setId("");
                }
            }
            if (GeneralPackage.eINSTANCE.getNamedElement_Name().equals(msg.getFeature()) && msg.getNotifier().equals(this.semanticObject) && basePart != null && this.isAccessible(PropertyViewsRepository.PropertyModel.Properties.name)) {
                if (msg.getNewValue() != null) {
                    basePart.setName(EcoreUtil.convertToString((EDataType)EcorePackage.Literals.ESTRING, (Object)msg.getNewValue()));
                } else {
                    basePart.setName("");
                }
            }
            if (GeneralPackage.eINSTANCE.getDescribableElement_Description().equals(msg.getFeature()) && msg.getNotifier().equals(this.semanticObject) && basePart != null && this.isAccessible(PropertyViewsRepository.PropertyModel.Properties.description)) {
                if (msg.getNewValue() != null) {
                    basePart.setDescription(EcoreUtil.convertToString((EDataType)EcorePackage.Literals.ESTRING, (Object)msg.getNewValue()));
                } else {
                    basePart.setDescription("");
                }
            }
            if (PropertyPackage.eINSTANCE.getPropertyModel_HasProperty().equals(msg.getFeature()) && this.isAccessible(PropertyViewsRepository.PropertyModel.Properties.hasProperty)) {
                basePart.updateHasProperty();
            }
        }
    }

    protected NotificationFilter[] getNotificationFilters() {
        EStructuralFeatureNotificationFilter filter = new EStructuralFeatureNotificationFilter(new EStructuralFeature[]{GeneralPackage.eINSTANCE.getNamedElement_Id(), GeneralPackage.eINSTANCE.getNamedElement_Name(), GeneralPackage.eINSTANCE.getDescribableElement_Description(), PropertyPackage.eINSTANCE.getPropertyModel_HasProperty()});
        return new NotificationFilter[]{filter};
    }

    public Diagnostic validateValue(IPropertiesEditionEvent event) {
        Diagnostic ret = Diagnostic.OK_INSTANCE;
        if (event.getNewValue() != null) {
            try {
                Object newValue;
                if (PropertyViewsRepository.PropertyModel.Properties.id == event.getAffectedEditor()) {
                    newValue = event.getNewValue();
                    if (newValue instanceof String) {
                        newValue = EEFConverterUtil.createFromString((EDataType)GeneralPackage.eINSTANCE.getNamedElement_Id().getEAttributeType(), (String)((String)newValue));
                    }
                    ret = Diagnostician.INSTANCE.validate(GeneralPackage.eINSTANCE.getNamedElement_Id().getEAttributeType(), newValue);
                }
                if (PropertyViewsRepository.PropertyModel.Properties.name == event.getAffectedEditor()) {
                    newValue = event.getNewValue();
                    if (newValue instanceof String) {
                        newValue = EEFConverterUtil.createFromString((EDataType)GeneralPackage.eINSTANCE.getNamedElement_Name().getEAttributeType(), (String)((String)newValue));
                    }
                    ret = Diagnostician.INSTANCE.validate(GeneralPackage.eINSTANCE.getNamedElement_Name().getEAttributeType(), newValue);
                }
                if (PropertyViewsRepository.PropertyModel.Properties.description == event.getAffectedEditor()) {
                    newValue = event.getNewValue();
                    if (newValue instanceof String) {
                        newValue = EEFConverterUtil.createFromString((EDataType)GeneralPackage.eINSTANCE.getDescribableElement_Description().getEAttributeType(), (String)((String)newValue));
                    }
                    ret = Diagnostician.INSTANCE.validate(GeneralPackage.eINSTANCE.getDescribableElement_Description().getEAttributeType(), newValue);
                }
            }
            catch (IllegalArgumentException iae) {
                ret = BasicDiagnostic.toDiagnostic((Throwable)iae);
            }
            catch (WrappedException we) {
                ret = BasicDiagnostic.toDiagnostic((Throwable)we);
            }
        }
        return ret;
    }
}

