/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.cdo.internal.core.exporter;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.URI;
import org.eclipse.osgi.util.NLS;
import org.eclipse.papyrus.cdo.core.exporter.IModelExportMapping;
import org.eclipse.papyrus.cdo.core.importer.IModelTransferConfiguration;
import org.eclipse.papyrus.cdo.core.importer.IModelTransferNode;
import org.eclipse.papyrus.cdo.internal.core.importer.AbstractModelTransferMapping;
import org.eclipse.papyrus.cdo.internal.core.l10n.Messages;

public class ModelExportMapping
extends AbstractModelTransferMapping
implements IModelExportMapping {
    private final IWorkspaceRoot wsRoot = ResourcesPlugin.getWorkspace().getRoot();

    public ModelExportMapping(IModelTransferConfiguration config) {
        super(config);
    }

    @Override
    protected boolean validateMapping(IModelTransferNode node, DiagnosticChain diagnostics) {
        boolean result = true;
        IPath mapping = this.getMapping(node);
        if (mapping == null) {
            diagnostics.add((Diagnostic)new BasicDiagnostic(4, "org.eclipse.papyrus.cdo.core", 0, NLS.bind((String)Messages.ModelExportMapping_0, (Object)node.getName()), new Object[]{node}));
            result = false;
        } else {
            for (URI next : node.getResourceURIs()) {
                IFile file;
                IFolder container;
                IPath resourcePath = mapping.removeFileExtension().addFileExtension(next.fileExtension());
                IPath containerPath = mapping.removeLastSegments(1);
                Object object = container = containerPath.segmentCount() == 1 ? this.wsRoot.getProject(containerPath.segment(0)) : this.wsRoot.getFolder(containerPath);
                if (!container.getProject().exists()) {
                    diagnostics.add((Diagnostic)new BasicDiagnostic(4, "org.eclipse.papyrus.cdo.core", 0, NLS.bind((String)Messages.ModelExportMapping_1, (Object)mapping, (Object)node.getName()), new Object[]{node}));
                    result = false;
                    break;
                }
                if (!container.exists()) {
                    file = this.wsRoot.getFile(containerPath);
                    if (!file.exists()) continue;
                    diagnostics.add((Diagnostic)new BasicDiagnostic(4, "org.eclipse.papyrus.cdo.core", 0, NLS.bind((String)Messages.ModelExportMapping_2, (Object)containerPath, (Object)node.getName()), new Object[]{node}));
                    result = false;
                    break;
                }
                file = this.wsRoot.getFile(resourcePath);
                if (file.exists()) {
                    diagnostics.add((Diagnostic)new BasicDiagnostic(4, "org.eclipse.papyrus.cdo.core", 0, NLS.bind((String)Messages.ModelExportMapping_3, (Object)resourcePath, (Object)node.getName()), new Object[]{node}));
                    result = false;
                    break;
                }
                IStatus status = this.wsRoot.getWorkspace().validatePath(resourcePath.toString(), 1);
                if (status.isOK()) continue;
                diagnostics.add(BasicDiagnostic.toDiagnostic((IStatus)status));
                if (status.getSeverity() <= 2) continue;
                result = false;
                break;
            }
        }
        return result;
    }
}

