/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.cdo.internal.core.services.localizer;

import org.eclipse.emf.cdo.eresource.CDOResource;
import org.eclipse.emf.cdo.eresource.CDOResourceNode;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.papyrus.cdo.internal.core.CDOUtils;
import org.eclipse.papyrus.infra.core.services.SharedServiceFactory;
import org.eclipse.papyrus.infra.services.localizer.DefaultObjectLocalizer;
import org.eclipse.papyrus.infra.services.localizer.IObjectLocalizer;

public class CDOAwareObjectLocalizer
extends DefaultObjectLocalizer {
    public EObject getLocalEObject(ResourceSet localSet, EObject remoteObject) {
        EObject result = null;
        if (!(remoteObject instanceof CDOResourceNode)) {
            result = super.getLocalEObject(localSet, remoteObject);
        } else if (remoteObject instanceof CDOResource) {
            result = (CDOResource)this.getLocalResource(localSet, (Resource)((CDOResource)remoteObject));
        } else {
            CDOResourceNode node = (CDOResourceNode)remoteObject;
            String path = node.getPath();
            CDOView view = CDOUtils.getView(localSet);
            if (view != null) {
                try {
                    result = view.getResourceNode(path);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return result;
    }

    public Resource getLocalResource(ResourceSet localSet, Resource remoteResource) {
        Resource result = null;
        if (!(remoteResource instanceof CDOResource)) {
            result = super.getLocalResource(localSet, remoteResource);
        } else {
            CDOResource cdo = (CDOResource)remoteResource;
            String path = cdo.getPath();
            CDOView view = CDOUtils.getView(localSet);
            if (view != null) {
                try {
                    result = view.getResource(path);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return result;
    }

    public static class Factory
    extends SharedServiceFactory<IObjectLocalizer> {
        public Factory() {
            super(IObjectLocalizer.class, CDOAwareObjectLocalizer::new);
        }
    }
}

