/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.opencert.infra.general.general;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum RequirementRelKind implements Enumerator
{
    AND(0, "AND", "AND"),
    OR(1, "OR", "OR"),
    XOR(2, "XOR", "XOR"),
    REQUIRES(3, "Requires", "Requires"),
    CONTRIBUTES_TO(4, "ContributesTo", "ContributesTo");

    public static final int AND_VALUE = 0;
    public static final int OR_VALUE = 1;
    public static final int XOR_VALUE = 2;
    public static final int REQUIRES_VALUE = 3;
    public static final int CONTRIBUTES_TO_VALUE = 4;
    private static final RequirementRelKind[] VALUES_ARRAY;
    public static final List<RequirementRelKind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new RequirementRelKind[]{AND, OR, XOR, REQUIRES, CONTRIBUTES_TO};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static RequirementRelKind get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            RequirementRelKind result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static RequirementRelKind getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            RequirementRelKind result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static RequirementRelKind get(int value) {
        switch (value) {
            case 0: {
                return AND;
            }
            case 1: {
                return OR;
            }
            case 2: {
                return XOR;
            }
            case 3: {
                return REQUIRES;
            }
            case 4: {
                return CONTRIBUTES_TO;
            }
        }
        return null;
    }

    private RequirementRelKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

