/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.repo.channel;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;

public class ChannelId {
    private final String id;
    private final Set<String> names;
    private final String description;

    public ChannelId(String id) {
        this(id, Collections.emptySet(), null);
    }

    public ChannelId(String id, Set<String> names, String description) {
        Objects.requireNonNull(id);
        Objects.requireNonNull(names);
        this.id = id;
        this.names = Collections.unmodifiableSet(new LinkedHashSet<String>(names));
        if (this.id == null) {
            throw new NullPointerException("'id' must not be null");
        }
        this.description = description;
    }

    public String getId() {
        return this.id;
    }

    public Set<String> getNames() {
        return this.names;
    }

    public String getDescription() {
        return this.description;
    }

    public String makeTitle() {
        String desc = this.description;
        if (desc != null && !desc.isEmpty()) {
            return String.format("%s (%s)", this.id, desc);
        }
        return this.id;
    }
}

