/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.web.common.menu;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import java.util.function.Function;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.packagedrone.web.common.InterfaceExtender;
import org.eclipse.packagedrone.web.common.menu.Entry;
import org.eclipse.packagedrone.web.common.menu.Menu;
import org.eclipse.packagedrone.web.common.menu.MenuEntry;
import org.eclipse.packagedrone.web.common.menu.Node;
import org.eclipse.packagedrone.web.common.menu.SubMenu;
import org.osgi.framework.FrameworkUtil;
import org.osgi.util.tracker.ServiceTracker;

public class MenuManagerImpl {
    private final ServiceTracker<InterfaceExtender, InterfaceExtender> tracker = new ServiceTracker(FrameworkUtil.getBundle(MenuManagerImpl.class).getBundleContext(), InterfaceExtender.class, null);

    public MenuManagerImpl() {
        this.tracker.open();
    }

    public void close() {
        this.tracker.close();
    }

    public Menu getMainMenu(HttpServletRequest request) {
        return this.getEntries(i -> i.getMainMenuEntries(request));
    }

    public Menu getActions(HttpServletRequest request, Object context) {
        return this.getEntries(i -> i.getActions(request, context));
    }

    public Menu getViews(HttpServletRequest request, Object context) {
        return this.getEntries(i -> i.getViews(request, context));
    }

    protected Menu getEntries(Function<InterfaceExtender, List<MenuEntry>> func) {
        LinkedList<MenuEntry> result = new LinkedList<MenuEntry>();
        for (InterfaceExtender me : this.tracker.getTracked().values()) {
            List<MenuEntry> actions = func.apply(me);
            if (actions == null) continue;
            result.addAll(actions);
        }
        return this.convert(result);
    }

    protected Menu convert(List<MenuEntry> entries) {
        LinkedList<Node> nodes;
        if (entries == null) {
            return null;
        }
        entries = this.condenseCategories(entries);
        Collections.sort(entries);
        LinkedList<Node> currentNodes = nodes = new LinkedList<Node>();
        String currentCategory = null;
        for (MenuEntry entry : entries) {
            if (entry.getCategory() == null) {
                currentNodes = nodes;
                currentCategory = null;
            } else if (currentCategory == null || !currentCategory.equals(entry.getCategory())) {
                currentNodes = new LinkedList();
                currentCategory = entry.getCategory();
                nodes.add(new SubMenu(UUID.randomUUID().toString(), entry.getCategory(), currentNodes));
            }
            currentNodes.add(this.convertEntry(entry));
        }
        return new Menu(nodes);
    }

    private List<MenuEntry> condenseCategories(List<MenuEntry> entries) {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        for (MenuEntry entry : entries) {
            String cat = entry.getCategory();
            if (cat == null) continue;
            Integer prio = (Integer)map.get(cat);
            if (prio == null && entry.getCategoryOrder() != Integer.MAX_VALUE) {
                map.put(cat, entry.getCategoryOrder());
                continue;
            }
            if (prio == null || entry.getCategoryOrder() >= prio) continue;
            map.put(cat, entry.getCategoryOrder());
        }
        ArrayList<MenuEntry> result = new ArrayList<MenuEntry>(entries.size());
        for (MenuEntry entry : entries) {
            String cat = entry.getCategory();
            if (cat == null) {
                result.add(entry);
                continue;
            }
            Integer prio = (Integer)map.get(cat);
            if (prio == null) {
                result.add(entry);
                map.put(cat, entry.getCategoryOrder());
                continue;
            }
            result.add(new MenuEntry(entry.getCategory(), prio, entry.getLabel(), entry.getEntryOrder(), entry.getTarget(), entry.getModifier(), entry.getIcon(), entry.isNewWindow(), entry.getBadge()));
        }
        return result;
    }

    private Entry convertEntry(MenuEntry entry) {
        return new Entry(UUID.randomUUID().toString(), entry.getLabel(), entry.getTarget(), entry.getModifier(), entry.getIcon(), entry.isNewWindow(), entry.getBadge(), entry.getModal());
    }
}

