/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.repo;

import java.lang.reflect.Field;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.packagedrone.repo.BindingConverter;
import org.eclipse.packagedrone.repo.MetaKey;
import org.eclipse.packagedrone.repo.MetaKeyBinding;
import org.eclipse.packagedrone.utils.converter.ConverterManager;

public final class MetaKeys {
    private MetaKeys() {
    }

    public static String getString(Map<MetaKey, String> metadata, String ns, String key) {
        return MetaKeys.getString(metadata, ns, key, null);
    }

    public static String getString(Map<MetaKey, String> metadata, String ns, String key, String defaultValue) {
        if (metadata == null) {
            return defaultValue;
        }
        String result = metadata.get(new MetaKey(ns, key));
        if (result == null) {
            return defaultValue;
        }
        return result;
    }

    public static <T> T bind(T data, Map<MetaKey, String> metadata) throws Exception {
        ConverterManager converter = ConverterManager.create();
        if (data == null) {
            return null;
        }
        LinkedList<Field> fields = new LinkedList<Field>();
        MetaKeys.findFields(data.getClass(), fields);
        for (Field field : fields) {
            MetaKeyBinding mkb = field.getAnnotation(MetaKeyBinding.class);
            String stringValue = metadata.get(new MetaKey(mkb.namespace(), mkb.key()));
            Object value = stringValue == null ? null : (!mkb.converterClass().isInterface() ? mkb.converterClass().newInstance().decode(stringValue) : converter.convertTo((Object)stringValue, field.getType()));
            if (value == null && mkb.ignoreNull()) continue;
            MetaKeys.setValue(field, data, value);
        }
        return data;
    }

    public static final Map<MetaKey, String> unbind(Object data) throws Exception {
        ConverterManager converter = ConverterManager.create();
        if (data == null) {
            return null;
        }
        LinkedList<Field> fields = new LinkedList<Field>();
        MetaKeys.findFields(data.getClass(), fields);
        HashMap<MetaKey, String> result = new HashMap<MetaKey, String>(fields.size());
        for (Field field : fields) {
            String stringValue;
            MetaKeyBinding mkb = field.getAnnotation(MetaKeyBinding.class);
            Object value = MetaKeys.getValue(field, data);
            if (!mkb.converterClass().isInterface()) {
                BindingConverter cvt = mkb.converterClass().newInstance();
                stringValue = cvt.encode(value);
            } else {
                stringValue = (String)converter.convertTo(value, String.class);
            }
            if ((stringValue == null || stringValue.isEmpty()) && mkb.emptyAsNull()) {
                result.put(new MetaKey(mkb.namespace(), mkb.key()), null);
                continue;
            }
            result.put(new MetaKey(mkb.namespace(), mkb.key()), stringValue);
        }
        return result;
    }

    private static Object getValue(Field field, Object data) throws IllegalArgumentException, IllegalAccessException {
        if (field.isAccessible()) {
            return field.get(data);
        }
        field.setAccessible(true);
        try {
            Object object = field.get(data);
            return object;
        }
        finally {
            field.setAccessible(false);
        }
    }

    private static void setValue(Field field, Object target, Object value) throws IllegalArgumentException, IllegalAccessException {
        if (field.isAccessible()) {
            MetaKeys.internalSetField(field, target, value);
        } else {
            field.setAccessible(true);
            try {
                MetaKeys.internalSetField(field, target, value);
            }
            finally {
                field.setAccessible(false);
            }
        }
    }

    protected static void internalSetField(Field field, Object target, Object value) throws IllegalAccessException {
        if (value != null || !field.getType().isPrimitive()) {
            field.set(target, value);
        }
    }

    private static void findFields(Class<?> clazz, List<Field> result) throws SecurityException {
        if (clazz == null) {
            return;
        }
        Field[] fieldArray = clazz.getDeclaredFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field f = fieldArray[n2];
            if (f.isAnnotationPresent(MetaKeyBinding.class)) {
                result.add(f);
            }
            ++n2;
        }
        MetaKeys.findFields(clazz.getSuperclass(), result);
    }

    public static Map<MetaKey, String> union(Map<MetaKey, String> providedMetaData, Map<MetaKey, String> extractedMetaData) {
        int size1 = providedMetaData != null ? providedMetaData.size() : 0;
        int size2 = extractedMetaData != null ? extractedMetaData.size() : 0;
        HashMap<MetaKey, String> result = new HashMap<MetaKey, String>(size1 + size2);
        if (extractedMetaData != null) {
            result.putAll(extractedMetaData);
        }
        if (providedMetaData != null) {
            result.putAll(providedMetaData);
        }
        return Collections.unmodifiableMap(result);
    }
}

