/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.repo.adapter.deb.web;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.servlet.annotation.HttpConstraint;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.eclipse.packagedrone.repo.MetaKeys;
import org.eclipse.packagedrone.repo.adapter.deb.ChannelConfiguration;
import org.eclipse.packagedrone.repo.channel.ChannelInformation;
import org.eclipse.packagedrone.repo.channel.ChannelService;
import org.eclipse.packagedrone.repo.channel.ModifiableChannel;
import org.eclipse.packagedrone.repo.channel.ReadableChannel;
import org.eclipse.packagedrone.repo.signing.web.SigningServiceEntry;
import org.eclipse.packagedrone.repo.web.utils.Channels;
import org.eclipse.packagedrone.sec.web.controller.HttpContraintControllerInterceptor;
import org.eclipse.packagedrone.sec.web.controller.Secured;
import org.eclipse.packagedrone.sec.web.controller.SecuredControllerInterceptor;
import org.eclipse.packagedrone.web.Controller;
import org.eclipse.packagedrone.web.LinkTarget;
import org.eclipse.packagedrone.web.ModelAndView;
import org.eclipse.packagedrone.web.RequestMapping;
import org.eclipse.packagedrone.web.RequestMethod;
import org.eclipse.packagedrone.web.ViewResolver;
import org.eclipse.packagedrone.web.common.InterfaceExtender;
import org.eclipse.packagedrone.web.common.Modifier;
import org.eclipse.packagedrone.web.common.menu.MenuEntry;
import org.eclipse.packagedrone.web.controller.ControllerInterceptor;
import org.eclipse.packagedrone.web.controller.ControllerInterceptors;
import org.eclipse.packagedrone.web.controller.binding.BindingResult;
import org.eclipse.packagedrone.web.controller.binding.PathVariable;
import org.eclipse.packagedrone.web.controller.form.FormData;

@Controller
@ViewResolver(value="/WEB-INF/views/config/%s.jsp")
@Secured
@RequestMapping(value={"/config/deb"})
@ControllerInterceptors(value={@ControllerInterceptor(value=SecuredControllerInterceptor.class), @ControllerInterceptor(value=HttpContraintControllerInterceptor.class)})
@HttpConstraint(rolesAllowed={"MANAGER"})
public class ConfigController
implements InterfaceExtender {
    private ChannelService service;

    public void setService(ChannelService service) {
        this.service = service;
    }

    public List<MenuEntry> getActions(HttpServletRequest request, Object object) {
        if (object instanceof ChannelInformation) {
            LinkedList<MenuEntry> result = new LinkedList<MenuEntry>();
            ChannelInformation channel = (ChannelInformation)object;
            if (channel.hasAspect("apt")) {
                HashMap<String, String> model = new HashMap<String, String>();
                model.put("channelId", channel.getId());
                result.add(new MenuEntry("APT Repository", 1500, new LinkTarget("/apt/" + channel.getId()), Modifier.LINK, null));
            }
            return result;
        }
        return null;
    }

    public List<MenuEntry> getViews(HttpServletRequest request, Object object) {
        if (object instanceof ChannelInformation) {
            LinkedList<MenuEntry> result = new LinkedList<MenuEntry>();
            ChannelInformation channel = (ChannelInformation)object;
            if (channel.hasAspect("apt")) {
                HashMap<String, String> model = new HashMap<String, String>();
                model.put("channelId", channel.getId());
                if (request.isUserInRole("MANAGER")) {
                    result.add(new MenuEntry("APT", 1500, LinkTarget.createFromController(ConfigController.class, (String)"edit").expand(model), null, null));
                }
            }
            return result;
        }
        return null;
    }

    @RequestMapping(value={"/channel/{channelId}/edit"})
    public ModelAndView edit(@PathVariable(value="channelId") String channelId) throws Exception {
        return Channels.withChannel((ChannelService)this.service, (String)channelId, ReadableChannel.class, channel -> {
            HashMap<String, Object> model = new HashMap<String, Object>();
            model.put("channel", channel.getInformation());
            model.put("signingServices", SigningServiceEntry.getSigningServices());
            ChannelConfiguration dist = new ChannelConfiguration();
            dist.setDistribution("default");
            dist.setDefaultComponent("main");
            dist.getArchitectures().add("i386");
            dist.getArchitectures().add("amd64");
            MetaKeys.bind((Object)dist, (Map)channel.getMetaData());
            model.put("command", dist);
            return new ModelAndView("edit", model);
        });
    }

    @RequestMapping(value={"/channel/{channelId}/edit"}, method={RequestMethod.POST})
    public ModelAndView editPost(@PathVariable(value="channelId") String channelId, @Valid @FormData(value="command") ChannelConfiguration cfg, BindingResult result) throws Exception {
        return Channels.withChannel((ChannelService)this.service, (String)channelId, ModifiableChannel.class, channel -> {
            HashMap<String, Object> model = new HashMap<String, Object>(2);
            if (!result.hasErrors()) {
                Map md = MetaKeys.unbind((Object)cfg);
                channel.applyMetaData(md);
            }
            model.put("channel", channel.getInformation());
            model.put("signingServices", SigningServiceEntry.getSigningServices());
            return new ModelAndView("edit", model);
        });
    }
}

