/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.repo.channel.apm;

import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.packagedrone.repo.MetaKey;
import org.eclipse.packagedrone.repo.Severity;
import org.eclipse.packagedrone.repo.channel.ArtifactInformation;
import org.eclipse.packagedrone.repo.channel.CacheEntryInformation;
import org.eclipse.packagedrone.repo.channel.ChannelState;
import org.eclipse.packagedrone.repo.channel.ValidationMessage;
import org.eclipse.packagedrone.repo.channel.apm.ModifyContextImpl;
import org.eclipse.packagedrone.repo.channel.apm.store.BlobStore;
import org.eclipse.packagedrone.repo.channel.apm.store.CacheStore;
import org.osgi.service.event.EventAdmin;

public class ChannelReader
implements AutoCloseable {
    private final InputStream stream;
    private final String channelId;
    private final EventAdmin eventAdmin;
    private final BlobStore store;
    private final CacheStore cacheStore;
    private final DateFormat dateFormat;
    private long numberOfBytes;

    public ChannelReader(InputStream stream, String channelId, EventAdmin eventAdmin, BlobStore store, CacheStore cacheStore) {
        this.stream = stream;
        this.channelId = channelId;
        this.eventAdmin = eventAdmin;
        this.store = store;
        this.cacheStore = cacheStore;
        this.dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
    }

    public ModifyContextImpl read() throws IOException {
        this.numberOfBytes = 0L;
        InputStreamReader reader = new InputStreamReader(this.stream, StandardCharsets.UTF_8);
        ChannelState.Builder state = new ChannelState.Builder();
        Boolean locked = null;
        Map<MetaKey, CacheEntryInformation> cacheEntries = Collections.emptyMap();
        Map<String, ArtifactInformation> artifacts = Collections.emptyMap();
        Map<MetaKey, String> extractedMetaData = Collections.emptyMap();
        Map<MetaKey, String> providedMetaData = Collections.emptyMap();
        HashMap<String, String> aspects = new HashMap();
        JsonReader jr = new JsonReader((Reader)reader);
        jr.beginObject();
        while (jr.hasNext()) {
            String name;
            switch (name = jr.nextName()) {
                case "locked": {
                    locked = jr.nextBoolean();
                    state.setLocked(locked.booleanValue());
                    break;
                }
                case "creationTimestamp": {
                    state.setCreationTimestamp(this.readTime(jr));
                    break;
                }
                case "modificationTimestamp": {
                    state.setModificationTimestamp(this.readTime(jr));
                    break;
                }
                case "cacheEntries": {
                    cacheEntries = this.readCacheEntries(jr);
                    break;
                }
                case "artifacts": {
                    artifacts = this.readArtifacts(jr);
                    break;
                }
                case "extractedMetaData": {
                    extractedMetaData = this.readMetadata(jr);
                    break;
                }
                case "providedMetaData": {
                    providedMetaData = this.readMetadata(jr);
                    break;
                }
                case "validationMessages": {
                    state.setValidationMessages(this.readValidationMessages(jr));
                    break;
                }
                case "aspects": {
                    aspects = this.readAspects(jr);
                    break;
                }
                default: {
                    jr.skipValue();
                }
            }
        }
        jr.endObject();
        if (locked == null) {
            throw new IOException("Missing values for channel");
        }
        state.setNumberOfArtifacts((long)artifacts.size());
        state.setNumberOfBytes(this.numberOfBytes);
        return new ModifyContextImpl(this.channelId, this.eventAdmin, this.store, this.cacheStore, state.build(), aspects, artifacts, cacheEntries, extractedMetaData, providedMetaData);
    }

    private Map<String, String> readAspects(JsonReader jr) throws IOException {
        HashMap<String, String> result = new HashMap<String, String>();
        jr.beginObject();
        while (jr.hasNext()) {
            switch (jr.nextName()) {
                case "map": {
                    jr.beginObject();
                    while (jr.hasNext()) {
                        String id = jr.nextName();
                        String value = null;
                        if (jr.peek() == JsonToken.STRING) {
                            value = jr.nextString();
                        } else {
                            jr.skipValue();
                        }
                        result.put(id, value);
                    }
                    jr.endObject();
                }
            }
        }
        jr.endObject();
        return result;
    }

    private Map<String, ArtifactInformation> readArtifacts(JsonReader jr) throws IOException {
        jr.beginObject();
        HashMap<String, ArtifactInformation> result = new HashMap<String, ArtifactInformation>();
        while (jr.hasNext()) {
            String id = jr.nextName();
            jr.beginObject();
            String name = null;
            Long size = null;
            Instant creationTimestamp = null;
            String parentId = null;
            Set<Object> childIds = Collections.emptySet();
            Set<Object> facets = Collections.emptySet();
            String virtualizerAspectId = null;
            List<Object> validationMessages = Collections.emptyList();
            Map<Object, Object> extractedMetaData = Collections.emptyMap();
            Map<Object, Object> providedMetaData = Collections.emptyMap();
            while (jr.hasNext()) {
                String ele;
                switch (ele = jr.nextName()) {
                    case "name": {
                        name = jr.nextString();
                        break;
                    }
                    case "size": {
                        size = jr.nextLong();
                        break;
                    }
                    case "date": {
                        creationTimestamp = this.readTime(jr);
                        break;
                    }
                    case "parentId": {
                        parentId = jr.nextString();
                        break;
                    }
                    case "childIds": {
                        childIds = this.readSet(jr);
                        break;
                    }
                    case "facets": {
                        facets = this.readSet(jr);
                        break;
                    }
                    case "virtualizerAspectId": {
                        virtualizerAspectId = jr.nextString();
                        break;
                    }
                    case "extractedMetaData": {
                        extractedMetaData = this.readMetadata(jr);
                        break;
                    }
                    case "providedMetaData": {
                        providedMetaData = this.readMetadata(jr);
                        break;
                    }
                    case "validationMessages": {
                        validationMessages = this.readValidationMessages(jr);
                        break;
                    }
                    default: {
                        jr.skipValue();
                    }
                }
            }
            jr.endObject();
            if (id == null || name == null || size == null || creationTimestamp == null) {
                throw new IOException("Missing values for artifact");
            }
            this.numberOfBytes += size.longValue();
            result.put(id, new ArtifactInformation(id, parentId, childIds, name, size.longValue(), creationTimestamp, facets, validationMessages, providedMetaData, extractedMetaData, virtualizerAspectId));
        }
        jr.endObject();
        return result;
    }

    private Map<MetaKey, String> readMetadata(JsonReader jr) throws IOException {
        HashMap<MetaKey, String> result = new HashMap<MetaKey, String>();
        jr.beginObject();
        while (jr.hasNext()) {
            String name = jr.nextName();
            if (jr.peek() == JsonToken.NULL) {
                jr.skipValue();
                continue;
            }
            String value = jr.nextString();
            result.put(MetaKey.fromString((String)name), value);
        }
        jr.endObject();
        return result;
    }

    private List<ValidationMessage> readValidationMessages(JsonReader jr) throws IOException {
        LinkedList<ValidationMessage> result = new LinkedList<ValidationMessage>();
        jr.beginArray();
        while (jr.hasNext()) {
            result.add(this.readValidationMessage(jr));
        }
        jr.endArray();
        return result;
    }

    private ValidationMessage readValidationMessage(JsonReader jr) throws IOException {
        String aspectId = null;
        Severity severity = null;
        String message = null;
        Set<Object> artifactIds = Collections.emptySet();
        jr.beginObject();
        while (jr.hasNext()) {
            String name;
            switch (name = jr.nextName()) {
                case "aspectId": {
                    aspectId = jr.nextString();
                    break;
                }
                case "severity": {
                    severity = Severity.valueOf((String)jr.nextString());
                    break;
                }
                case "message": {
                    message = jr.nextString();
                    break;
                }
                case "artifactIds": {
                    artifactIds = this.readSet(jr);
                }
            }
        }
        jr.endObject();
        if (aspectId == null || severity == null || message == null) {
            throw new IOException("Missing values in validation message");
        }
        return new ValidationMessage(aspectId, severity, message, artifactIds);
    }

    private Set<String> readSet(JsonReader jr) throws IOException {
        HashSet<String> result = new HashSet<String>();
        jr.beginArray();
        while (jr.hasNext()) {
            result.add(jr.nextString());
        }
        jr.endArray();
        return result;
    }

    private Map<MetaKey, CacheEntryInformation> readCacheEntries(JsonReader jr) throws IOException {
        HashMap<MetaKey, CacheEntryInformation> result = new HashMap<MetaKey, CacheEntryInformation>();
        jr.beginObject();
        while (jr.hasNext()) {
            String entryName = jr.nextName();
            jr.beginObject();
            String name = null;
            Long size = null;
            String mimeType = null;
            Instant timestamp = null;
            while (jr.hasNext()) {
                String ele;
                switch (ele = jr.nextName()) {
                    case "name": {
                        name = jr.nextString();
                        break;
                    }
                    case "size": {
                        size = jr.nextLong();
                        break;
                    }
                    case "mimeType": {
                        mimeType = jr.nextString();
                        break;
                    }
                    case "timestamp": {
                        timestamp = this.readTime(jr);
                        break;
                    }
                    default: {
                        jr.skipValue();
                    }
                }
            }
            if (name == null || size == null || mimeType == null || timestamp == null) {
                throw new IOException("Invalid format");
            }
            jr.endObject();
            MetaKey key = MetaKey.fromString((String)entryName);
            result.put(key, new CacheEntryInformation(key, name, size.longValue(), mimeType, timestamp));
        }
        jr.endObject();
        return result;
    }

    private Instant readTime(JsonReader jr) throws IOException {
        JsonToken peek = jr.peek();
        if (peek == JsonToken.NUMBER) {
            return Instant.ofEpochMilli(jr.nextLong());
        }
        if (peek == JsonToken.NULL) {
            jr.nextNull();
            return null;
        }
        if (peek == JsonToken.STRING) {
            String str = jr.nextString();
            try {
                return Instant.ofEpochMilli(Long.parseLong(str));
            }
            catch (NumberFormatException numberFormatException) {
                try {
                    return this.dateFormat.parse(str).toInstant();
                }
                catch (ParseException e2) {
                    throw new IOException(e2);
                }
            }
        }
        throw new IOException(String.format("Invalid timestamp token: %s", peek));
    }

    @Override
    public void close() throws IOException {
        this.stream.close();
    }
}

