/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.repo.importer.http.web;

import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import org.eclipse.packagedrone.VersionInformation;
import org.eclipse.packagedrone.job.AbstractJsonJobFactory;
import org.eclipse.packagedrone.job.JobFactoryDescriptor;
import org.eclipse.packagedrone.job.JobInstance;
import org.eclipse.packagedrone.repo.importer.http.Configuration;
import org.eclipse.packagedrone.repo.importer.http.HttpImporter;
import org.eclipse.packagedrone.repo.importer.http.web.TestResult;
import org.eclipse.packagedrone.web.LinkTarget;

public class DownloadTester
extends AbstractJsonJobFactory<Configuration, TestResult> {
    public static final String ID = "org.eclipse.packagedrone.repo.importer.http.web.tester";
    private static final JobFactoryDescriptor DESCRIPTOR = new JobFactoryDescriptor(){

        public LinkTarget getResultTarget() {
            return null;
        }
    };

    public DownloadTester() {
        super(Configuration.class);
    }

    protected TestResult process(JobInstance.Context context, Configuration cfg) throws Exception {
        HttpURLConnection httpCon;
        TestResult result = new TestResult();
        URL url = new URL(cfg.getUrl());
        URLConnection con = url.openConnection();
        con.setRequestProperty("User-Agent", VersionInformation.USER_AGENT);
        if (con instanceof HttpURLConnection) {
            httpCon = (HttpURLConnection)con;
            httpCon.setRequestMethod("HEAD");
        }
        con.connect();
        if (con instanceof HttpURLConnection) {
            httpCon = (HttpURLConnection)con;
            result.setReturnCode(httpCon.getResponseCode());
            long length = httpCon.getContentLengthLong();
            result.setContentLength(length);
        }
        String name = HttpImporter.makeName((Configuration)cfg, (URL)url, (URLConnection)con);
        result.setName(name);
        return result;
    }

    protected String makeLabelFromData(Configuration data) {
        return String.format("Test download from: %s", data.getUrl());
    }

    public JobFactoryDescriptor getDescriptor() {
        return DESCRIPTOR;
    }
}

